/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.collect.Queues;
import java.util.HashSet;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

public class CallbackHandler {
    private static final Queue<DelayedCallback> DELAYED_CALLBACKS = Queues.newConcurrentLinkedQueue();
    public static boolean FLUSHING = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Queue<DelayedCallback> getDelayedQueue() {
        Queue<DelayedCallback> queue = DELAYED_CALLBACKS;
        synchronized (queue) {
            return DELAYED_CALLBACKS;
        }
    }

    public static void addFastCallback(Runnable callback) {
        CallbackHandler.addCallback(0, callback);
    }

    public static void addCallback(int delay, Runnable callback) {
        CallbackHandler.getDelayedQueue().add(new DelayedCallback(delay, callback));
    }

    public static void flushTasks() {
        FLUSHING = true;
        Queue<DelayedCallback> callbacks = CallbackHandler.getDelayedQueue();
        callbacks.forEach(callback -> callback.task.run());
        callbacks.clear();
        FLUSHING = false;
    }

    public static void tick() {
        Queue<DelayedCallback> callbacks = CallbackHandler.getDelayedQueue();
        if (callbacks.isEmpty()) {
            return;
        }
        HashSet toRemove = new HashSet();
        callbacks.forEach(callback -> {
            if (callback.delay.getAndDecrement() <= 0) {
                callback.task.run();
                toRemove.add(callback);
            }
        });
        callbacks.removeAll(toRemove);
    }

    public static class DelayedCallback {
        final AtomicInteger delay;
        final Runnable task;

        DelayedCallback(int delay, Runnable task) {
            this.delay = new AtomicInteger(delay);
            this.task = task;
        }
    }
}

