/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.stream.JsonReader;
import com.mojang.authlib.GameProfile;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.UUID;
import net.minecraft.util.HttpUtil;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.StringUtils;

public record ContributorStore(ImmutableSet<UUID> uuids) {
    public boolean contains(Player player) {
        return this.contains(Player.m_36198_((GameProfile)player.m_36316_()));
    }

    public boolean contains(UUID uuid) {
        return this.uuids.contains((Object)uuid);
    }

    public boolean contains(String uuidString) {
        return this.uuids.stream().anyMatch(p -> p.toString().equals(uuidString));
    }

    public boolean isEmpty() {
        return this.uuids.isEmpty();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof ContributorStore && this.uuids.equals(((ContributorStore)obj).uuids);
    }

    @Override
    public int hashCode() {
        return this.uuids.hashCode();
    }

    @Override
    public String toString() {
        return "ContributorStore{uuids=" + this.uuids + "}";
    }

    public static ListenableFuture<ContributorStore> read(URL url, Proxy proxy) {
        return HttpUtil.f_13936_.submit(() -> {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection(proxy);
            conn.setInstanceFollowRedirects(true);
            ImmutableSet.Builder uuids = ImmutableSet.builder();
            try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(ByteStreams.limit((InputStream)conn.getInputStream(), (long)4096L), ContributorStore.getContentEncoding(conn.getContentType())));){
                reader.beginArray();
                while (reader.hasNext()) {
                    uuids.add((Object)UUID.fromString(reader.nextString()));
                }
                reader.endArray();
            }
            return new ContributorStore((ImmutableSet<UUID>)uuids.build());
        });
    }

    private static Charset getContentEncoding(String contentType) {
        String charsetEquals = "charset=";
        int charsetIndex = StringUtils.indexOfIgnoreCase((CharSequence)contentType, (CharSequence)"charset=");
        if (charsetIndex != -1) {
            String encoding = contentType.substring(charsetIndex + "charset=".length());
            try {
                return Charset.forName(encoding);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Charsets.UTF_8;
    }

    public static ContributorStore of() {
        return new ContributorStore((ImmutableSet<UUID>)ImmutableSet.of());
    }
}

