/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

public class DeathHandler {
    public static final DeathHandler INSTANCE = new DeathHandler();
    public final Set<Pair<ResourceKey<Level>, BlockPos>> ALLOWED_REMOVALS = ConcurrentHashMap.newKeySet();
    private Predicate<Location> no_grave_locations = l -> false;
    private static final String IS_PLAYER_DEAD_NBT_BOOL = "tb_is_player_dead";
    private static final String PRESERVED_EFFECTS_NBT_LIST = "tb_preserved_effects";
    private static final String LAST_DEATH_LOCATION_NBT_TAG = "tb_last_death_location";
    private static final String GRAVE_LOCATIONS_NBT_LIST = "tb_grave_locations";
    private static final String SOULBOUND_STACKS_NBT_LIST = "tb_soulbound_stacks";
    private static final String KEY_STACKS_NBT_LIST = "tb_key_stacks";

    private DeathHandler() {
    }

    public Location getLastGrave(MinecraftServer server, ServerPlayer player) {
        List<Location> graveLocations = this.getGraveList(player);
        for (Location lastGrave : graveLocations) {
            ServerLevel currentWorld;
            if (lastGrave.isOrigin() || (currentWorld = server.m_129880_(lastGrave.dim)) == null) continue;
            if (currentWorld.m_7702_(lastGrave.getPos()) instanceof TileEntityPlayerGrave) {
                return lastGrave;
            }
            INSTANCE.removeGrave(player, lastGrave);
        }
        return Location.ORIGIN;
    }

    public void removeGrave(ServerPlayer player, Location pos) {
        boolean removeAbsentWorld;
        ListTag list = NBTStackHelper.getOrCreateList(EntityHelper.getPersistentTag((Player)player), GRAVE_LOCATIONS_NBT_LIST);
        boolean bl = removeAbsentWorld = list.size() > 100;
        assert (player.m_20194_() != null);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Location loc = NBTStackHelper.getLocation((CompoundTag)it.next(), "location");
            if (!pos.equals(loc) && (!removeAbsentWorld || player.m_20194_().m_129880_(loc.dim) != null)) continue;
            it.remove();
        }
    }

    public void logLastGrave(Player player, Location loc) {
        NBTStackHelper.getOrCreateList(EntityHelper.getPersistentTag(player), GRAVE_LOCATIONS_NBT_LIST).add((Object)NBTStackHelper.setLocation(new CompoundTag(), "location", loc));
        if (((Boolean)ConfigTombstone.player_death.logPlayerGrave.get()).booleanValue()) {
            ModTombstone.LOGGER.info("A new grave of the player " + player.m_36316_().getName() + " was created at position [x:" + loc.x + ", y:" + loc.y + ", z:" + loc.z + ", dim:" + loc.getDimString() + "]");
        }
    }

    public List<Location> getGraveList(ServerPlayer player) {
        LinkedList<Location> graveLocations = new LinkedList<Location>();
        ListTag nbtList = NBTStackHelper.getOrCreateList(EntityHelper.getPersistentTag((Player)player), GRAVE_LOCATIONS_NBT_LIST);
        for (int i = nbtList.size() - 1; i >= 0; --i) {
            graveLocations.add(NBTStackHelper.getLocation(nbtList.m_128728_(i), "location"));
        }
        return graveLocations;
    }

    public boolean isNoGraveLocation(Location location) {
        return this.no_grave_locations.test(location);
    }

    public void setLastDeathLocation(Player player, Location location) {
        NBTStackHelper.setLocation(EntityHelper.getPersistentTag(player), LAST_DEATH_LOCATION_NBT_TAG, location);
    }

    public Location getLastDeathLocation(Player player) {
        return NBTStackHelper.getLocation(EntityHelper.getPersistentTag(player), LAST_DEATH_LOCATION_NBT_TAG);
    }

    public void addPlayerDead(ServerPlayer player, DamageSource source) {
        int xpLoss;
        int toRemove;
        ServerPlayer killer;
        int timeSinceDeath = player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12991_));
        if (timeSinceDeath < TimeHelper.tickFromMinute(1)) {
            if (player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12935_)) > 1) {
                ModTriggers.CHAIN_DEATH.trigger(player);
            }
        } else if (timeSinceDeath >= TimeHelper.tickFromHour(1)) {
            ModTriggers.STRONG_OR_CAREFUL.trigger(player);
            if (timeSinceDeath >= TimeHelper.tickFromHour(10)) {
                ModTriggers.ALMOST_UNKILLABLE.trigger(player);
            }
        }
        CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
        persistentTag.m_128379_(IS_PLAYER_DEAD_NBT_BOOL, true);
        this.setLastDeathLocation((Player)player, new Location((Entity)player));
        boolean hasPreservation = EffectHelper.isPotionActive((LivingEntity)player, ModEffects.preservation);
        if (hasPreservation || ((Boolean)ConfigTombstone.player_death.restoreEffectsOnDeath.get()).booleanValue()) {
            NBTStackHelper.setEffectlist(persistentTag, PRESERVED_EFFECTS_NBT_LIST, player.m_21220_().stream().filter(EffectHelper::isAllowedEffect));
        }
        int xpTotal = EntityHelper.getPlayerTotalXp((Player)player);
        if (!hasPreservation && xpTotal > 0 && Optional.ofNullable(player.m_20194_()).map(MinecraftServer::m_129799_).orElse(false).booleanValue() && EntityHelper.isKilledByOtherPlayer((Player)player, source) && (killer = (ServerPlayer)source.m_7639_()) != null && (toRemove = Mth.m_14107_((double)((double)(xpTotal * (Integer)ConfigTombstone.player_death.pvpStolenXp.get()) / 100.0))) > 0) {
            xpTotal -= toRemove;
            killer.m_6756_(toRemove);
            LangKey.MESSAGE_PVP_STEAL_EXPERIENCE.sendMessage((Player)player, toRemove, player.m_7755_());
        }
        if ((xpLoss = ((Integer)SharedConfigTombstone.player_death.xpLoss.get()).intValue()) == -1) {
            xpTotal = 0;
        } else if (!hasPreservation && xpLoss > 0) {
            xpTotal = Mth.m_14107_((double)((double)(xpTotal * Mth.m_14045_((int)(100 + EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.memento_mori) * 20 - (Integer)SharedConfigTombstone.player_death.xpLoss.get()), (int)0, (int)100)) / 100.0));
        }
        persistentTag.m_128405_("tb_experience_total", xpTotal);
        Pair<Integer, Float> pair = EntityHelper.getPlayerXpPair(xpTotal);
        persistentTag.m_128405_("tb_experience_level", ((Integer)pair.getLeft()).intValue());
        persistentTag.m_128350_("tb_experience_bar", ((Float)pair.getRight()).floatValue());
        persistentTag.m_128379_("tb_has_preservation", hasPreservation);
    }

    public void restorePlayerDead(ServerPlayer player) {
        boolean hasPreservation;
        if (!this.isPlayerDead((Player)player)) {
            return;
        }
        if (!Helper.isDisabledPerk(ModPerks.ghostly_shape, (Player)player)) {
            EffectHelper.addEffect((LivingEntity)player, ModEffects.ghostly_shape, (Integer)SharedConfigTombstone.general.ghostlyShapeDuration.get() * 20, EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.ghostly_shape), new boolean[0]);
        }
        CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
        persistentTag.m_128473_(IS_PLAYER_DEAD_NBT_BOOL);
        List<MobEffectInstance> effectInstances = NBTStackHelper.getEffectList(persistentTag, PRESERVED_EFFECTS_NBT_LIST, EffectHelper::isAllowedEffect);
        if (!effectInstances.isEmpty()) {
            effectInstances.forEach(effectInstance -> EffectHelper.addEffect((LivingEntity)player, effectInstance));
            persistentTag.m_128473_(PRESERVED_EFFECTS_NBT_LIST);
        }
        if ((hasPreservation = persistentTag.m_128471_("tb_has_preservation")) || (Integer)SharedConfigTombstone.player_death.xpLoss.get() > -1) {
            player.f_36079_ = persistentTag.m_128451_("tb_experience_total");
            player.f_36078_ = persistentTag.m_128451_("tb_experience_level");
            player.f_36080_ = persistentTag.m_128457_("tb_experience_bar");
            persistentTag.m_128473_("tb_has_preservation");
            player.f_8906_.m_141995_((Packet)new ClientboundSetExperiencePacket(player.f_36080_, player.f_36079_, player.f_36078_));
        }
    }

    public boolean isPlayerDead(Player player) {
        return EntityHelper.getPersistentTag(player).m_128471_(IS_PLAYER_DEAD_NBT_BOOL);
    }

    public void updateNoGraveLocations() {
        ArrayList<Predicate<Location>> list = new ArrayList<Predicate<Location>>();
        for (String s : (List)ConfigTombstone.player_death.noGraveLocation.get()) {
            int range;
            int z;
            int y;
            int x;
            if (s.isEmpty()) continue;
            String[] res = s.split(",");
            if (res.length == 1) {
                list.add(l -> l.isSameDimension(res[0].trim()));
                continue;
            }
            if (res.length != 5) continue;
            try {
                x = Integer.parseInt(res[0].trim());
                y = Integer.parseInt(res[1].trim());
                z = Integer.parseInt(res[2].trim());
                range = Integer.parseInt(res[4].trim());
            }
            catch (NumberFormatException e) {
                ModTombstone.LOGGER.warn("invalid number in noGraveLocations with provided string: " + s);
                continue;
            }
            list.add(l -> l.isSameDimension(res[3].trim()) && l.isInRange(x, y, z, range));
        }
        this.no_grave_locations = list.stream().reduce(Predicate::or).orElse(l -> false);
    }

    public void restoreSoulbounds(ServerPlayer player) {
        CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
        ListTag stackList = persistentTag.m_128437_(SOULBOUND_STACKS_NBT_LIST, 10);
        for (int i = 0; i < stackList.size(); ++i) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)stackList.m_128728_(i));
            if (stack.m_41619_()) continue;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
        }
        persistentTag.m_128473_(SOULBOUND_STACKS_NBT_LIST);
        ListTag keyList = persistentTag.m_128437_(KEY_STACKS_NBT_LIST, 10);
        for (int i = 0; i < keyList.size(); ++i) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)keyList.m_128728_(i));
            if (stack.m_41619_()) continue;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
        }
        persistentTag.m_128473_(KEY_STACKS_NBT_LIST);
    }

    public void storeSoulboundsOnBody(ServerPlayer player, List<ItemStack> keys, List<ItemStack> soulbounds) {
        ListTag keyStack = NBTStackHelper.getOrCreateList(EntityHelper.getPersistentTag((Player)player), KEY_STACKS_NBT_LIST);
        keys.forEach(key -> keyStack.add((Object)key.serializeNBT()));
        keys.clear();
        ListTag stackList = NBTStackHelper.getOrCreateList(EntityHelper.getPersistentTag((Player)player), SOULBOUND_STACKS_NBT_LIST);
        soulbounds.forEach(soulbound -> stackList.add((Object)soulbound.serializeNBT()));
        soulbounds.clear();
    }

    public boolean canRemovePlayerGrave(Level world, BlockPos pos) {
        return this.ALLOWED_REMOVALS.contains(Pair.of((Object)world.m_46472_(), (Object)pos));
    }

    public void removeAndEmptyPlayerGrave(Level level, BlockPos pos) {
        pos = pos.m_7949_();
        Pair locationId = Pair.of((Object)level.m_46472_(), (Object)pos);
        this.ALLOWED_REMOVALS.add((Pair<ResourceKey<Level>, BlockPos>)locationId);
        level.m_46597_(pos, Blocks.f_50016_.m_49966_());
        this.ALLOWED_REMOVALS.remove(locationId);
    }
}

