/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.math.Matrix4f;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.command.CommandTBBind;
import ovh.corail.tombstone.command.CommandTBKnowledge;
import ovh.corail.tombstone.command.CommandTBRecovery;
import ovh.corail.tombstone.command.CommandTBRequestTeleport;
import ovh.corail.tombstone.command.CommandTBRestoreInventory;
import ovh.corail.tombstone.command.CommandTBReviveFamiliar;
import ovh.corail.tombstone.command.CommandTBShowLastGrave;
import ovh.corail.tombstone.command.CommandTBSiege;
import ovh.corail.tombstone.command.CommandTBTeleport;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.ContributorStore;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.SupportStructures;
import ovh.corail.tombstone.helper.TeleportationHandler;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.helper.WorldFunctionInjector;
import ovh.corail.tombstone.item.ItemEnchantedBundle;
import ovh.corail.tombstone.item.ItemLostTablet;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;

public class Helper {
    public static final Random random = new Random();
    public static boolean IS_CONTRIBUTOR = false;
    private static ContributorStore CONTRIBUTORS = ContributorStore.of();
    private static final List<String> THANK_NAMES = ImmutableList.of((Object)"Gegy1000", (Object)"Barteks2x", (Object)"Runemoro", (Object)"Goshen", (Object)"Paul Fulham", (Object)"Darkhax", (Object)"Subaraki", (Object)"Raycoms");
    private static final Map<String, Component> BIOME_NAMES = new HashMap<String, Component>();
    public static final String APRIL_FOOLS_DAY_SLOWNESS_NBT_BOOL = "april_fools_day_slowness";

    public static boolean isContributor(Player player) {
        return player.f_19853_.m_5776_() ? IS_CONTRIBUTOR : CONTRIBUTORS.contains(player);
    }

    public static boolean isDisabledPerk(@Nullable Perk perk, @Nullable Player player) {
        return perk == null || perk.isDisabled(player);
    }

    public static String getRandomThankName() {
        return Helper.getRandomInList(THANK_NAMES).orElse("Unknown");
    }

    public static int getRandom(int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static float getRandom(float min, float max) {
        return random.nextFloat() * (max - min) + min;
    }

    public static double getRandom(double min, double max) {
        return random.nextDouble() * (max - min) + min;
    }

    public static boolean getRandom() {
        return random.nextBoolean();
    }

    public static String dump(Object o) {
        return ToStringBuilder.reflectionToString((Object)o, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static boolean existClass(String className) {
        return Helper.getClass(className) != null;
    }

    @Nullable
    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nullable
    public static <T> Field getField(@Nullable Class<? super T> aClass, String fieldName) {
        if (aClass != null) {
            try {
                return ObfuscationReflectionHelper.findField(aClass, (String)fieldName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static Method getMethod(@Nullable Class<?> aClass, String methodName, Class<?> ... parameterTypes) {
        if (aClass != null) {
            try {
                return ObfuscationReflectionHelper.findMethod(aClass, (String)methodName, (Class[])parameterTypes);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isModLoad(String modid) {
        return ModList.get() != null && ModList.get().getModContainerById(modid).isPresent();
    }

    public static ResourceKey<Level> getDimensionType(Level level) {
        return level.m_46472_();
    }

    public static BlockPos getCloserValidPos(Level level, BlockPos pos) {
        boolean validY;
        WorldBorder border = level.m_6857_();
        boolean validXZ = border.m_61937_(pos);
        boolean bl = validY = !level.m_151570_(pos);
        if (validXZ && validY) {
            return pos;
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (!validXZ) {
            x = Math.min(Math.max(pos.m_123341_(), (int)border.m_61955_()), (int)border.m_61957_());
            z = Math.min(Math.max(pos.m_123343_(), (int)border.m_61956_()), (int)border.m_61958_());
        }
        if (!validY) {
            y = Mth.m_14045_((int)pos.m_123342_(), (int)level.m_141937_(), (int)level.m_151558_());
        }
        return new BlockPos(x, y, z);
    }

    public static boolean isValidPos(@Nullable Level level, BlockPos pos) {
        return level != null && level.m_6857_().m_61937_(pos) && !Helper.isOutsideBuildHeight(level, pos);
    }

    public static boolean isOutsideWorldBorders(Level level, BlockPos pos) {
        return !level.m_6857_().m_61937_(pos);
    }

    public static boolean isOutsideBuildHeight(Level level, BlockPos pos) {
        return level.m_151570_(pos);
    }

    public static boolean isInvalidDimension(MinecraftServer server, ResourceKey<Level> key) {
        return server.m_129880_(key) == null;
    }

    public static <T> Optional<T> getRandomInList(List<T> list) {
        return list.isEmpty() ? Optional.empty() : Optional.of(list.get(random.nextInt(list.size())));
    }

    public static Pair<String, String> parseRLString(String rlString) {
        String[] splits = rlString.split(":");
        boolean noDomain = splits.length == 1;
        return noDomain ? Pair.of((Object)"minecraft", (Object)rlString) : Pair.of((Object)splits[0], (Object)splits[1]);
    }

    public static Location findNearestStructure(ServerLevel level, BlockPos pos, ResourceLocation structureRL, boolean unexplored) {
        return Helper.findNearestStructure(level, pos, structureRL.toString(), SupportStructures.getY(structureRL), unexplored);
    }

    public static Location findNearestStructure(ServerLevel level, BlockPos pos, String structureRLString, boolean unexplored) {
        return Helper.findNearestStructure(level, pos, structureRLString, SupportStructures.getY(structureRLString), unexplored);
    }

    public static Location findNearestStructure(ServerLevel level, BlockPos pos, String structureName, int y, boolean unexplored) {
        StructureFeature<?> structure = SupportStructures.getStructure(structureName);
        if (structure != null) {
            BlockPos startingPos = pos;
            for (int nbTry = 1; nbTry <= 5; ++nbTry) {
                BlockPos foundPos = level.m_8717_(structure, startingPos = Helper.getCloserValidPos((Level)level, startingPos.m_142022_((double)nbTry * random.nextGaussian() * 2000.0, 0.0, (double)nbTry * random.nextGaussian() * 2000.0)), 100, unexplored);
                if (foundPos == null || !Helper.isValidPos((Level)level, foundPos)) continue;
                return new Location(foundPos.m_123341_(), y, foundPos.m_123343_(), (Level)level);
            }
        }
        return Location.ORIGIN;
    }

    public static Location findNearestBiome(ServerLevel level, BlockPos pos, Biome biome, boolean unexplored) {
        BlockPos startingPos = new BlockPos(pos.m_123341_(), 68, pos.m_123343_());
        for (int nbTry = 0; nbTry < 3; ++nbTry) {
            startingPos = Helper.getCloserValidPos((Level)level, startingPos.m_142022_((double)nbTry * random.nextGaussian() * 5000.0, 0.0, (double)nbTry * random.nextGaussian() * 5000.0));
            BlockPos foundPos = level.m_7726_().m_8481_().m_62218_().m_7754_(startingPos.m_123341_(), startingPos.m_123342_(), startingPos.m_123343_(), 6400, 8, aBiome -> aBiome == biome, random, true);
            if (foundPos == null || !Helper.isValidPos((Level)level, foundPos)) continue;
            return new Location(foundPos, (Level)level);
        }
        return Location.ORIGIN;
    }

    public static Component getBiomeName(String biomeId) {
        return BIOME_NAMES.computeIfAbsent(biomeId, k -> {
            String[] splits = biomeId.toLowerCase(Locale.US).split(":");
            TextComponent biomeName = new TextComponent(Helper.capitalizeWord(splits[splits.length - 1]));
            return splits.length < 2 || "minecraft".equals(splits[0]) ? biomeName : biomeName.m_130946_(" [").m_130946_(splits[0]).m_130946_("]");
        });
    }

    public static <T extends Entity> T teleportEntity(T entity, Location loc, ServerLevel level) {
        return TeleportationHandler.teleportEntity(entity, level, (double)loc.x + 0.5, (double)loc.y + 0.1, (double)loc.z + 0.5);
    }

    public static <T extends Entity> T teleportToGrave(T entity, Location loc, ServerLevel level) {
        return Helper.teleportEntity(entity, loc.move(Direction.UP, 1), level);
    }

    public static boolean isRuleKeepInventory(Player player) {
        return Helper.isRuleKeepInventory(player.f_19853_);
    }

    public static boolean isRuleKeepInventory(Level level) {
        return level.m_46469_().m_46207_(GameRules.f_46133_);
    }

    public static boolean hasNoCollision(BlockGetter level, BlockPos pos, BlockState state) {
        return state.m_60812_(level, pos) == Shapes.m_83040_();
    }

    public static boolean canShowTooltip(@Nullable Level level, ItemStack stack) {
        return level != null && ((Boolean)ConfigTombstone.client.showEnhancedTooltips.get() != false || Screen.m_96638_());
    }

    public static boolean isAprilFoolsDaySnowball(LivingEntity entity, @Nullable DamageSource source) {
        Entity immediateSource;
        return TimeHelper.isAprilFoolsDay() && EntityHelper.isValidServerPlayer((Entity)entity) && source != null && (immediateSource = source.m_7640_()) != null && immediateSource.m_6095_() == EntityType.f_20477_ && immediateSource.getPersistentData().m_128441_(APRIL_FOOLS_DAY_SLOWNESS_NBT_BOOL);
    }

    public static void handleAprilFoolsDayGrave(Level level, BlockPos pos) {
        Vec3 centerVec = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82520_(0.5, 1.0, 0.5);
        Player closestPlayer = level.m_45924_(centerVec.f_82479_, centerVec.f_82480_, centerVec.f_82481_, 20.0, false);
        if (closestPlayer != null) {
            Snowball snowballentity = new Snowball(level, centerVec.f_82479_, centerVec.f_82480_, centerVec.f_82481_);
            if (Helper.canSeeEntity((Entity)closestPlayer, centerVec)) {
                snowballentity.m_37446_(new ItemStack((ItemLike)Items.f_42500_));
                snowballentity.getPersistentData().m_128379_(APRIL_FOOLS_DAY_SLOWNESS_NBT_BOOL, true);
                Vec3 vec = closestPlayer.m_20182_().m_82520_(0.0, (double)closestPlayer.m_20192_(), 0.0).m_82546_(snowballentity.m_20182_());
                snowballentity.m_6686_(vec.f_82479_, vec.f_82480_, vec.f_82481_, 1.5f, 1.0f);
                level.m_7967_((Entity)snowballentity);
            }
        }
    }

    public static boolean canSeeEntity(Entity entity, Vec3 vec3d) {
        Vec3 vec3d1 = entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_(), 0.0);
        return entity.f_19853_.m_45547_(new ClipContext(vec3d, vec3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).m_6662_() == HitResult.Type.MISS;
    }

    @Nullable
    public static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static boolean isNight(Level level) {
        float angle = level.m_46942_(0.0f);
        return angle >= 0.245f && angle <= 0.755f;
    }

    public static boolean isDay(Level level) {
        return !Helper.isNight(level);
    }

    public static boolean containRL(List<String> listRL, @Nullable ResourceLocation rl) {
        return rl != null && Helper.containRL(listRL, rl.m_135827_(), rl.m_135815_());
    }

    public static boolean containRL(List<String> listRL, String registryName) {
        String[] splits = registryName.split(":");
        if (splits.length == 1) {
            return Helper.containRL(listRL, "minecraft", splits[0]);
        }
        return Helper.containRL(listRL, splits[0], splits[1]);
    }

    public static boolean containRL(List<String> listRL, String domain, String path) {
        return listRL.stream().anyMatch(p -> p.contains(":") ? p.equals(domain + ":" + path) : p.equals(domain));
    }

    public static float[] getRGBColor3F(int color) {
        float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return rgb;
    }

    public static float[] getRGBColor4F(int color) {
        float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f};
        return rgb;
    }

    public static float[] getHSBtoRGBF(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        float[] rgb = new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
        return rgb;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void fillGradient(Matrix4f matrix, int left, int top, int right, int bottom, int color1, int color2, int zLevel, boolean isHorizontal) {
        float[] argb1 = Helper.getRGBColor4F(color1);
        float[] argb2 = Helper.getRGBColor4F(color2);
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Helper.makeVertex(matrix, bufferbuilder, right, top, zLevel, isHorizontal ? argb2 : argb1);
        Helper.makeVertex(matrix, bufferbuilder, left, top, zLevel, argb1);
        Helper.makeVertex(matrix, bufferbuilder, left, bottom, zLevel, isHorizontal ? argb1 : argb2);
        Helper.makeVertex(matrix, bufferbuilder, right, bottom, zLevel, argb2);
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void makeVertex(Matrix4f matrix, BufferBuilder bufferbuilder, int x, int y, int zLevel, float[] colorArray) {
        bufferbuilder.m_85982_(matrix, (float)x, (float)y, (float)zLevel).m_85950_(colorArray[0], colorArray[1], colorArray[2], colorArray[3]).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderStackInGui(ItemStack stack, int xPosition, int yPosition, float scale, boolean isSpinning) {
        boolean flag;
        Minecraft mc = Minecraft.m_91087_();
        BakedModel bakedModel = mc.m_91291_().m_174264_(stack, null, null, 0);
        mc.f_90987_.m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack poseStack = RenderSystem.m_157191_();
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_85837_((double)((float)xPosition / scale), (double)((float)yPosition / scale), (double)(100.0f + mc.m_91291_().f_115093_));
        poseStack.m_85837_(8.0, 8.0, 0.0);
        poseStack.m_85841_(16.0f, -16.0f, 16.0f);
        RenderSystem.m_157182_();
        PoseStack poseStack1 = new PoseStack();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flag = !bakedModel.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        if (isSpinning) {
            // empty if block
        }
        mc.m_91291_().m_115143_(stack, ItemTransforms.TransformType.GUI, false, poseStack1, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
        bufferSource.m_109911_();
        RenderSystem.m_69482_();
        if (flag) {
            Lighting.m_84931_();
        }
        poseStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public static void damageItem(ItemStack stack, int amount, ServerPlayer player, InteractionHand hand) {
        stack.m_41622_(amount, (LivingEntity)player, p -> p.m_21190_(hand));
    }

    public static double getDistance(Vec3i vec1, Vec3i vec2) {
        return Math.sqrt(Helper.getDistanceSq(vec1, vec2));
    }

    public static double getDistanceSq(Vec3i vec1, Vec3i vec2) {
        return Helper.getDistanceSq(vec1, vec2.m_123341_(), vec2.m_123342_(), vec2.m_123343_());
    }

    public static double getDistanceSq(Vec3i vec1, int x2, int y2, int z2) {
        return vec1.m_123299_((double)x2, (double)y2, (double)z2, false);
    }

    public static boolean isPacketToClient(NetworkEvent.Context ctx) {
        return ctx.getDirection().getOriginationSide() == LogicalSide.SERVER && ctx.getDirection().getReceptionSide() == LogicalSide.CLIENT;
    }

    public static boolean isPacketToServer(NetworkEvent.Context ctx) {
        return ctx.getDirection().getOriginationSide() == LogicalSide.CLIENT && ctx.getDirection().getReceptionSide() == LogicalSide.SERVER;
    }

    public static <T> T unsafeNullCast() {
        return null;
    }

    public static String capitalizeWord(String text) {
        StringBuilder builder = new StringBuilder();
        String[] splits = text.toLowerCase(Locale.US).split("\\s|_");
        builder.append(StringUtils.capitalize((String)splits[0]));
        if (splits.length > 1) {
            Arrays.stream(splits, 1, splits.length).forEach(word -> builder.append(" ").append(StringUtils.capitalize((String)word)));
        }
        return builder.toString();
    }

    public static WorldFunctionInjector buildKnowledgeFunction() {
        return WorldFunctionInjector.builder().put(new ResourceLocation("tombstone", "knowledge"), (sender, params) -> {
            Entity entity = sender.m_81373_();
            Entity serverPlayer$temp = entity;
            if (serverPlayer$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)serverPlayer$temp;
                serverPlayer.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(serverPlayer, params.getInt("amount", 1), 0));
            }
        }).build();
    }

    public static void loadContributors(MinecraftServer server) {
        if (CONTRIBUTORS.isEmpty()) {
            URL CONTRIBUTORS_URL;
            try {
                CONTRIBUTORS_URL = new URL("https://raw.githubusercontent.com/Corail31/trash/master/special_bonus.json");
            }
            catch (Throwable ignored) {
                return;
            }
            Futures.addCallback(ContributorStore.read(CONTRIBUTORS_URL, server.f_129747_), (FutureCallback)new FutureCallback<ContributorStore>(){

                public void onSuccess(@Nullable ContributorStore result) {
                    CONTRIBUTORS = result;
                    ModTombstone.LOGGER.info("The list of contributors has been loaded successfully");
                }

                public void onFailure(Throwable t) {
                    ModTombstone.LOGGER.info("The list of contributors couldn't be loaded");
                }
            }, (Executor)server);
        } else {
            ModTombstone.LOGGER.info("The list of contributors was already loaded");
        }
    }

    public static void initCommands(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        new CommandTBRestoreInventory(commandDispatcher).registerCommand();
        new CommandTBShowLastGrave(commandDispatcher).registerCommand();
        new CommandTBKnowledge(commandDispatcher).registerCommand();
        new CommandTBAcceptTeleport(commandDispatcher).registerCommand();
        new CommandTBSiege(commandDispatcher).registerCommand();
        new CommandTBRecovery(commandDispatcher).registerCommand();
        new CommandTBReviveFamiliar(commandDispatcher).registerCommand();
        new CommandTBRequestTeleport(commandDispatcher).registerCommand();
        new CommandTBBind(commandDispatcher).registerCommand();
        new CommandTBTeleport(commandDispatcher).registerCommand();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initModels() {
        ModBlocks.DECORATIVE_GRAVES.values().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110463_()));
        ModBlocks.PLAYER_GRAVES.values().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110463_()));
        for (Block decorativeGrave : ModBlocks.DECORATIVE_GRAVES.values()) {
            ItemProperties.register((Item)decorativeGrave.m_5456_(), (ResourceLocation)new ResourceLocation("model_texture"), (stack, world, entity, aInt) -> (EngravableHelper.isEngraved(stack) ? 0.1f : 0.0f) + (ItemBlockGrave.getModelTexture(stack) == 1 ? 0.01f : 0.0f));
        }
        ItemProperties.register((Item)ModItems.bone_needle, (ResourceLocation)new ResourceLocation("filled"), (stack, world, entity, aInt) -> ModItems.bone_needle.getEntityType(stack).isEmpty() ? 0.0f : 1.0f);
        ItemProperties.register((Item)ModItems.lost_tablet, (ResourceLocation)new ResourceLocation("type"), (stack, world, player, aInt) -> switch (ModItems.lost_tablet.getType(stack)) {
            case ItemLostTablet.Type.UNKNOWN -> 0.0f;
            case ItemLostTablet.Type.EXPLORATION -> 0.1f;
            case ItemLostTablet.Type.VILLAGE -> 0.5f;
            case ItemLostTablet.Type.TREASURE -> 1.0f;
            default -> throw new IncompatibleClassChangeError();
        });
        ItemProperties.register((Item)ModItems.tablet_of_home, (ResourceLocation)new ResourceLocation("ancient"), (stack, worldIn, entityIn, aInt) -> ModItems.tablet_of_home.isAncient(stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)ModItems.tablet_of_recall, (ResourceLocation)new ResourceLocation("ancient"), (stack, worldIn, entityIn, aInt) -> ModItems.tablet_of_recall.isAncient(stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)ModItems.tablet_of_assistance, (ResourceLocation)new ResourceLocation("ancient"), (stack, worldIn, entityIn, aInt) -> ModItems.tablet_of_assistance.isAncient(stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)ModItems.tablet_of_cupidity, (ResourceLocation)new ResourceLocation("ancient"), (stack, worldIn, entityIn, aInt) -> ModItems.tablet_of_cupidity.isAncient(stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)ModItems.fishing_rod_of_misadventure, (ResourceLocation)new ResourceLocation("cast"), (stack, world, entity, aInt) -> {
            Player player;
            LivingEntity player$temp = entity;
            return (ModItems.fishing_rod_of_misadventure.isAncient(stack) ? 0.01f : 0.0f) + (player$temp instanceof Player && ((player = (Player)player$temp).m_21205_() == stack || player.m_21206_() == stack) && player.f_36083_ != null ? 0.1f : 0.0f);
        });
        ItemProperties.register((Item)ModItems.grave_plate, (ResourceLocation)new ResourceLocation("engraved"), (stack, worldIn, entityIn, aInt) -> EngravableHelper.isEngraved(stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)ModItems.enchanted_bundle, (ResourceLocation)new ResourceLocation("filled"), (stack, worldIn, entityIn, aInt) -> ItemEnchantedBundle.m_150766_((ItemStack)stack));
    }

    public static void checkDeathHandlingMod(@Nullable ServerPlayer player) {
        if (((Boolean)ConfigTombstone.player_death.handlePlayerDeath.get()).booleanValue()) {
            Stream.of("gravestone", "corpse", "simpletomb", "simple_tomb", "rpgz", "vanilladeathchest", "gravekeeper", "enigmaticgraves").filter(Helper::isModLoad).findFirst().ifPresent(modName -> {
                String message = "You loaded a conflicting mod handling the player's death (" + modName + ") that it would be better to remove. The other possibility is to disable the handling of death in Corail Tombstone's config.";
                if (player == null) {
                    ModTombstone.LOGGER.fatal(message);
                } else {
                    LangKey.sendMessage((Component)new TextComponent(message).m_130940_(ChatFormatting.RED), (Player)player);
                }
            });
        }
    }

    public static void replaceIngredient(ItemStack toReplace, CraftingRecipe recipe, Ingredient newIngredient) {
        NonNullList ingredients = recipe.m_7527_();
        IntStream.range(0, ingredients.size()).filter(i -> ((Ingredient)ingredients.get(i)).test(toReplace)).forEach(i -> ingredients.set(i, (Object)newIngredient));
    }

    @Nullable
    public static Player getPlayer(CraftingContainer inventory) {
        return inventory.f_39323_.f_38839_.stream().map(slot -> slot.f_40218_).filter(Inventory.class::isInstance).map(Inventory.class::cast).map(inv -> inv.f_35978_).findFirst().orElse(null);
    }

    public static void spawnRandomMob(ServerLevel level, BlockPos pos) {
        Location spawnPos = new SpawnHelper(level, new BlockPos(pos.m_123341_() + Helper.getRandom(-9, 9), pos.m_123342_(), pos.m_123343_() + Helper.getRandom(-9, 9))).findSafePlace(2, true);
        if (spawnPos.isOrigin()) {
            return;
        }
        Zombie mob = (Zombie)EntityType.f_20501_.m_20615_((Level)level);
        if (mob != null) {
            mob.m_6863_(true);
            if (TimeHelper.isDateAroundHalloween()) {
                mob.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Blocks.f_50133_));
            }
            mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(mob.m_142538_()), MobSpawnType.TRIGGERED, null, null);
            mob.m_7678_((double)spawnPos.x, (double)spawnPos.y, (double)spawnPos.z, level.f_46441_.nextFloat() * 360.0f, 0.0f);
            level.m_47205_((Entity)mob);
        }
    }

    public static AABB createBounds(BlockPos pos, double range) {
        return new AABB((double)pos.m_123341_() - range, (double)pos.m_123342_() - range, (double)pos.m_123343_() - range, (double)pos.m_123341_() + range, (double)pos.m_123342_() + range, (double)pos.m_123343_() + range);
    }

    public static <T extends CraftingRecipe> T setNBTIngredients(T recipe, Item item, Function<ItemStack, ItemStack> func, boolean addEmpty) {
        ItemStack stack = new ItemStack((ItemLike)item);
        NonNullList ingredients = recipe.m_7527_();
        for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ing = (Ingredient)ingredients.get(i);
            if (!ing.test(stack)) continue;
            if (addEmpty) {
                recipe.m_7527_().set(i, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack, func.apply(stack)}));
                continue;
            }
            recipe.m_7527_().set(i, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{func.apply(stack)}));
        }
        return recipe;
    }
}

