/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.base.MoreObjects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class Location
implements Comparable<Location> {
    public int x;
    public int y;
    public int z;
    public final ResourceKey<Level> dim;
    static final BlockPos ORIGIN_POS = new BlockPos(0, Integer.MIN_VALUE, 0);
    public static final Location ORIGIN = new Location(ORIGIN_POS, (ResourceKey<Level>)Level.f_46428_);

    public Location(BlockPos pos, ResourceKey<Level> dim) {
        this(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), dim);
    }

    public Location(BlockPos pos, Level level) {
        this(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), level);
    }

    public Location(int x, int y, int z, Level level) {
        this(x, y, z, (ResourceKey<Level>)level.m_46472_());
    }

    public Location(int x, int y, int z, ResourceKey<Level> dim) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = dim;
    }

    public Location(GlobalPos globalPos) {
        this(globalPos.m_122646_(), (ResourceKey<Level>)globalPos.m_122640_());
    }

    public Location(Entity entity) {
        this(entity.m_142538_(), entity.f_19853_);
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public boolean equals(Location location) {
        return location.x == this.x && location.y == this.y && location.z == this.z && location.dim.equals(this.dim);
    }

    public Location move(Direction direction, int length) {
        Vec3i vec = direction.m_122436_();
        this.x += vec.m_123341_() * length;
        this.y += vec.m_123342_() * length;
        this.z += vec.m_123343_() * length;
        return this;
    }

    public boolean isOrigin() {
        return this.equals(ORIGIN);
    }

    public boolean isSameDimension(Level world) {
        return this.dim.equals((Object)world.m_46472_());
    }

    public boolean isSameDimension(String worldRL) {
        return this.getDimString().equals(worldRL);
    }

    public double getDistanceSq(Location location) {
        return this.getDistanceSq(location.getPos());
    }

    public double getDistanceSq(BlockPos pos) {
        double d0 = this.x - pos.m_123341_();
        double d1 = this.y - pos.m_123342_();
        double d2 = this.z - pos.m_123343_();
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public boolean isInRangeAndDimension(Location loc, int range) {
        return this.isInRange(loc, range) && this.dim.equals(loc.dim);
    }

    public boolean isInRange(int x, int y, int z, int range) {
        return this.isInRange(new Location(x, y, z, this.dim), range);
    }

    public boolean isInRange(BlockPos position, int range) {
        return this.getDistanceSq(position) <= (double)(range * range);
    }

    public boolean isInRange(Location location, int range) {
        return this.getDistanceSq(location) <= (double)(range * range);
    }

    public String getDimString() {
        return this.dim.m_135782_().toString();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.x).add("y", this.y).add("z", this.z).add("dim", (Object)this.getDimString()).toString();
    }

    @Override
    public int compareTo(Location location) {
        int compDim = this.dim.compareTo(location.dim);
        return compDim != 0 ? compDim : new Vec3i(this.x, this.y, this.z).compareTo(new Vec3i(location.x, location.y, location.z));
    }
}

