/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.helper.Helper;

public enum SupportStructures {
    VILLAGE("village"),
    DESERT_TEMPLE("desert_pyramid"),
    IGLOO_TEMPLE("igloo"),
    JUNGLE_TEMPLE("jungle_pyramid"),
    MANSION("mansion"),
    MONUMENT("monument"),
    STRONGHOLD("stronghold", 35),
    END_CITY("endcity"),
    MINESHAFT("mineshaft", 37),
    FORTRESS("fortress", 35),
    SWAMP_HUT("swamp_hut"),
    OCEAN_RUIN("ocean_ruin"),
    BURIED_TREASURE("buried_treasure"),
    SHIPWRECK("shipwreck"),
    PILLAGER_OUTPOST("pillager_outpost"),
    RUINED_PORTAL("ruined_portal"),
    NETHER_FOSSIL("nether_fossil"),
    BASTION_REMNANT("bastion_remnant", 35);

    public static final int DEFAULT_Y = 68;
    private final String structureName;
    private final int y;
    private static final Map<String, Component> STRUCTURE_NAMES;

    private SupportStructures(String structureName) {
        this(structureName, 68);
    }

    private SupportStructures(String structureName, int y) {
        this.structureName = structureName;
        this.y = y;
    }

    public String getId() {
        return "minecraft:" + this.structureName;
    }

    public boolean is(String structureId) {
        Pair<String, String> rl = Helper.parseRLString(structureId);
        return "minecraft".equals(rl.getLeft()) && this.structureName.equals(rl.getRight());
    }

    public boolean is(ResourceLocation structureId) {
        return this.is(structureId.m_135827_(), structureId.m_135815_());
    }

    public boolean is(String domain, String path) {
        return "minecraft".equals(domain) && this.structureName.equals(path);
    }

    public int getY() {
        return this.y;
    }

    @Nullable
    private static SupportStructures getVanillaStructure(String domain, String path) {
        return domain.equals("minecraft") ? (SupportStructures)Stream.of(SupportStructures.values()).filter(p -> p.structureName.equals(path)).findFirst().orElse(null) : null;
    }

    public static int getY(ResourceLocation structureRL) {
        return SupportStructures.getY(structureRL.m_135827_(), structureRL.m_135815_());
    }

    public static int getY(String structureRLString) {
        Pair<String, String> rl = Helper.parseRLString(structureRLString);
        return SupportStructures.getY((String)rl.getLeft(), (String)rl.getRight());
    }

    public static int getY(String domain, String path) {
        SupportStructures struct = SupportStructures.getVanillaStructure(domain, path);
        return struct != null ? struct.getY() : (domain.equals("quark") ? 37 : 68);
    }

    @Nullable
    public static String getRandomVanillaStructure(Predicate<ResourceLocation> predic) {
        return SupportStructures.getRandomStructure(p -> p.m_135827_().equals("minecraft") && predic.test((ResourceLocation)p));
    }

    @Nullable
    public static String getRandomStructure(Predicate<ResourceLocation> predic) {
        return Helper.getRandomInList(ForgeRegistries.STRUCTURE_FEATURES.getKeys().stream().filter(predic).collect(Collectors.toList())).map(Object::toString).orElse(null);
    }

    public static boolean hasStructureInWorld(@Nullable ServerLevel level, StructureFeature<?> structure) {
        return level != null && level.m_7726_().m_8481_().m_62218_().m_47917_(structure);
    }

    @Nullable
    public static StructureFeature<?> getStructure(String name) {
        ResourceLocation rl = new ResourceLocation(name.toLowerCase(Locale.US));
        for (StructureFeature structure : ForgeRegistries.STRUCTURE_FEATURES) {
            if (!rl.equals((Object)structure.getRegistryName())) continue;
            return structure;
        }
        return null;
    }

    public static List<ResourceKey<Level>> getDimensionTypesForStructure(MinecraftServer server, StructureFeature<?> structure) {
        return StreamSupport.stream(server.m_129785_().spliterator(), false).filter(world -> SupportStructures.hasStructureInWorld(world, structure)).map(Level::m_46472_).collect(Collectors.toList());
    }

    public static Component getStructureName(String structureId) {
        return STRUCTURE_NAMES.computeIfAbsent(structureId, k -> {
            String[] splits = structureId.toLowerCase(Locale.US).split(":");
            TextComponent structureName = new TextComponent(Helper.capitalizeWord(splits[splits.length - 1]));
            return splits.length < 2 || "minecraft".equals(splits[0]) ? structureName : structureName.m_130946_(" [").m_130946_(splits[0]).m_130946_("]");
        });
    }

    static {
        STRUCTURE_NAMES = new HashMap<String, Component>();
    }
}

