/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.storage.LevelData;
import net.minecraftforge.fmllegacy.hooks.BasicEventHooks;

public class TeleportationHandler {
    public static <T extends Entity> T teleportEntity(T entity, ServerLevel targetWorld, double xCoord, double yCoord, double zCoord) {
        if (!entity.f_19853_.m_5776_() && entity.m_6084_()) {
            ServerLevel sourceWorld = (ServerLevel)entity.f_19853_;
            if (!entity.m_20160_() && !entity.m_20159_()) {
                return (T)TeleportationHandler.teleportEntity(entity, sourceWorld, targetWorld, xCoord, yCoord, zCoord);
            }
            Entity lowestRidingEntity = entity.m_20201_();
            PassengerHelper passengerHelper = new PassengerHelper(lowestRidingEntity);
            passengerHelper.teleport(sourceWorld, targetWorld, xCoord, yCoord, zCoord);
            passengerHelper.remountRiders();
            passengerHelper.updateClients();
            return (T)Optional.ofNullable(passengerHelper.getPassenger(entity)).map(e -> e.entity).orElse(entity);
        }
        return entity;
    }

    private static Entity teleportEntity(Entity entity, ServerLevel sourceWorld, ServerLevel targetWorld, double xCoord, double yCoord, double zCoord) {
        if (!entity.m_6084_()) {
            return entity;
        }
        Entity entity2 = entity;
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity2;
            if (player.m_5803_()) {
                player.m_6145_(true, true);
            }
            return TeleportationHandler.teleportPlayerToDimension(player, targetWorld, xCoord, yCoord, zCoord);
        }
        if (sourceWorld != targetWorld) {
            return Optional.ofNullable(entity.m_6095_().m_20615_((Level)targetWorld)).map(newEntity -> {
                entity.m_19877_();
                newEntity.m_20361_(entity);
                newEntity.m_7678_(xCoord, yCoord, zCoord, entity.m_146908_(), entity.m_146909_());
                newEntity.m_20334_(0.0, 0.0, 0.0);
                if (newEntity instanceof Mob) {
                    ((Mob)entity).m_21573_().m_26573_();
                }
                entity.m_142467_(Entity.RemovalReason.CHANGED_DIMENSION);
                targetWorld.m_143334_(newEntity);
                sourceWorld.m_8886_();
                targetWorld.m_8886_();
                return newEntity;
            }).orElse(entity);
        }
        entity.m_7678_(xCoord, yCoord, zCoord, entity.m_146908_(), entity.m_146909_());
        return entity;
    }

    private static Player teleportPlayerToDimension(ServerPlayer player, ServerLevel targetWorld, double x, double y, double z) {
        player.m_9213_((Entity)player);
        targetWorld.m_7726_().m_8387_(TicketType.f_9448_, new ChunkPos(new BlockPos(x, y, z)), 1, (Object)player.m_142049_());
        if (targetWorld == player.f_19853_) {
            player.f_8906_.m_143617_(x, y, z, player.m_146908_(), player.m_146909_(), Collections.emptySet(), false);
        } else {
            ServerLevel serverworld = player.m_9236_();
            LevelData levelData = targetWorld.m_6106_();
            player.f_8906_.m_141995_((Packet)new ClientboundRespawnPacket(targetWorld.m_6042_(), targetWorld.m_46472_(), BiomeManager.m_47877_((long)targetWorld.m_7328_()), player.f_8941_.m_9290_(), player.f_8941_.m_9293_(), targetWorld.m_46659_(), targetWorld.m_8584_(), true));
            player.f_8906_.m_141995_((Packet)new ClientboundChangeDifficultyPacket(levelData.m_5472_(), levelData.m_5474_()));
            player.f_8924_.m_6846_().m_11289_(player);
            serverworld.removePlayer(player, true);
            player.revive();
            player.m_7678_(x, y, z, player.m_146908_(), player.m_146909_());
            player.m_143425_(targetWorld);
            targetWorld.m_8622_(player);
            player.m_9209_(serverworld);
            player.f_8906_.m_143617_(x, y, z, player.m_146908_(), player.m_146909_(), Collections.emptySet(), false);
            player.f_8941_.m_9260_(targetWorld);
            player.f_8924_.m_6846_().m_11229_(player, targetWorld);
            player.f_8924_.m_6846_().m_11292_(player);
            BasicEventHooks.firePlayerChangedDimensionEvent((Player)player, (ResourceKey)serverworld.m_46472_(), (ResourceKey)targetWorld.m_46472_());
        }
        return player;
    }

    private static class PassengerHelper {
        private Entity entity;
        private final LinkedList<PassengerHelper> passengers = new LinkedList();
        private double offsetX;
        private double offsetY;
        private double offsetZ;

        PassengerHelper(Entity entity) {
            this.entity = entity;
            if (entity.m_20159_()) {
                assert (entity.m_20202_() != null);
                this.offsetX = entity.m_20185_() - entity.m_20202_().m_20185_();
                this.offsetY = entity.m_20186_() - entity.m_20202_().m_20186_();
                this.offsetZ = entity.m_20189_() - entity.m_20202_().m_20189_();
            }
            for (Entity passenger : entity.m_20197_()) {
                this.passengers.add(new PassengerHelper(passenger));
            }
        }

        private void teleport(ServerLevel sourceWorld, ServerLevel targetWorld, double xCoord, double yCoord, double zCoord) {
            this.entity.m_20153_();
            this.entity = TeleportationHandler.teleportEntity(this.entity, sourceWorld, targetWorld, xCoord, yCoord, zCoord);
            for (PassengerHelper passenger : this.passengers) {
                passenger.teleport(sourceWorld, targetWorld, xCoord, yCoord, zCoord);
            }
        }

        private void remountRiders() {
            if (this.entity == null) {
                return;
            }
            if (this.entity.m_20159_()) {
                this.entity.m_7678_(this.entity.m_20185_() + this.offsetX, this.entity.m_20186_() + this.offsetY, this.entity.m_20189_() + this.offsetZ, this.entity.m_146908_(), this.entity.m_146909_());
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.entity.m_7998_(this.entity, true);
                passenger.remountRiders();
            }
        }

        private void updateClients() {
            Entity entity = this.entity;
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                this.updateClient(serverPlayer);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        private void updateClient(ServerPlayer playerMP) {
            if (this.entity.m_20160_()) {
                playerMP.f_8906_.m_141995_((Packet)new ClientboundSetPassengersPacket(this.entity));
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        @Nullable
        private PassengerHelper getPassenger(Entity passenger) {
            if (this.entity == passenger) {
                return this;
            }
            for (PassengerHelper rider : this.passengers) {
                PassengerHelper re = rider.getPassenger(passenger);
                if (re == null) continue;
                return re;
            }
            return null;
        }
    }
}

