/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public record WorldFunctionInjector(ImmutableMap<ResourceLocation, ICommandFunction> functions) {
    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        ServerLevel serverLevel;
        ServerFunctionManager manager;
        LevelAccessor world = event.getWorld();
        LevelAccessor levelAccessor = world;
        if (levelAccessor instanceof ServerLevel && (manager = (serverLevel = (ServerLevel)levelAccessor).m_142572_().m_129890_()) != null) {
            WorldFunctionInjector.inject(manager, this.functions);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void inject(ServerFunctionManager manager, ImmutableMap<ResourceLocation, ICommandFunction> functions) {
        Map delegate = manager.f_136107_.m_136055_();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : functions.entrySet()) {
            if (delegate.containsKey(entry.getKey())) continue;
            builder.put((Object)((ResourceLocation)entry.getKey()), (Object)((ICommandFunction)entry.getValue()));
        }
        ImmutableMap uniqueFunctions = builder.build();
        if (!uniqueFunctions.isEmpty()) {
            manager.f_136107_.f_136046_ = new InjectionMap(delegate, (ImmutableMap<ResourceLocation, ICommandFunction>)uniqueFunctions, Maps.newHashMap());
        }
    }

    public static final class Builder {
        private final ImmutableMap.Builder<ResourceLocation, ICommandFunction> functions;

        private Builder() {
            this((ImmutableMap.Builder<ResourceLocation, ICommandFunction>)ImmutableMap.builder());
        }

        private Builder(ImmutableMap.Builder<ResourceLocation, ICommandFunction> functions) {
            this.functions = functions;
        }

        public Builder put(ResourceLocation name, ICommandFunction function) {
            this.functions.put((Object)name, (Object)function);
            return this;
        }

        public WorldFunctionInjector build() {
            return new WorldFunctionInjector((ImmutableMap<ResourceLocation, ICommandFunction>)this.functions.build());
        }
    }

    @FunctionalInterface
    public static interface ICommandFunction {
        public void accept(CommandSourceStack var1, ParameterMap var2);
    }

    private static final class InjectionMap
    extends ForwardingMap<ResourceLocation, CommandFunction> {
        private static final String PARAMETER_DELIMITER = "//";
        private static final Pattern PARAMETER = Pattern.compile("//([a-z_][a-z0-9_]*)/([a-z0-9._-]*)");
        private final Map<ResourceLocation, CommandFunction> delegate;
        private final ImmutableMap<ResourceLocation, ICommandFunction> functions;
        private final Map<ResourceLocation, CommandFunction> objects;

        private InjectionMap(Map<ResourceLocation, CommandFunction> delegate, ImmutableMap<ResourceLocation, ICommandFunction> functions, Map<ResourceLocation, CommandFunction> objects) {
            this.delegate = delegate;
            this.functions = functions;
            this.objects = objects;
        }

        protected Map<ResourceLocation, CommandFunction> delegate() {
            return this.delegate;
        }

        @Nullable
        public CommandFunction get(@Nullable Object key) {
            CommandFunction value = (CommandFunction)super.get(key);
            if (value == null && !super.containsKey(key) && key instanceof ResourceLocation) {
                return this.objects.computeIfAbsent((ResourceLocation)key, this::compute);
            }
            return value;
        }

        @Nullable
        private CommandFunction compute(ResourceLocation descriptor) {
            String parametersPart;
            String namePart;
            String path = descriptor.m_135815_();
            int paramStart = path.indexOf(PARAMETER_DELIMITER);
            if (paramStart >= 0) {
                namePart = path.substring(0, paramStart);
                parametersPart = path.substring(paramStart);
            } else {
                namePart = path;
                parametersPart = "";
            }
            ICommandFunction function = (ICommandFunction)this.functions.get((Object)new ResourceLocation(descriptor.m_135827_(), namePart));
            if (function != null) {
                ImmutableMap.Builder parameters = ImmutableMap.builder();
                Matcher m = PARAMETER.matcher(parametersPart).useTransparentBounds(true);
                while (m.lookingAt()) {
                    parameters.put((Object)m.group(1), this.parse(m.group(2)));
                    m.region(m.end(), m.regionEnd());
                }
                if (m.regionStart() == m.regionEnd()) {
                    ParameterMap map = new ParameterMap((ImmutableMap<String, Object>)parameters.build());
                    return new CommandFunction(new ResourceLocation("tombstone", "custom_function"), new CommandFunction.Entry[]{(manager, sender, queue, maxChainLength, depth, traceCallbacks) -> function.accept(sender, map)});
                }
            }
            return null;
        }

        private Object parse(String value) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Double.parseDouble(value);
                }
                catch (NumberFormatException numberFormatException2) {
                    if ("true".equals(value)) {
                        return Boolean.TRUE;
                    }
                    if ("false".equals(value)) {
                        return Boolean.FALSE;
                    }
                    return value;
                }
            }
        }
    }

    public record ParameterMap(ImmutableMap<String, Object> parameters) {
        public boolean hasBoolean(String name) {
            return this.get(name) instanceof Boolean;
        }

        public boolean getBoolean(String name, boolean defaultValue) {
            Object value = this.get(name);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return defaultValue;
        }

        public boolean hasInt(String name) {
            return this.get(name) instanceof Number;
        }

        public int getInt(String name, int defaultValue) {
            Object value = this.get(name);
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return defaultValue;
        }

        public boolean hasDouble(String name) {
            return this.get(name) instanceof Number;
        }

        public double getDouble(String name, double defaultValue) {
            Object value = this.get(name);
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return defaultValue;
        }

        public boolean hasString(String name) {
            return !Objects.toString(this.get(name), "").isEmpty();
        }

        public String getString(String name, String defaultValue) {
            String str = Objects.toString(this.get(name), "");
            if (str.isEmpty()) {
                return defaultValue;
            }
            return str;
        }

        private Object get(String name) {
            return this.parameters.get((Object)name);
        }
    }
}

