/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.capability.TBSoulConsumerProvider;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfDisenchantment
extends ItemGeneric
implements ISoulConsumer {
    public ItemBookOfDisenchantment() {
        super("book_of_disenchantment", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfDisenchantment.get());
    }

    public Component m_7626_(ItemStack stack) {
        return super.m_7626_(stack).m_6879_().m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (Helper.canShowTooltip(level, stack)) {
            this.addItemDesc(list);
            this.addItemUse(list);
        } else {
            this.addInfoShowTooltip(list);
        }
        super.m_7373_(stack, level, list, flag);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canEnchant(Level level, BlockPos gravePos, Player player, ItemStack stack) {
        return this.isEnabled();
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        Map list;
        ResourceLocation registryName;
        ItemStack offhand;
        if (stack.m_41720_() != this || (offhand = player.m_21206_()).m_41619_()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_DISENCHANTMENT_FAILED.getText(new Object[0]));
        }
        if (offhand.m_41720_() == Items.f_42690_) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_DISENCHANTMENT_DENIED_ITEM.getText(Items.f_42690_.m_41466_()));
        }
        if (SupportMods.TETRA.isLoaded() && (registryName = offhand.m_41720_().getRegistryName()) != null && registryName.m_135827_().equals(SupportMods.TETRA.m_7912_()) && registryName.m_135815_().startsWith("modular_")) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_DISENCHANTMENT_DENIED_ITEM.getText("Tetra Modular"));
        }
        Map map = list = SupportMods.ASTRAL_SORCERY.isLoaded() ? EnchantmentHelper.m_44882_((ListTag)offhand.m_41785_()) : EnchantmentHelper.m_44831_((ItemStack)offhand);
        if (list.size() == 0) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_DISENCHANTMENT_NO_ENCHANTMENT.getText(new Object[0]));
        }
        Iterator it = list.entrySet().iterator();
        stack.m_41774_(1);
        int enchantMax = EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.disenchanter) + 1;
        int enchantCount = 0;
        while (enchantCount < enchantMax && it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getKey() == null || entry.getValue() == null) continue;
            ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
            HashMap<Enchantment, Integer> map2 = new HashMap<Enchantment, Integer>();
            map2.put((Enchantment)entry.getKey(), (Integer)entry.getValue());
            EnchantmentHelper.m_44865_(map2, (ItemStack)book);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)book);
            it.remove();
            ++enchantCount;
        }
        int left = list.size();
        if (left == 0 && offhand.m_41783_() != null) {
            offhand.m_41783_().m_128473_("RepairCost");
        }
        EnchantmentHelper.m_44865_((Map)list, (ItemStack)offhand);
        ModTriggers.USE_DISENCHANTMENT.trigger(player);
        return ISoulConsumer.ConsumeResult.success((Component)(left == 0 ? LangKey.MESSAGE_DISENCHANTMENT_SUCCESS.getText(new Object[0]) : LangKey.MESSAGE_DISENCHANTMENT_PARTIAL_SUCCESS.getText(left)), 1);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new TBSoulConsumerProvider(this);
    }
}

