/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.capability.TBSoulConsumerProvider;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfRecycling
extends ItemGeneric
implements ISoulConsumer {
    public ItemBookOfRecycling() {
        super("book_of_recycling", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfRecycling.get());
    }

    public Component m_7626_(ItemStack stack) {
        return super.m_7626_(stack).m_6879_().m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Helper.canShowTooltip(level, stack)) {
            this.addItemDesc(tooltip);
            this.addItemUse(tooltip);
        } else {
            this.addInfoShowTooltip(tooltip);
        }
        this.addInfoInBeta(tooltip);
        super.m_7373_(stack, level, tooltip, flag);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canEnchant(Level level, BlockPos gravePos, Player player, ItemStack stack) {
        return this.isEnabled();
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        ItemStack offhand;
        if (stack.m_41720_() != this || (offhand = player.m_21206_()).m_41619_()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_RECYCLING_FAILED.getText(new Object[0]));
        }
        if (Helper.containRL((List<String>)((List)ConfigTombstone.decorative_grave.deniedItemToRecycle.get()), stack.m_41720_().getRegistryName())) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_RECYCLING_DENIED.getText(new Object[0]));
        }
        if (stack.m_41768_()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_CANT_RECYCLE_DAMAGED.getText(new Object[0]));
        }
        if (stack.m_41783_() != null && stack.m_41783_().m_128425_("Items", 9) || stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_CANT_RECYCLE_CONTAINER.getText(new Object[0]));
        }
        CraftingRecipe recipe = Objects.requireNonNull(player.m_20194_()).m_129894_().m_44013_(RecipeType.f_44107_).stream().filter(r -> ItemStack.m_150942_((ItemStack)r.m_8043_(), (ItemStack)offhand)).findFirst().orElse(null);
        if (recipe == null) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_NO_RECIPE_TO_RECYCLE.getText(new Object[0]));
        }
        if (recipe.m_8043_().m_41613_() > offhand.m_41613_()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_RECYCLING_NOT_ENOUGH.getText(new Object[0]));
        }
        NonNullList stacks = NonNullList.m_122779_();
        for (Ingredient ing : recipe.m_7527_()) {
            if (ing.m_43947_()) continue;
            ItemStack[] items = ing.m_43908_();
            stacks.add(items[Helper.random.nextInt(items.length)]);
        }
        if (stacks.isEmpty()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_NO_RECIPE_TO_RECYCLE.getText(new Object[0]));
        }
        int maxRecycle = offhand.m_41613_() / recipe.m_8043_().m_41613_();
        for (ItemStack result : stacks) {
            int count = result.m_41613_() * maxRecycle;
            int maxSize = result.m_41741_();
            int fullStacks = count / maxSize;
            for (int i = 0; i < fullStacks; ++i) {
                ItemStack newStack = result.m_41777_();
                newStack.m_41764_(maxSize);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)newStack);
            }
            int left = count - fullStacks * maxSize;
            if (left <= 0) continue;
            ItemStack leftStack = result.m_41777_();
            leftStack.m_41764_(left);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)leftStack);
        }
        stack.m_41774_(1);
        offhand.m_41774_(recipe.m_8043_().m_41613_() * maxRecycle);
        ModTriggers.USE_RECYCLING.trigger(player);
        return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_RECYCLING_SUCCESS.getText(new Object[0]), 1);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new TBSoulConsumerProvider(this);
    }
}

