/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SmokeColumnMessage;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemDustOfVanishing
extends ItemGeneric {
    public ItemDustOfVanishing() {
        super("dust_of_vanishing", () -> SharedConfigTombstone.allowed_magic_items.allowDustOfVanishing.get());
        this.withEffect();
    }

    public Component m_7626_(ItemStack stack) {
        return super.m_7626_(stack).m_6879_().m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (Helper.canShowTooltip(level, stack)) {
            this.addItemDesc(list);
            this.addItemUse(list);
        } else {
            this.addInfoShowTooltip(list);
        }
        super.m_7373_(stack, level, list, flag);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == this) {
            if (EntityHelper.hasGlobalItemCooldown(player, this)) {
                return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
            }
            Vec3 pVec = player.m_20182_();
            if (!level.m_5776_()) {
                level.m_6263_(null, pVec.f_82479_, pVec.f_82480_, pVec.f_82481_, SoundEvents.f_11937_, SoundSource.PLAYERS, 0.5f, 0.5f);
                ServerLevel targetWorld = (ServerLevel)level;
                Location spawnPos = this.findBackwardLocation(targetWorld, player, 8.0);
                if (!spawnPos.isOrigin()) {
                    Helper.teleportEntity(player, spawnPos, targetWorld);
                } else {
                    spawnPos = this.findBackwardLocation(targetWorld, player, 3.0);
                    if (!spawnPos.isOrigin()) {
                        Helper.teleportEntity(player, spawnPos, targetWorld);
                    }
                }
                player.f_19789_ = 0.0f;
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                EffectHelper.addEffect((LivingEntity)player, ModEffects.diversion, 100);
                EntityHelper.setGlobalItemCooldown(player, this, 200);
                PacketHandler.sendToAllTrackingPlayers(new SmokeColumnMessage(player.m_142049_()), (LivingEntity)player);
                ModTriggers.USE_VANISHING.trigger((ServerPlayer)player);
            }
            ModTombstone.PROXY.produceSmokeColumn(level, pVec);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        return InteractionResult.FAIL;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (EntityHelper.isValidPlayer(context.m_43723_())) {
            return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
        }
        return InteractionResult.FAIL;
    }

    private Location findBackwardLocation(ServerLevel world, Player player, double range) {
        Vec3 lookVec = new Vec3(player.m_20154_().f_82479_, 0.0, player.m_20154_().f_82481_).m_82541_();
        return new SpawnHelper(world, new BlockPos(player.m_20182_().m_82492_(lookVec.f_82479_ * range, 0.0, lookVec.f_82481_ * range))).findSafePlace(2, true);
    }
}

