/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.capability.TBSoulConsumerProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModSounds;

public abstract class ItemGraveMagic
extends ItemGeneric
implements ISoulConsumer {
    private static final Map<UUID, Long> USING = new ConcurrentHashMap<UUID, Long>();
    protected static final String ANCIENT_NBT_BOOL = "ancient";
    protected static final String USE_COUNT_NBT_INT = "useCount";
    protected static final String COOLDOWN_TIME_NBT_LONG = "cooldown_time";

    ItemGraveMagic(String name, BooleanSupplier supplierBoolean) {
        super(name, ItemGraveMagic.getBuilder(), supplierBoolean);
    }

    public Component m_7626_(ItemStack stack) {
        Component name = super.m_7626_(stack);
        return (this.isAncient(stack) ? LangKey.MESSAGE_ANCIENT_ITEM.getText(name) : (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getText(name) : name.m_6879_())).m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    public boolean isAncient(ItemStack stack) {
        return stack.m_41720_() == this && NBTStackHelper.getBoolean(stack, ANCIENT_NBT_BOOL);
    }

    protected abstract boolean doEffects(ServerLevel var1, ServerPlayer var2, ItemStack var3);

    protected ItemStack onConsumeItem(Player player, ItemStack stack) {
        int useCount = this.getUseCount(stack);
        if (useCount < 2) {
            return ItemStack.f_41583_;
        }
        return this.setUseCount(stack, --useCount);
    }

    @Override
    public boolean canEnchant(Level level, BlockPos gravePos, Player player, ItemStack stack) {
        return this.isEnabled();
    }

    @Override
    public boolean m_5812_(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (!Helper.canShowTooltip(level, stack)) {
            this.addInfoShowTooltip(list);
        }
        if (this.isEnchanted(stack)) {
            int cd;
            int uses;
            if (this.canConsumeOnUse() && (uses = this.getUseCount(stack)) > 0) {
                this.addInfo(list, LangKey.MESSAGE_USE_LEFT, uses);
            }
            if ((cd = this.getCooldown(level, stack)) > 10) {
                this.addWarn(list, LangKey.MESSAGE_IN_COOLDOWN, TimeHelper.getTimeStringWithUnit(cd));
            }
        }
        super.m_7373_(stack, level, list, flag);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.isEnchanted(stack)) {
            int cd = this.getCooldown(level, stack);
            boolean hasGCD = EntityHelper.hasGlobalItemCooldown(player, this);
            if (cd > 0 || hasGCD) {
                if (!hasGCD && !level.m_5776_()) {
                    EntityHelper.setGlobalItemCooldown(player, this, 20);
                    LangKey.MESSAGE_IN_COOLDOWN.sendMessage(player, TimeHelper.getTimeStringWithUnit(cd));
                }
                return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
            }
            player.m_6672_(hand);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        return InteractionResult.FAIL;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (EntityHelper.isValidPlayer(context.m_43723_())) {
            if (this.canBlockInteractFirst(context.m_43725_().m_8055_(context.m_8083_()), stack)) {
                return InteractionResult.PASS;
            }
            return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
        }
        return InteractionResult.FAIL;
    }

    protected boolean canBlockInteractFirst(BlockState state, ItemStack stack) {
        return !this.isEnchanted(stack) || ModBlocks.isDecorativeGrave(state.m_60734_());
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int timeLeft) {
        if (entity != null) {
            if (entity.f_19853_.m_5776_()) {
                if (timeLeft == this.m_8105_(stack) && this.isEnchanted(stack)) {
                    ModTombstone.PROXY.produceParticleCasting(entity, p -> !p.m_6117_() || p.m_21252_() == 1);
                }
            } else if (stack.m_41720_() == this && EntityHelper.isValidServerPlayer((Entity)entity)) {
                if (timeLeft == this.m_8105_(stack)) {
                    int concentrationLevel = entity.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(cap -> cap.getPerkLevelWithBonus((Player)entity, ModPerks.concentration)).orElse(0);
                    USING.put(entity.m_142081_(), TimeHelper.systemTime() + (long)((float)TimeUnit.SECONDS.toMillis(1L) * ((float)this.m_8105_(stack) / (20.0f * (concentrationLevel == 1 ? 1.1f : (concentrationLevel > 1 ? 1.4f : 1.0f))))));
                } else if (USING.containsKey(entity.m_142081_()) && USING.get(entity.m_142081_()) < TimeHelper.systemTime()) {
                    InteractionHand hand = entity.m_7655_();
                    ItemStack resultStack = ForgeEventFactory.onItemUseFinish((LivingEntity)entity, (ItemStack)entity.m_21211_().m_41777_(), (int)0, (ItemStack)this.m_5922_(stack, entity.f_19853_, entity));
                    if (resultStack != entity.m_21211_()) {
                        entity.m_21008_(hand, resultStack);
                    }
                    entity.m_5810_();
                }
            }
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (EntityHelper.isValidPlayer((Entity)entity)) {
            Player player = (Player)entity;
            if (!player.f_19853_.m_5776_() && this.isEnchanted(stack) && this.doEffects((ServerLevel)level, (ServerPlayer)player, stack)) {
                ModSounds.playSoundAllAround(ModSounds.MAGIC_USE01, SoundSource.PLAYERS, level, player.m_142538_(), 0.5f, 0.5f);
                if (!player.m_150110_().f_35937_ && this.canConsumeOnUse()) {
                    stack = this.onConsumeItem(player, stack);
                }
                if (!stack.m_41619_()) {
                    this.setCooldown(level, stack, this.getCastingCooldown());
                }
            }
            EntityHelper.setGlobalItemCooldown(player, this, 10);
        }
        return stack;
    }

    public int m_8105_(ItemStack stack) {
        return 100;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public abstract int getCastingCooldown();

    public boolean isCooldown(Level level, ItemStack stack) {
        return this.getCooldown(level, stack) > 0;
    }

    public int getCooldown(@Nullable Level level, ItemStack stack) {
        long cooldown_time;
        if (level != null && stack.m_41720_() == this && (cooldown_time = NBTStackHelper.getLong(stack, COOLDOWN_TIME_NBT_LONG, 0L)) > 0L) {
            int cd = (int)(cooldown_time - TimeHelper.worldTicks(level));
            if (cd > this.getCastingCooldown()) {
                this.setCooldown(level, stack, this.getCastingCooldown());
                return this.getCastingCooldown();
            }
            return Math.max(cd, 0);
        }
        return 0;
    }

    public void setCooldown(@Nullable Level level, ItemStack stack, int time) {
        if (level != null && stack.m_41720_() == this) {
            NBTStackHelper.setLong(stack, COOLDOWN_TIME_NBT_LONG, TimeHelper.worldTicks(level) + (long)time);
        }
    }

    public abstract int getUseMax();

    public abstract boolean canConsumeOnUse();

    public int getUseCount(ItemStack stack) {
        if (stack.m_41720_() != this) {
            return 0;
        }
        if (this.getUseMax() == 1 || !this.canConsumeOnUse()) {
            return 1;
        }
        return Math.min(NBTStackHelper.getInteger(stack, USE_COUNT_NBT_INT, 0), this.getUseMax());
    }

    protected ItemStack setUseCount(ItemStack stack, int useCount) {
        if (this.canConsumeOnUse()) {
            NBTStackHelper.setInteger(stack, USE_COUNT_NBT_INT, Math.min(useCount, this.getUseMax()));
        }
        return stack;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new TBSoulConsumerProvider(this);
    }

    protected static Item.Properties getBuilder() {
        return ItemGeneric.getBuilder().m_41487_(1).m_41486_();
    }
}

