/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModTabs;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityDecorativeGrave;

public class ItemGravePlate
extends Item {
    private final String name = "grave_plate";

    public ItemGravePlate() {
        super(new Item.Properties().m_41491_(ModTabs.mainTab).m_41487_(1));
    }

    public Component getHighlightTip(ItemStack stack, Component displayName) {
        displayName = super.m_7626_(stack);
        return EngravableHelper.isEngraved(stack) ? LangKey.MESSAGE_ENGRAVED_ITEM.getText(displayName) : displayName;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        String engravedName = EngravableHelper.getEngravedName(stack);
        Component displayName = super.m_7626_(stack);
        if (!engravedName.isEmpty()) {
            displayName = LangKey.MESSAGE_ENGRAVED_ITEM.getText(displayName);
        }
        if (tooltip.size() > 0) {
            tooltip.set(0, displayName);
        } else {
            tooltip.add(displayName);
        }
        if (engravedName.isEmpty()) {
            tooltip.add((Component)LangKey.MESSAGE_ENGRAVABLE.getText(StyleType.TOOLTIP_DESC, new Object[]{new TextComponent("[").m_7220_(Items.f_42416_.m_41466_()).m_130946_("]").m_130948_(StyleType.TOOLTIP_ITEM)}));
        } else {
            tooltip.add((Component)LangKey.MESSAGE_ENGRAVED.getText(StyleType.TOOLTIP_DESC, new Object[]{new TextComponent("\"" + engravedName + "\"").m_6270_(StyleType.TOOLTIP_ITEM)}));
        }
        super.m_7373_(stack, world, tooltip, flag);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockState state;
        if (EntityHelper.isValidPlayer(context.m_43723_()) && ModBlocks.isDecorativeGrave((state = context.m_43725_().m_8055_(context.m_8083_())).m_60734_())) {
            EntityHelper.setGlobalItemCooldown(context.m_43723_(), this, 100);
            String engravedName = EngravableHelper.getEngravedName(stack);
            if (!engravedName.isEmpty()) {
                TileEntityDecorativeGrave tile;
                if (!context.m_43725_().m_5776_() && (tile = (TileEntityDecorativeGrave)((Object)((BlockDecorativeGrave)state.m_60734_()).getTileEntity(context.m_43725_(), context.m_8083_()))) != null) {
                    String ownerName = tile.getOwnerName();
                    boolean wasEngraved = (Boolean)state.m_61143_((Property)BlockGraveBase.IS_ENGRAVED);
                    BlockState newState = (BlockState)state.m_61124_((Property)BlockGraveBase.IS_ENGRAVED, (Comparable)Boolean.valueOf(true));
                    if (!wasEngraved) {
                        context.m_43725_().m_7731_(context.m_8083_(), newState, 3);
                    } else if (!((Boolean)ConfigTombstone.decorative_grave.canReplaceGravePlate.get()).booleanValue()) {
                        LangKey.MESSAGE_GRAVE_PLATE_REPLACEMENT_NOT_ALLOWED.sendMessage(context.m_43723_(), StyleType.COLOR_OFF, new Object[0]);
                        return InteractionResult.FAIL;
                    }
                    tile.setOwner(engravedName, TimeHelper.systemTime());
                    tile.m_6596_();
                    context.m_43725_().m_7260_(context.m_8083_(), state, newState, 3);
                    if (ownerName.isEmpty()) {
                        stack.m_41774_(1);
                    } else {
                        EngravableHelper.setEngravedName(stack, ownerName);
                    }
                    ModTriggers.ENGRAVE_DECORATIVE_GRAVE.trigger((ServerPlayer)context.m_43723_());
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public Component m_7626_(ItemStack stack) {
        return new TextComponent(EngravableHelper.getEngravedName(stack));
    }

    public String m_5524_() {
        return "tombstone.item.grave_plate";
    }

    public String m_5671_(ItemStack stack) {
        return this.m_5524_();
    }

    public String getSimpleName() {
        return this.name;
    }
}

