/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModItems;

public class ItemLollipop
extends ItemGeneric {
    public ItemLollipop() {
        super("lollipop", ItemLollipop.getBuilder().m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(2.0f).m_38766_().m_38765_().m_38767_()));
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }

    public int getColor(ItemStack stack, int tintIndex) {
        if (stack.m_41720_() == this & tintIndex == 0) {
            ModelColor modelColor;
            short ordinal = NBTStackHelper.getShort(stack, "model_color", (short)-1);
            if (ordinal < 0 || ordinal >= ModelColor.values().length) {
                modelColor = ModelColor.getRandom();
                this.setColor(stack, modelColor);
            } else {
                modelColor = ModelColor.values()[ordinal];
            }
            return 0xFF000000 | modelColor.color;
        }
        return -1;
    }

    public ItemStack setColor(ItemStack stack, ModelColor modelColor) {
        if (stack.m_41720_() == this) {
            NBTStackHelper.setShort(stack, "model_color", (short)modelColor.ordinal());
        }
        return stack;
    }

    public ItemStack getRandom() {
        return this.setColor(new ItemStack((ItemLike)this), ModelColor.getRandom());
    }

    @Override
    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (Helper.canShowTooltip(level, stack)) {
            list.add((Component)new TranslatableComponent(this.m_5671_(stack) + ".desc").m_6270_(StyleType.TOOLTIP_DESC));
        } else {
            list.add((Component)LangKey.TOOLTIP_MORE_INFO.getText(StyleType.TOOLTIP_DESC, new Object[0]));
        }
        super.m_7373_(stack, level, list, flag);
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entity) {
        super.m_5922_(stack, world, entity);
        LivingEntity livingEntity = entity;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            EffectHelper.addRandomEffect((Player)serverPlayer, 12000, true);
        }
        return stack;
    }

    @Override
    public String m_5524_() {
        return "tombstone.item." + this.name;
    }

    @Override
    public String m_5671_(ItemStack stack) {
        return this.m_5524_();
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.EAT;
    }

    public static enum ModelColor {
        YELLOW(14469140),
        PURPLE(5584316),
        GREEN(4174479),
        MAGENTA(11154876),
        RED(12334416);

        private final int color;

        private ModelColor(int color) {
            this.color = color;
        }

        public static ModelColor getRandom() {
            return ModelColor.values()[Helper.random.nextInt(ModelColor.values().length)];
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Event {
        @SubscribeEvent
        public static void registerItemColors(ColorHandlerEvent.Item event) {
            event.getItemColors().m_92689_(ModItems.lollipop::getColor, new ItemLike[]{ModItems.lollipop});
        }
    }
}

