/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.SupportStructures;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemLostTablet
extends ItemGraveMagic {
    private static final String TYPE_NBT_SHORT = "type";
    private static final String ID_NBT_STRING = "id";
    private static final String POSITION_NBT_LOCATION = "position";

    public ItemLostTablet() {
        super("lost_tablet", () -> SharedConfigTombstone.allowed_magic_items.allowLostTablet.get());
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (Helper.canShowTooltip(level, stack)) {
            Type type = this.getType(stack);
            String id = type.isUnknown() ? "1" : (this.isEnchanted(stack) ? "3" : "2");
            this.addItemDesc(list, id, new Object[0]);
            if (!type.isUnknown()) {
                this.getLocationId(stack).ifPresent(rl -> list.add(type == Type.EXPLORATION ? Helper.getBiomeName(rl) : SupportStructures.getStructureName(rl)));
                Location location = this.getLocation(stack);
                if (!location.isOrigin()) {
                    this.addItemPosition(list, location);
                }
            }
            this.addItemUse(list, id, new Object[0]);
        }
        super.m_7373_(stack, level, list, flag);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (stack.m_41720_() == this && EntityHelper.isValidServerPlayer(entity) && !this.isWakeUp(stack)) {
            int cd = this.getCooldown(level, stack);
            if (cd <= 0) {
                this.setCooldown(level, stack, TimeHelper.tickFromSecond(Helper.getRandom(500, 800)));
            } else if (cd == 1) {
                ServerPlayer player = (ServerPlayer)entity;
                if (this.wakeUpMagic(player, stack)) {
                    LangKey.MESSAGE_LOST_TABLET_WAKE_UP_SUCCESS.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[0]);
                } else if (Helper.random.nextBoolean()) {
                    this.setCooldown(level, stack, TimeHelper.tickFromSecond(Helper.getRandom(1500, 1800)));
                } else {
                    LangKey.MESSAGE_LOST_TABLET_WAKE_UP_FAILED.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[0]);
                    stack.m_41774_(1);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.grave_dust, Helper.getRandom(2, 5)));
                    player.f_36095_.m_38946_();
                    ModTriggers.GRAVE_DUST_FROM_BREAKING_TABLET.trigger(player);
                }
            }
        }
    }

    @Override
    public int getCooldown(@Nullable Level level, ItemStack stack) {
        long cooldown_time;
        if (level != null && stack.m_41720_() == this && (cooldown_time = NBTStackHelper.getLong(stack, "cooldown_time", 0L)) > 0L) {
            int cd = (int)(cooldown_time - TimeHelper.worldTicks(level));
            if (cd > 1800) {
                this.setCooldown(level, stack, 1800);
                return 1800;
            }
            return Math.max(cd, 0);
        }
        return 0;
    }

    private boolean wakeUpMagic(ServerPlayer player, ItemStack stack) {
        String rl;
        Location location;
        ServerLevel world = player.m_9236_();
        Type type = Type.roll(player);
        if (type == Type.EXPLORATION) {
            location = new Location(Helper.getCloserValidPos((Level)world, player.m_142538_().m_142022_(Helper.random.nextGaussian() * 10000.0 + 500.0, 0.0, Helper.random.nextGaussian() * 10000.0 + 500.0)), (Level)world);
            rl = Objects.requireNonNull(world.m_46857_(location.getPos()).getRegistryName()).toString();
        } else {
            ResourceKey dimension;
            boolean noStructureInCurrentWorld;
            if (type == Type.VILLAGE) {
                rl = SupportStructures.VILLAGE.getId();
            } else {
                rl = (Boolean)ConfigTombstone.decorative_grave.lostTabletSearchModdedStructure.get() != false ? SupportStructures.getRandomStructure(structure -> !SupportStructures.VILLAGE.is((ResourceLocation)structure) && !Helper.containRL((List<String>)((List)ConfigTombstone.decorative_grave.lostTabletDeniedStructures.get()), structure)) : SupportStructures.getRandomVanillaStructure(structure -> !SupportStructures.VILLAGE.is((ResourceLocation)structure));
                if (rl == null) {
                    type = Type.VILLAGE;
                    rl = SupportStructures.VILLAGE.getId();
                }
            }
            StructureFeature<?> structure2 = SupportStructures.getStructure(rl);
            if (structure2 == null) {
                return false;
            }
            boolean bl = noStructureInCurrentWorld = !SupportStructures.hasStructureInWorld(world, structure2);
            if ((noStructureInCurrentWorld || Helper.random.nextFloat() < 0.3f) && ((Boolean)ConfigTombstone.decorative_grave.lostTabletSearchOutsideWorld.get() != false ? ((dimension = (ResourceKey)Helper.getRandomInList(SupportStructures.getDimensionTypesForStructure(world.m_142572_(), structure2)).orElse(null)) != null ? (world = world.m_142572_().m_129880_(dimension)) == null : noStructureInCurrentWorld) : noStructureInCurrentWorld)) {
                return false;
            }
            location = Helper.findNearestStructure(world, player.m_142538_(), rl, true);
        }
        if (location.isOrigin() || !Helper.isValidPos((Level)world, location.getPos())) {
            return false;
        }
        NBTStackHelper.setShort(stack, TYPE_NBT_SHORT, (short)type.ordinal());
        NBTStackHelper.setString(stack, ID_NBT_STRING, rl);
        NBTStackHelper.setLocation(stack, POSITION_NBT_LOCATION, location);
        switch (type) {
            case EXPLORATION: {
                ModTriggers.FIND_LOST_TABLET_EXPLORATION.trigger(player);
                break;
            }
            case VILLAGE: {
                ModTriggers.FIND_LOST_TABLET_VILLAGE.trigger(player);
                break;
            }
            case TREASURE: {
                ModTriggers.FIND_LOST_TABLET_TREASURE.trigger(player);
            }
        }
        return true;
    }

    public Optional<String> getLocationId(ItemStack stack) {
        String id;
        if (stack.m_41720_() == this && !(id = NBTStackHelper.getString(stack, ID_NBT_STRING)).isEmpty()) {
            return Optional.of(id);
        }
        return Optional.empty();
    }

    public boolean isWakeUp(ItemStack stack) {
        return stack.m_41720_() == this && !this.getType(stack).isUnknown();
    }

    @Override
    public boolean canEnchant(Level level, BlockPos gravePos, Player player, ItemStack stack) {
        return super.canEnchant(level, gravePos, player, stack) && this.isWakeUp(stack);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return this.isWakeUp(stack) && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (this.isWakeUp(stack)) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return ISoulConsumer.ConsumeResult.success(1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    protected boolean doEffects(ServerLevel level, ServerPlayer player, ItemStack stack) {
        Location location = this.getLocation(stack);
        Optional<String> id = this.getLocationId(stack);
        if (id.isEmpty() || location.isOrigin()) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendMessage((Player)player, new Object[0]);
            this.resetStack((Level)level, stack);
            return false;
        }
        if (!((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue() && !location.isSameDimension((Level)level)) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        ServerLevel targetWorld = Objects.requireNonNull(player.m_20194_()).m_129880_(location.dim);
        if (!Helper.isValidPos((Level)targetWorld, location.getPos())) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendMessage((Player)player, new Object[0]);
            this.resetStack((Level)level, stack);
            return false;
        }
        Location spawnLoc = new SpawnHelper(targetWorld, location.getPos()).findStructurePlace(id.get());
        if (spawnLoc.isOrigin()) {
            LangKey.MESSAGE_NO_SPAWN.sendMessage((Player)player, new Object[0]);
            this.resetStack((Level)level, stack);
            return false;
        }
        EntityHelper.setGlobalItemCooldown((Player)player, this, 10);
        NBTStackHelper.removeKeyName(stack, "enchant");
        NBTStackHelper.setLocation(stack, POSITION_NBT_LOCATION, spawnLoc);
        if (this.getType(stack) == Type.EXPLORATION) {
            String rl = Objects.requireNonNull(level.m_46857_(spawnLoc.getPos()).getRegistryName()).toString();
            if (!id.get().equals(rl)) {
                NBTStackHelper.setString(stack, ID_NBT_STRING, rl);
            }
        }
        CallbackHandler.addFastCallback(() -> {
            ServerPlayer newPlayer = Helper.teleportEntity(player, spawnLoc, targetWorld);
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((Player)newPlayer, new Object[0]);
            ModTriggers.USE_LOST_TABLET.trigger(newPlayer);
        });
        return true;
    }

    private void resetStack(Level level, ItemStack stack) {
        this.setCooldown(level, stack, TimeHelper.tickFromMinute(10));
        NBTStackHelper.removeKeyName(stack, "enchant", TYPE_NBT_SHORT, ID_NBT_STRING);
        NBTStackHelper.removeLocation(stack, POSITION_NBT_LOCATION);
    }

    public Location getLocation(ItemStack stack) {
        return stack.m_41720_() == this ? NBTStackHelper.getLocation(stack, POSITION_NBT_LOCATION) : Location.ORIGIN;
    }

    @Override
    public int getCastingCooldown() {
        return 0;
    }

    @Override
    public int getUseMax() {
        return 1;
    }

    @Override
    public boolean canConsumeOnUse() {
        return false;
    }

    public Type getType(ItemStack stack) {
        return Type.byId(NBTStackHelper.getShort(stack, TYPE_NBT_SHORT));
    }

    public static enum Type {
        UNKNOWN,
        EXPLORATION,
        VILLAGE,
        TREASURE;


        public boolean isUnknown() {
            return this == UNKNOWN;
        }

        public static Type roll(ServerPlayer player) {
            int roll = Helper.random.nextInt(100) + EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.treasure_seeker) * 10;
            return roll < 60 ? EXPLORATION : (roll < 90 ? VILLAGE : TREASURE);
        }

        private static Type byId(short id) {
            return id >= Type.values().length ? UNKNOWN : Type.values()[Math.max(0, id)];
        }
    }
}

