/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemScrollOfKnowledge
extends ItemScroll
implements IDelayedNBTLoot {
    public ItemScrollOfKnowledge() {
        super("scroll_of_knowledge", () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfKnowledge.get());
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (Helper.canShowTooltip(level, stack)) {
            if (!this.isEnchanted(stack)) {
                this.addItemDesc(list, "1", new Object[0]);
                this.addItemUse(list, "1", new Object[0]);
            } else {
                this.addItemDesc(list, "2", new Object[0]);
                this.addInfo(list, LangKey.MESSAGE_STORED_EXPERIENCE, this.getStoredXp(stack));
                this.addItemUse(list, "2", new Object[0]);
            }
        }
        super.m_7373_(stack, level, list, flag);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return this.getStoredXp(stack) > 0;
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        boolean valid = this.setStoredXp(stack, EntityHelper.getPlayerTotalXp((Player)player));
        if (valid) {
            player.f_36079_ = 0;
            player.f_36078_ = 0;
            player.f_36080_ = 0.0f;
            return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_LOSE_EXPERIENCE_SUCCESS.getText(new Object[0]), 1);
        }
        return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_LOSE_EXPERIENCE_FAILED.getText(new Object[0]));
    }

    @Override
    protected boolean doEffects(ServerLevel world, ServerPlayer player, ItemStack stack) {
        int i;
        int storedXp = this.getStoredXp(stack);
        if (storedXp > (i = Integer.MAX_VALUE - player.f_36079_)) {
            LangKey.MESSAGE_EARN_EXPERIENCE_FAILED.sendMessage((Player)player, new Object[0]);
            return false;
        }
        EntityHelper.setPlayerXp((Player)player, EntityHelper.getPlayerTotalXp((Player)player) + storedXp);
        LangKey.MESSAGE_EARN_EXPERIENCE_SUCCESS.sendMessage((Player)player, new Object[0]);
        ModTriggers.USE_KNOWLEDGE.trigger(player);
        return true;
    }

    public int getStoredXp(ItemStack stack) {
        return Math.max(NBTStackHelper.getInteger(stack, "stored_xp"), 0);
    }

    public boolean setStoredXp(ItemStack stack, int xp) {
        if (stack.m_41720_() == this && xp > 0) {
            NBTStackHelper.setInteger(stack, "stored_xp", xp);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, CompoundTag tag, LootContext context) {
        tag.m_128405_("stored_xp", Helper.getRandom(100, 2000));
        return stack;
    }
}

