/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfCupidity
extends ItemTablet {
    public ItemTabletOfCupidity() {
        super("tablet_of_cupidity", () -> SharedConfigTombstone.allowed_magic_items.allowTabletOfCupidity.get());
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (Helper.canShowTooltip(level, stack)) {
            boolean isAncient = this.isAncient(stack);
            this.addItemDesc(list, "", new Object[0]);
            this.addItemDesc(list, isAncient ? "_ancient" : "_not_ancient", new Object[0]);
            this.addItemUse(list, this.isEnchanted(stack) ? "2" : "1", new Object[0]);
        }
        super.m_7373_(stack, level, list, flag);
    }

    @Override
    public int getUseMax() {
        return 1;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.m_41720_() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (stack.m_41720_() == this) {
            this.setUseCount(stack, this.getUseMax());
            NBTStackHelper.setBoolean(stack, "enchant", true);
            if (!this.isAncient(stack) && soulStrength > 1) {
                NBTStackHelper.setBoolean(stack, "ancient", true);
                ModTriggers.CREATE_ANCIENT_TABLET.trigger(player);
                return ISoulConsumer.ConsumeResult.success(2);
            }
            return ISoulConsumer.ConsumeResult.success(1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    protected boolean doEffects(ServerLevel world, ServerPlayer player, ItemStack stack) {
        Location spawnPos;
        boolean isAncient = this.isAncient(stack);
        TickingBlockEntity tile = Helper.getRandomInList(new CopyOnWriteArrayList(world.f_151512_).stream().filter(aTile -> !isAncient && aTile instanceof SpawnerBlockEntity || aTile instanceof ChestBlockEntity && ((RandomizableContainerBlockEntity)aTile).f_59605_ != null).collect(Collectors.toList())).orElse(null);
        if (tile != null && Helper.isValidPos((Level)world, tile.m_142689_()) && !(spawnPos = new SpawnHelper(world, tile.m_142689_()).findSpawnPlace()).isOrigin()) {
            CallbackHandler.addFastCallback(() -> {
                ServerPlayer newPlayer = Helper.teleportEntity(player, spawnPos, world);
                LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((Player)newPlayer, new Object[0]);
                if (!isAncient) {
                    newPlayer.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(newPlayer, 0, (Integer)ConfigTombstone.alignment.pointsTabletOfCupidity.get()));
                    EffectHelper.addRandomEffect((Player)newPlayer, 1200, true, true, false);
                    if (Helper.random.nextInt(5) == 0 && world.m_6106_().m_5472_() != Difficulty.PEACEFUL) {
                        IntStream.range(0, Helper.getRandom(1, 3)).forEach(i -> Helper.spawnRandomMob(world, spawnPos.getPos()));
                    }
                }
                ModTriggers.USE_CUPIDITY.trigger(newPlayer);
            });
            return true;
        }
        LangKey.MESSAGE_TABLET_SEARCH_FAILED.sendMessage((Player)player, new Object[0]);
        return true;
    }
}

