/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.capability.TBSoulConsumerProvider;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.DamageType;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemVoodooPoppet
extends ItemGeneric
implements ISoulConsumer,
IDelayedNBTLoot {
    private static final int LIMIT_VALID = DamageType.DARKNESS.ordinal() + 1;
    private static final String POPPET_PROT_PREFIX = "poppet_prot_";

    public ItemVoodooPoppet() {
        super("voodoo_poppet", ItemVoodooPoppet.getBuilder().m_41487_(1).m_41486_(), () -> SharedConfigTombstone.allowed_magic_items.allowVoodooPoppet.get());
    }

    public Component m_7626_(ItemStack stack) {
        Component name = super.m_7626_(stack);
        return (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getText(name) : name.m_6879_()).m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    public boolean m_5812_(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            this.addItemDesc(list);
            List<DamageType> damageTypes = ItemVoodooPoppet.getValidDamageTypes().filter(d -> this.hasProtection(stack, (DamageType)((Object)d))).collect(Collectors.toList());
            damageTypes.forEach(d -> list.add((Component)new TranslatableComponent(this.m_5524_() + "." + d.m_7912_()).m_130948_(StyleType.TOOLTIP_ITEM)));
            boolean enchanted = this.isEnchanted(stack);
            this.addItemUse(list, enchanted ? "3" : (damageTypes.isEmpty() ? "1" : "2"), new Object[0]);
            if (enchanted) {
                list.add((Component)ModPerks.voodoo_poppet.getSpecialInfo(EntityHelper.getPerkLevelWithBonus(ModTombstone.PROXY.getClientPlayer(), ModPerks.voodoo_poppet)).m_6879_().m_6270_(StyleType.INFO));
            }
        } else {
            this.addInfoShowTooltip(list);
        }
        super.m_7373_(stack, world, list, flag);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.m_41720_() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (!this.isEnchanted(stack) && ItemVoodooPoppet.getValidDamageTypes().anyMatch(p -> this.hasProtection(stack, (DamageType)((Object)p)))) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_ENCHANT_VOODOO_POPPET_SUCCESS.getText(new Object[0]), 1);
        }
        return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_ENCHANT_VOODOO_POPPET_FAILED.getText(new Object[0]));
    }

    public ItemStack createWithRandomProtections(int count) {
        return NBTStackHelper.setBoolean(this.setRandomProtections(new ItemStack((ItemLike)this), count), "enchant", true);
    }

    public static Stream<DamageType> getValidDamageTypes() {
        return Arrays.stream(DamageType.values(), 0, LIMIT_VALID);
    }

    public Stream<DamageType> getCraftableDamageTypes() {
        return Arrays.stream(DamageType.values(), 0, LIMIT_VALID - 1);
    }

    public ItemStack addProtection(ItemStack stack, DamageType damageType) {
        if (stack.m_41720_() == this && !this.isEnchanted(stack) && !this.hasProtection(stack, damageType)) {
            NBTStackHelper.setBoolean(stack, POPPET_PROT_PREFIX + damageType.ordinal(), true);
        }
        return stack;
    }

    public boolean hasProtection(ItemStack stack, DamageType damageType) {
        return stack.m_41720_() == this && NBTStackHelper.getBoolean(stack, POPPET_PROT_PREFIX + damageType.ordinal());
    }

    public boolean preventDeath(ServerPlayer player, DamageSource source) {
        DamageType damageType = this.getPoppetProtection(source);
        if (damageType == null) {
            return false;
        }
        int chance = 50 + EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.voodoo_poppet) * 10;
        if (player.m_150109_().f_35974_.stream().noneMatch(p -> this.canPreventDeath((ItemStack)p, damageType))) {
            return false;
        }
        ItemStack stack = InventoryHelper.findItemInMainInventory((Player)player, p -> this.canPreventDeath((ItemStack)p, damageType) && Helper.random.nextInt(100) < chance);
        if (stack.m_41619_()) {
            LangKey.MESSAGE_VOODOO_POPPET_PREVENT_DEATH_FAILED.getText(new Object[0]);
            return false;
        }
        NBTStackHelper.removeKeyName(stack, POPPET_PROT_PREFIX + damageType.ordinal());
        if (ItemVoodooPoppet.getValidDamageTypes().noneMatch(d -> this.hasProtection(stack, (DamageType)((Object)d)))) {
            stack.m_41774_(1);
        }
        int duration = TimeHelper.tickFromSecond((Integer)ConfigTombstone.decorative_grave.durationVoodooPoppetEffects.get());
        LangKey.sendMessage((Component)new TranslatableComponent("message.prevent_death." + damageType.m_7912_()), (Player)player, StyleType.MESSAGE_SPECIAL);
        ModTriggers.PREVENT_DEATH.get((Object)damageType).trigger(player);
        switch (damageType) {
            case SUFFOCATION: {
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19605_, duration, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19608_, duration);
                break;
            }
            case BURN: {
                player.m_20095_();
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19605_, duration, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19607_, duration);
                break;
            }
            case LIGHTNING: {
                player.m_20095_();
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19605_, duration, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, ModEffects.lightning_resistance, duration);
                break;
            }
            case FALL: {
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19605_, duration, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, ModEffects.feather_fall, duration);
                break;
            }
            case COLD: {
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19605_, duration, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19598_, duration);
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19596_, duration);
                break;
            }
            case DARKNESS: {
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19605_, duration, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19618_, duration);
                EffectHelper.clearBadEffects((LivingEntity)player);
            }
        }
        return true;
    }

    public boolean canPreventDeath(ItemStack stack, DamageType damageType) {
        return this.isEnchanted(stack) && NBTStackHelper.getBoolean(stack, POPPET_PROT_PREFIX + damageType.ordinal());
    }

    @Nullable
    public DamageType getPoppetProtection(DamageSource srcDmg) {
        DamageType damageType = DamageType.of(srcDmg);
        return ItemVoodooPoppet.getValidDamageTypes().filter(d -> d == damageType).findFirst().orElse(null);
    }

    private ItemStack setRandomProtections(ItemStack stack, int count) {
        List<DamageType> damages = ItemVoodooPoppet.getValidDamageTypes().collect(Collectors.toList());
        if (count < LIMIT_VALID) {
            int toRemove = LIMIT_VALID - 1 - count;
            for (int i = 0; i < toRemove; ++i) {
                damages.remove(Helper.random.nextInt(damages.size()));
            }
        }
        damages.forEach(d -> this.addProtection(stack, (DamageType)((Object)d)));
        return stack;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, CompoundTag tag, LootContext context) {
        return NBTStackHelper.setBoolean(this.setRandomProtections(stack, Helper.random.nextInt(5) + 1), "enchant", true);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new TBSoulConsumerProvider(this);
    }
}

