/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;

public class PreciseEnchantFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation RL = new ResourceLocation("tombstone", "precise_enchant");
    public static final Serializer SERIALIZER = new Serializer();
    private final String id;
    private final int level;

    private PreciseEnchantFunction(LootItemCondition[] conditionsIn, String id, int level) {
        super(conditionsIn);
        this.id = id;
        this.level = level;
    }

    public LootItemFunctionType m_7162_() {
        return ModTombstone.PRECISE_ENCHANT;
    }

    public ItemStack m_7372_(ItemStack stack, LootContext context) {
        ResourceLocation rl = new ResourceLocation(this.id);
        Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(rl);
        if (enchant != null && (!"tombstone".equals(rl.m_135827_()) || ((TombstoneEnchantment)enchant).isEnabled())) {
            EnchantmentHelper.m_44865_(Collections.singletonMap(enchant, this.level), (ItemStack)stack);
            return stack;
        }
        return stack.m_41720_() == Items.f_42690_ ? ItemStack.f_41583_ : stack;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<PreciseEnchantFunction> {
        public PreciseEnchantFunction deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootItemCondition[] conditionsIn) {
            return new PreciseEnchantFunction(conditionsIn, GsonHelper.m_13851_((JsonObject)json, (String)"id", (String)"tombstone:soulbound"), GsonHelper.m_13824_((JsonObject)json, (String)"level", (int)1));
        }

        public void serialize(JsonObject json, PreciseEnchantFunction fct, JsonSerializationContext serializationContext) {
            super.m_6170_(json, (LootItemConditionalFunction)fct, serializationContext);
            json.addProperty("id", fct.id);
            json.addProperty("level", (Number)fct.level);
        }
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final String id;
        private final int level;

        public Builder(Enchantment enchantment) {
            this(enchantment, 1);
        }

        public Builder(Enchantment enchantment, int level) {
            this.id = Objects.requireNonNull(enchantment.getRegistryName()).toString();
            this.level = level;
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction m_7453_() {
            return new PreciseEnchantFunction(this.m_80699_(), this.id, this.level);
        }
    }
}

