/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.Helper;

public record SmokeColumnMessage(int entityId) {
    static SmokeColumnMessage fromBytes(FriendlyByteBuf buf) {
        return new SmokeColumnMessage(buf.readInt());
    }

    static void toBytes(SmokeColumnMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
    }

    public static class Handler {
        static void handle(SmokeColumnMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(() -> ModTombstone.PROXY.getClientWorld().ifPresent(level -> Optional.ofNullable(level.m_6815_(msg.entityId)).map(Entity::m_20182_).ifPresent(pos -> ModTombstone.PROXY.produceSmokeColumn((Level)level, (Vec3)pos))));
            }
            ctx.setPacketHandled(true);
        }
    }
}

