/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModTriggers;

public record TriggerCombineInInventoryMessage(CombineType combineType) {
    public static TriggerCombineInInventoryMessage fromBytes(FriendlyByteBuf buf) {
        return new TriggerCombineInInventoryMessage(CombineType.values()[Mth.m_14045_((int)(buf.readByte() & 0xFF), (int)0, (int)CombineType.values().length)]);
    }

    public static void toBytes(TriggerCombineInInventoryMessage msg, FriendlyByteBuf buf) {
        buf.writeByte(msg.combineType.ordinal());
    }

    public static enum CombineType {
        GRAVE_KEY,
        BONE_NEEDLE,
        GRAVE_PLATE;

    }

    public static class Handler {
        static void handle(TriggerCombineInInventoryMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
            ServerPlayer player;
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx) && (player = ctx.getSender()) != null) {
                ctx.enqueueWork(() -> ModTriggers.COMBINE_IN_INVENTORY.trigger(player));
            }
            ctx.setPacketHandled(true);
        }
    }
}

