/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.SpawnProtectionHandler;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpdateServerMessage;

public record UpdateClientMessage(BlockPos spawnPos, int range, boolean dateAroundHalloween, boolean isAprilFoolsDay, boolean isContributor) {
    static UpdateClientMessage fromBytes(FriendlyByteBuf buf) {
        return new UpdateClientMessage(BlockPos.m_122022_((long)buf.readLong()), buf.readInt(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
    }

    static void toBytes(UpdateClientMessage msg, FriendlyByteBuf buf) {
        buf.writeLong(msg.spawnPos.m_121878_());
        buf.writeInt(msg.range);
        buf.writeBoolean(msg.dateAroundHalloween);
        buf.writeBoolean(msg.isAprilFoolsDay);
        buf.writeBoolean(msg.isContributor);
    }

    public static class Handler {
        static void handle(UpdateClientMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(() -> {
                    SpawnProtectionHandler.getInstance().setSpawnProtection(message.spawnPos, message.range);
                    TimeHelper.IS_HALLOWEEN = message.dateAroundHalloween;
                    TimeHelper.IS_APRIL_FOOLS = message.isAprilFoolsDay;
                    Helper.IS_CONTRIBUTOR = message.isContributor;
                    PacketHandler.sendToServer(new UpdateServerMessage(ModTombstone.PROXY.initPlayerPreference(), true));
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

