/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.BitSet;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.Helper;

public record UpdateConfigMessage(BitSet boolConfigs, int[] intConfigs) {
    static UpdateConfigMessage fromBytes(FriendlyByteBuf buf) {
        return new UpdateConfigMessage(BitSet.valueOf(buf.m_130052_()), buf.m_130100_());
    }

    static void toBytes(UpdateConfigMessage msg, FriendlyByteBuf buf) {
        buf.m_130087_(msg.boolConfigs.toByteArray());
        buf.m_130089_(msg.intConfigs);
    }

    public static class Handler {
        static void handle(UpdateConfigMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(() -> SharedConfigTombstone.updateConfig(message.boolConfigs, message.intConfigs));
            }
            ctx.setPacketHandled(true);
        }
    }
}

