/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import java.lang.ref.WeakReference;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.particle.CustomParticle;

@OnlyIn(value=Dist.CLIENT)
public class ParticleShield
extends CustomParticle {
    private static final ResourceLocation COMMON_TEXTURE = new ResourceLocation("tombstone", "textures/item/pray_of_protection.png");
    static final double TWO_PI = Math.PI * 2;
    private final WeakReference<LivingEntity> entityWeakReference;
    private final double angle;
    private final double radius;
    private final double yHeight;

    public ParticleShield(ClientLevel world, LivingEntity entity, double angle) {
        this(world, entity, angle, 0.5, 0.3);
    }

    ParticleShield(ClientLevel level, LivingEntity entity, double angle, double radius, double yHeight) {
        super(level, ParticleShield.getPos(entity, angle, radius, yHeight));
        this.isSolid = true;
        this.entityWeakReference = new WeakReference<LivingEntity>(entity);
        this.angle = angle;
        this.radius = radius;
        this.yHeight = yHeight;
        this.f_107217_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107215_ = 0.0;
        this.f_107224_ = 1;
        this.f_107225_ = 20;
        this.f_107663_ = 0.15f;
        this.f_107219_ = false;
        this.f_107226_ = 0.0f;
    }

    private static Vec3 getPos(LivingEntity entity, double angle, double radius, double yHeight) {
        double ratio = (double)(entity.f_19797_ % 100) / 100.0;
        return entity.m_20182_().m_82520_(radius * Math.cos(Math.PI * 2 * (angle + ratio)), yHeight, radius * Math.sin(Math.PI * 2 * (angle + ratio)));
    }

    public void m_5989_() {
        LivingEntity entity = (LivingEntity)this.entityWeakReference.get();
        if (entity == null || this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        Vec3 pos = ParticleShield.getPos(entity, this.angle, this.radius, this.yHeight);
        this.f_107212_ = pos.f_82479_;
        this.f_107213_ = pos.f_82480_;
        this.f_107214_ = pos.f_82481_;
    }

    @Override
    ResourceLocation getTexture() {
        return COMMON_TEXTURE;
    }
}

