/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ObjectHolder;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.registry.ModTabs;
import ovh.corail.tombstone.registry.Registrable;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBlocks {
    public static final EnumMap<GraveModel, Block> PLAYER_GRAVES = new EnumMap(Arrays.stream(GraveModel.values()).collect(Collectors.toMap(Function.identity(), BlockGrave::new)));
    public static final EnumMap<GraveModel, Block> DECORATIVE_GRAVES = new EnumMap(Arrays.stream(GraveModel.values()).collect(Collectors.toMap(Function.identity(), BlockDecorativeGrave::new)));
    @ObjectHolder(value="tombstone:dark_marble")
    public static final Block dark_marble = Blocks.f_50016_;
    @ObjectHolder(value="tombstone:white_marble")
    public static final Block white_marble = Blocks.f_50016_;

    public static boolean isPlayerGrave(Block block) {
        return PLAYER_GRAVES.containsValue(block);
    }

    public static boolean isDecorativeGrave(Block block) {
        return DECORATIVE_GRAVES.containsValue(block);
    }

    public static boolean isAnyGrave(Block block) {
        return ModBlocks.isPlayerGrave(block) || ModBlocks.isDecorativeGrave(block);
    }

    @SubscribeEvent
    public static void registerBlock(RegistryEvent.Register<Block> event) {
        PLAYER_GRAVES.forEach((m, g) -> Registrable.register(event.getRegistry(), g, m.m_7912_()));
        DECORATIVE_GRAVES.forEach((m, g) -> Registrable.register(event.getRegistry(), g, "decorative_" + m.m_7912_()));
        Registrable.register(event.getRegistry(), new BlockGraveMarble(BlockGraveMarble.MarbleType.DARK), "dark_marble");
        Registrable.register(event.getRegistry(), new BlockGraveMarble(BlockGraveMarble.MarbleType.WHITE), "white_marble");
    }

    @SubscribeEvent
    public static void registerItemBlock(RegistryEvent.Register<Item> event) {
        DECORATIVE_GRAVES.values().forEach(g -> Registrable.register(event.getRegistry(), new ItemBlockGrave((Block)g), Objects.requireNonNull(g.getRegistryName())));
        Registrable.register(event.getRegistry(), new BlockItem(dark_marble, new Item.Properties().m_41491_(ModTabs.mainTab)), Objects.requireNonNull(dark_marble.getRegistryName()));
        Registrable.register(event.getRegistry(), new BlockItem(white_marble, new Item.Properties().m_41491_(ModTabs.mainTab)), Objects.requireNonNull(white_marble.getRegistryName()));
    }
}

