/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.tileentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlockEntityTypes;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

public class TileEntityDecorativeGrave
extends TileEntityWritableGrave {
    private long lastCheckSoul = -1L;

    public TileEntityDecorativeGrave(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.tile_decorative_grave, pos, state);
    }

    @Override
    public boolean canShowFog() {
        return this.f_58857_ != null && Helper.isNight(this.f_58857_);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, TileEntityDecorativeGrave decorativeGrave) {
        SoulType soulType;
        TileEntityDecorativeGrave.commonTick(level, pos, state, decorativeGrave);
        if (TimeHelper.atInterval(decorativeGrave.countTicks, 100) && (soulType = (SoulType)((Object)state.m_61143_(BlockDecorativeGrave.SOUL_TYPE))).hasSoul()) {
            ModTombstone.PROXY.produceGraveSoul(level, pos, soulType);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TileEntityDecorativeGrave decorativeGrave) {
        TileEntityDecorativeGrave.commonTick(level, pos, state, decorativeGrave);
        long worldTicks = TimeHelper.worldTicks(level);
        if (decorativeGrave.lastCheckSoul <= 0L || decorativeGrave.lastCheckSoul > worldTicks) {
            decorativeGrave.lastCheckSoul = worldTicks;
            return;
        }
        long elapsedMinutes = TimeHelper.minuteElapsed(level, decorativeGrave.lastCheckSoul);
        if (elapsedMinutes >= (long)((Integer)ConfigTombstone.decorative_grave.timeSoul.get()).intValue()) {
            if (((SoulType)((Object)state.m_61143_(BlockDecorativeGrave.SOUL_TYPE))).hasSoul()) {
                decorativeGrave.resetCheckSoul();
                return;
            }
            long count = elapsedMinutes / (long)((Integer)ConfigTombstone.decorative_grave.timeSoul.get()).intValue();
            decorativeGrave.lastCheckSoul += count * (long)((Integer)ConfigTombstone.decorative_grave.timeSoul.get()).intValue();
            double chance = 1.0 - Math.pow(1.0 - (double)((Integer)ConfigTombstone.decorative_grave.chanceSoul.get()).intValue() / 1000.0, count);
            if (chance >= 1.0 || Helper.random.nextDouble() <= chance) {
                LightningBolt bolt;
                if (elapsedMinutes == (long)((Integer)ConfigTombstone.decorative_grave.timeSoul.get()).intValue() && (bolt = (LightningBolt)EntityType.f_20465_.m_20615_(level)) != null) {
                    bolt.m_20219_(Vec3.m_82539_((Vec3i)pos));
                    bolt.m_20874_(true);
                    level.m_7967_((Entity)bolt);
                }
                level.m_46597_(pos, (BlockState)state.m_61124_(BlockDecorativeGrave.SOUL_TYPE, (Comparable)((Object)SoulType.generateSoulType())));
            }
        }
    }

    public void resetCheckSoul() {
        this.lastCheckSoul = -1L;
    }

    @Override
    protected CompoundTag writeShared(CompoundTag compound) {
        super.writeShared(compound);
        if (this.lastCheckSoul > 0L) {
            compound.m_128356_("lastCheckSoul", this.lastCheckSoul);
        }
        return compound;
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128425_("lastCheckSoul", 4)) {
            this.lastCheckSoul = compound.m_128454_("lastCheckSoul");
        }
    }
}

