/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.tileentity;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlockEntityTypes;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

public class TileEntityPlayerGrave
extends TileEntityWritableGrave {
    protected final ItemStackHandler inventory = new ItemStackHandler(120);
    @Nullable
    private UUID ownerId = null;
    private boolean needAccess = false;

    public TileEntityPlayerGrave(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.tile_grave, pos, state);
    }

    @Override
    public boolean canShowFog() {
        return true;
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, TileEntityPlayerGrave playerGrave) {
        TileEntityPlayerGrave.commonTick(level, pos, state, playerGrave);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TileEntityPlayerGrave playerGrave) {
        TileEntityPlayerGrave.commonTick(level, pos, state, playerGrave);
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public void giveInventory(@Nullable ServerPlayer player) {
        boolean hasLosses;
        if (this.f_58857_ == null || !EntityHelper.isValidServerPlayer((Player)player)) {
            return;
        }
        assert (player != null && player.m_20194_() != null);
        boolean bl = hasLosses = (Integer)ConfigTombstone.player_death.chanceLossOnDeath.get() > 0 && (Integer)ConfigTombstone.player_death.percentLossOnDeath.get() > 0 && ((Boolean)ConfigTombstone.player_death.lossOnDeathOnlyForAbandonedGrave.get() == false || !this.getNeedAccess()) && Helper.getRandom(1, 100) <= (Integer)ConfigTombstone.player_death.chanceLossOnDeath.get();
        if (hasLosses) {
            float percentLossOnDeath = (float)((Integer)ConfigTombstone.player_death.percentLossOnDeath.get()).intValue() * 0.01f;
            int countLoss = 0;
            for (int slotId = 0; slotId < this.inventory.getSlots(); ++slotId) {
                ItemStack stack2 = this.inventory.getStackInSlot(slotId);
                if (stack2.m_41619_()) continue;
                if (stack2.m_41753_()) {
                    int losses;
                    if (stack2.m_41782_() && ((Boolean)ConfigTombstone.player_death.lossOnDeathOnlyForStackableItems.get()).booleanValue() || (losses = Math.round((float)stack2.m_41613_() * percentLossOnDeath)) <= 0) continue;
                    this.inventory.extractItem(slotId, losses, false);
                    ++countLoss;
                    continue;
                }
                if (((Boolean)ConfigTombstone.player_death.lossOnDeathOnlyForStackableItems.get()).booleanValue() || !(Helper.random.nextFloat() <= percentLossOnDeath)) continue;
                this.inventory.setStackInSlot(slotId, ItemStack.f_41583_);
                ++countLoss;
            }
            if (countLoss > 0) {
                ItemStack junkStack = TimeHelper.isDateAroundHalloween() ? ModItems.lollipop.getRandom() : (countLoss > 5 ? new ItemStack((ItemLike)ModItems.grave_dust) : (countLoss > 2 ? new ItemStack((ItemLike)Items.f_42398_) : new ItemStack((ItemLike)Blocks.f_50036_)));
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)junkStack);
                LangKey.MESSAGE_LOSSES_ON_DEATH.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            }
        }
        EventFactory.onRestoreInventory((Player)player, this);
        PlayerPreference playerPreference = PlayerPreference.get(player.m_142081_());
        if (playerPreference.getAutoEquipRule().equiOnGraveRecovery()) {
            for (int i = this.inventory.getSlots() - 1; i >= 0; --i) {
                if (!InventoryHelper.autoequip(this.inventory.getStackInSlot(i), (Player)player)) continue;
                this.inventory.setStackInSlot(i, ItemStack.f_41583_);
            }
        }
        NonNullList swapItems = NonNullList.m_122779_();
        if (playerPreference.priorizeToolOnHotbar()) {
            IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)player);
            int playerSlotId = -1;
            for (int graveSlotId = 0; graveSlotId < this.inventory.getSlots() && playerSlotId < 9; ++graveSlotId) {
                ItemStack playerStack;
                if (!InventoryHelper.isTool(this.inventory.getStackInSlot(graveSlotId))) continue;
                do {
                    playerStack = itemHandler.getStackInSlot(++playerSlotId);
                } while (playerSlotId < 9 && InventoryHelper.isTool(playerStack));
                if (!playerStack.m_41619_()) {
                    swapItems.add((Object)itemHandler.extractItem(playerSlotId, 1, false));
                }
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.inventory.extractItem(graveSlotId, 1, false), (int)playerSlotId);
                this.inventory.setStackInSlot(graveSlotId, ItemStack.f_41583_);
            }
        }
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack3 = this.inventory.getStackInSlot(i);
            if (stack3.m_41619_()) continue;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack3.m_41777_());
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
        if (!swapItems.isEmpty()) {
            swapItems.forEach(stack -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack));
            swapItems.clear();
        }
        this.removeGraveBy(player);
        EffectHelper.capDuration((LivingEntity)player, ModEffects.ghostly_shape, 100);
        player.f_36095_.m_38946_();
        LangKey.MESSAGE_OPEN_GRAVE_SUCCESS.sendMessage((Player)player, new Object[0]);
    }

    public boolean canPlunder(Player player) {
        return EntityHelper.getPerkLevelWithBonus(player, ModPerks.tomb_raider) > 0;
    }

    public boolean isAbandoned(@Nullable Player player) {
        int knowledgeLevel = player != null ? player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(cap -> Math.min(cap.getTotalPerkPoints(), 10)).orElse(0) : 0;
        int delay = (Integer)SharedConfigTombstone.player_death.decayTime.get() == -1 ? TimeHelper.tickFromDay(1) : (int)((float)TimeHelper.tickFromMinute((Integer)SharedConfigTombstone.player_death.decayTime.get()) * (1.0f - (float)knowledgeLevel * 0.05f));
        return this.getDeathMCTime() >= (long)delay;
    }

    public boolean plunder(ServerPlayer player) {
        int maxId = -1;
        for (int slotId = this.inventory.getSlots() - 1; slotId >= 0; --slotId) {
            if (this.inventory.getStackInSlot(slotId).m_41619_()) continue;
            maxId = slotId + 1;
            break;
        }
        if (maxId == -1) {
            this.removeGraveBy(player);
            return false;
        }
        boolean valid = false;
        int nbTry = 3 + Helper.random.nextInt(player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getTotalPerkPoints).orElse(1));
        for (int i = 0; i < nbTry; ++i) {
            int id = Helper.random.nextInt(maxId);
            ItemStack stack = this.inventory.getStackInSlot(id);
            if (stack.m_41619_()) continue;
            valid = true;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.inventory.extractItem(id, stack.m_41613_(), false));
        }
        if (valid) {
            CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.TOMB_RAIDING);
            player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(player, 0, (Integer)ConfigTombstone.alignment.pointsPlunderPlayerGrave.get()));
            if (InventoryHelper.hasAllSlotsEmpty((IItemHandler)this.inventory)) {
                this.removeGraveBy(player);
            } else {
                this.m_6596_();
            }
            return true;
        }
        return false;
    }

    private void removeGraveBy(ServerPlayer player) {
        ServerPlayer owner;
        if (this.f_58857_ == null) {
            return;
        }
        ServerPlayer serverPlayer = owner = player.m_36316_().getName().equals(this.ownerName) ? player : (ServerPlayer)Optional.ofNullable(player.m_20194_()).map(MinecraftServer::m_6846_).map(list -> list.m_11255_(this.ownerName)).orElse(null);
        if (owner != null) {
            DeathHandler.INSTANCE.removeGrave(owner, new Location(this.f_58858_, this.f_58857_));
        }
        DeathHandler.INSTANCE.removeAndEmptyPlayerGrave(this.f_58857_, this.f_58858_);
        this.f_58857_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12626_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void setOwner(Player player, long deathDate, boolean needAccess) {
        this.setOwner(player.m_36316_().getName(), deathDate);
        this.ownerId = player.m_142081_();
        this.needAccess = needAccess;
    }

    public boolean isOwner(Player owner) {
        return Optional.ofNullable(this.ownerId).map(id -> id.equals(owner.m_36316_().getId())).orElse(true);
    }

    @Nullable
    public UUID getOwnerId() {
        return this.ownerId;
    }

    public boolean getNeedAccess() {
        int decayTime = (Integer)SharedConfigTombstone.player_death.decayTime.get();
        return this.needAccess && (decayTime == -1 || this.getDeathMCTime() < (long)TimeHelper.tickFromMinute(decayTime));
    }

    @Override
    public CompoundTag m_6945_(CompoundTag compound) {
        super.m_6945_(compound);
        compound.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        return compound;
    }

    @Override
    protected CompoundTag writeShared(CompoundTag compound) {
        super.writeShared(compound);
        if (this.ownerId != null) {
            compound.m_128362_("owner_id", this.ownerId);
        }
        compound.m_128379_("need_access", this.needAccess);
        return compound;
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128425_("inventory", 10)) {
            this.inventory.deserializeNBT(compound.m_128469_("inventory"));
        }
        if (compound.m_128403_("owner_id")) {
            this.ownerId = compound.m_128342_("owner_id");
        }
        this.needAccess = compound.m_128471_("need_access");
    }

    public boolean m_6326_() {
        return true;
    }

    public void m_7651_() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            if (ModBlocks.isPlayerGrave(this.f_58857_.m_8055_(this.f_58858_).m_60734_())) {
                return;
            }
            if (DeathHandler.INSTANCE.canRemovePlayerGrave(this.f_58857_, this.f_58858_)) {
                for (int i = 0; i < this.inventory.getSlots(); ++i) {
                    ItemStack stack = this.inventory.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)this.inventory.extractItem(i, stack.m_41613_(), false));
                }
            }
        }
        super.m_7651_();
    }

    @Override
    public boolean isPlayerGrave() {
        return true;
    }

    public String getFormattedInfo() {
        StringBuilder builder = new StringBuilder(ChatFormatting.GOLD.toString()).append(LangKey.MESSAGE_RIP.getText(new Object[0]).getString()).append(" ").append(this.getOwnerName()).append(" ");
        if (this.getNeedAccess()) {
            int left;
            builder.append(ChatFormatting.RED).append("[").append(LangKey.MESSAGE_LOCKED.getText(new Object[0]).getString()).append("]");
            int decayTime = (Integer)SharedConfigTombstone.player_death.decayTime.get();
            if (decayTime > 0 && (left = TimeHelper.tickFromMinute(decayTime) - (int)this.getDeathMCTime()) > 0) {
                builder.append(" ").append(TimeHelper.getTimeStringWithUnit(left));
            }
        } else {
            builder.append(ChatFormatting.GREEN).append("[").append(LangKey.MESSAGE_UNLOCKED.getText(new Object[0]).getString()).append("]");
        }
        return builder.toString();
    }

    public String getFormattedDeathDate() {
        Date date = new Date(this.getOwnerDeathTime());
        return ChatFormatting.ITALIC + LangKey.MESSAGE_DIED_ON.getText(new Object[0]).getString() + " " + new SimpleDateFormat("dd/MM/yyyy").format(date) + " " + LangKey.MESSAGE_DEATH_TIME.getText(new SimpleDateFormat("HH:mm:ss").format(date)).getString();
    }
}

