/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.forge;

import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.untitledduckmod.duck.DuckEntity;
import net.untitledduckmod.goose.GooseEntity;
import net.untitledduckmod.items.DuckEggEntity;
import net.untitledduckmod.registration.EntityTypeBuilders;

public class ModEntityTypesImpl {
    private static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"untitledduckmod");
    public static final RegistryObject<EntityType<DuckEntity>> DUCK = ENTITIES.register("duck", EntityTypeBuilders.DUCK);
    public static final RegistryObject<EntityType<DuckEggEntity>> DUCK_EGG = ENTITIES.register("duck_egg", EntityTypeBuilders.DUCK_EGG);
    public static final RegistryObject<EntityType<GooseEntity>> GOOSE = ENTITIES.register("goose", EntityTypeBuilders.GOOSE);
    public static final RegistryObject<EntityType<DuckEggEntity>> GOOSE_EGG = ENTITIES.register("goose_egg", EntityTypeBuilders.GOOSE_EGG);

    public static void register(Object optionalEvent) {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ENTITIES.register(bus);
    }

    public static void registerAttributes() {
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)DUCK.get()), (AttributeModifierMap)DuckEntity.getDefaultAttributes().func_233815_a_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0).func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)GOOSE.get()), (AttributeModifierMap)GooseEntity.getDefaultAttributes().func_233815_a_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0).func_233813_a_());
    }

    public static void setupSpawning() {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)DUCK.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)GOOSE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        MinecraftForge.EVENT_BUS.addListener(ModEntityTypesImpl::onBiomeLoading);
    }

    private static void onBiomeLoading(BiomeLoadingEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getName() == null) {
            return;
        }
        List spawner = event.getSpawns().getSpawner(EntityClassification.CREATURE);
        spawner.add(new MobSpawnInfo.Spawners((EntityType)DUCK.get(), 14, 4, 4));
        spawner.add(new MobSpawnInfo.Spawners((EntityType)GOOSE.get(), 12, 4, 4));
    }

    public static EntityType<DuckEntity> getDuck() {
        return (EntityType)DUCK.get();
    }

    public static EntityType<DuckEggEntity> getDuckEgg() {
        return (EntityType)DUCK_EGG.get();
    }

    public static EntityType<GooseEntity> getGoose() {
        return (EntityType)GOOSE.get();
    }

    public static EntityType<DuckEggEntity> getGooseEgg() {
        return (EntityType)GOOSE_EGG.get();
    }
}

