/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.blocks;

import de.teamlapen.werewolves.core.ModTiles;
import de.teamlapen.werewolves.tileentity.StoneAltarTileEntity;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

@ParametersAreNonnullByDefault
public class StoneAltarBlock
extends ContainerBlock {
    protected static final VoxelShape SHAPE = StoneAltarBlock.makeShape();
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final String REG_NAME = "stone_altar";

    public StoneAltarBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_226896_b_().func_235838_a_(state -> (Boolean)state.func_177229_b((Property)LIT) != false ? 14 : 0));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected static VoxelShape makeShape() {
        VoxelShape a = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.5, (double)14.0);
        VoxelShape b1 = Block.func_208617_a((double)0.0, (double)7.0, (double)0.0, (double)2.0, (double)12.0, (double)2.0);
        VoxelShape b2 = Block.func_208617_a((double)14.0, (double)7.0, (double)14.0, (double)16.0, (double)12.0, (double)16.0);
        VoxelShape b3 = Block.func_208617_a((double)14.0, (double)7.0, (double)0.0, (double)16.0, (double)12.0, (double)2.0);
        VoxelShape b4 = Block.func_208617_a((double)0.0, (double)7.0, (double)14.0, (double)2.0, (double)12.0, (double)16.0);
        VoxelShape c1 = Block.func_208617_a((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)12.0, (double)2.0);
        VoxelShape c2 = Block.func_208617_a((double)0.0, (double)7.0, (double)7.0, (double)2.0, (double)12.0, (double)9.0);
        VoxelShape c3 = Block.func_208617_a((double)7.0, (double)7.0, (double)14.0, (double)9.0, (double)12.0, (double)16.0);
        VoxelShape c4 = Block.func_208617_a((double)14.0, (double)7.0, (double)7.0, (double)16.0, (double)12.0, (double)9.0);
        VoxelShape d1 = Block.func_208617_a((double)1.0, (double)7.0, (double)1.0, (double)15.0, (double)11.0, (double)2.0);
        VoxelShape d2 = Block.func_208617_a((double)1.0, (double)7.0, (double)1.0, (double)2.0, (double)11.0, (double)15.0);
        VoxelShape d3 = Block.func_208617_a((double)15.0, (double)7.0, (double)15.0, (double)14.0, (double)11.0, (double)2.0);
        VoxelShape d4 = Block.func_208617_a((double)15.0, (double)7.0, (double)15.0, (double)2.0, (double)11.0, (double)14.0);
        return VoxelShapes.func_216384_a((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b1, b2, b3, b4, c1, c2, c3, c4, d1, d2, d3, d4});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.dropItems(worldIn, pos);
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean isBurning(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)LIT);
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(handIn);
        StoneAltarTileEntity te = (StoneAltarTileEntity)worldIn.func_175625_s(pos);
        if (!worldIn.field_72995_K && te != null) {
            StoneAltarTileEntity.Result result = te.canActivate(player);
            switch (result) {
                case OK: {
                    if (heldItem.func_77973_b() != Items.field_151033_d && heldItem.func_77973_b() != Items.field_221657_bQ && heldItem.func_77973_b() != Items.field_234737_dp_) break;
                    te.startRitual(player);
                    return ActionResultType.SUCCESS;
                }
                case OTHER_FACTION: {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.stone_altar.wrong_faction"), true);
                    return ActionResultType.SUCCESS;
                }
                case INV_MISSING: {
                    Map<Item, Integer> missing = te.getMissingItems();
                    TranslationTextComponent s = new TranslationTextComponent("text.werewolves.stone_altar.ritual_missing_items");
                    missing.forEach((arg_0, arg_1) -> StoneAltarBlock.lambda$onBlockActivated$2((IFormattableTextComponent)s, arg_0, arg_1));
                    if (heldItem.func_77973_b() != Items.field_151033_d) break;
                    player.func_146105_b((ITextComponent)s, false);
                    return ActionResultType.SUCCESS;
                }
                case IS_RUNNING: {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.stone_altar.ritual_still_running"), true);
                    return ActionResultType.SUCCESS;
                }
                case NIGHT_ONLY: {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.stone_altar.ritual_night_only"), true);
                    return ActionResultType.SUCCESS;
                }
                case WRONG_LEVEL: {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.stone_altar.ritual_wrong_level"), true);
                    return ActionResultType.SUCCESS;
                }
                case STRUCTURE_LESS: {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.stone_altar.ritual_structures_missing"), true);
                    return ActionResultType.SUCCESS;
                }
                case STRUCTURE_LIT: {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.stone_altar.ritual_less_lit_structures"), true);
                    return ActionResultType.SUCCESS;
                }
            }
            player.func_213829_a((INamedContainerProvider)te);
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    public int getHarvestLevel(BlockState state) {
        return 2;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return ModTiles.stone_altar.func_200968_a();
    }

    private void dropItems(World world, BlockPos pos) {
        Random rand = new Random();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack item = inventory.func_70301_a(i);
                if (item.func_190926_b()) continue;
                float rx = rand.nextFloat() * 0.8f + 0.1f;
                float ry = rand.nextFloat() * 0.8f + 0.1f;
                float rz = rand.nextFloat() * 0.8f + 0.1f;
                ItemEntity entityItem = new ItemEntity(world, (double)((float)pos.func_177958_n() + rx), (double)((float)pos.func_177956_o() + ry), (double)((float)pos.func_177952_p() + rz), item.func_77946_l());
                if (item.func_77942_o()) {
                    entityItem.func_92059_d().func_77982_d(item.func_77978_p().func_74737_b());
                }
                float factor = 0.05f;
                entityItem.func_213293_j(rand.nextGaussian() * (double)factor, rand.nextGaussian() * (double)factor + (double)0.2f, rand.nextGaussian() * (double)factor);
                world.func_217376_c((Entity)entityItem);
                inventory.func_70299_a(i, ItemStack.field_190927_a);
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT});
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue()) {
            double d0 = (double)pos.func_177958_n() + rand.nextDouble();
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.5;
            double d2 = (double)pos.func_177952_p() + rand.nextDouble();
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    private static /* synthetic */ void lambda$onBlockActivated$2(IFormattableTextComponent s, Item item, Integer integer) {
        s.func_240702_b_("\n - ").func_230529_a_((ITextComponent)new TranslationTextComponent(item.func_77658_a()).func_240700_a_(style -> style.func_240712_a_(TextFormatting.AQUA).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230551_b_, (Object)new HoverEvent.ItemHover(new ItemStack((IItemProvider)item, integer.intValue())))))).func_240702_b_(" " + integer);
    }
}

