/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.core;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.lib.lib.client.gui.ExtendedGui;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.WerewolfActions;
import de.teamlapen.werewolves.core.WerewolfSkills;
import de.teamlapen.werewolves.items.ISilverItem;
import de.teamlapen.werewolves.mixin.client.InGameGuiAccessor;
import de.teamlapen.werewolves.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.player.werewolf.actions.IActionCooldownMenu;
import de.teamlapen.werewolves.player.werewolf.actions.WerewolfFormAction;
import de.teamlapen.werewolves.util.Helper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class WerewolvesHUDOverlay
extends ExtendedGui {
    private final Minecraft mc = Minecraft.func_71410_x();
    private final ResourceLocation ICONS = new ResourceLocation("werewolves", "textures/gui/hud.png");
    private final ResourceLocation FUR = new ResourceLocation("werewolves", "textures/gui/overlay/werewolf_fur_border.png");
    protected static final ResourceLocation WIDGETS_TEX_PATH = new ResourceLocation("textures/gui/widgets.png");
    private int screenColor = 0;
    private int screenPercentage = 0;
    private final List<Integer> entities = new ArrayList<Integer>();
    private int attackTargetScreenPercentage = 0;
    private int waitTicks = 0;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mc.field_71439_g == null || !this.mc.field_71439_g.func_70089_S()) {
            this.screenPercentage = 0;
            this.attackTargetScreenPercentage = 0;
            this.entities.clear();
            this.waitTicks = 0;
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        IFactionPlayer player = FactionPlayerHandler.get((PlayerEntity)this.mc.field_71439_g).getCurrentFactionPlayer().orElse(null);
        if (player instanceof WerewolfPlayer) {
            this.handleScreenColorWerewolf((WerewolfPlayer)player);
        } else {
            this.screenPercentage = 0;
            this.attackTargetScreenPercentage = 0;
            this.waitTicks = 0;
            this.entities.clear();
        }
    }

    @SubscribeEvent
    public void onRenderGui(RenderGameOverlayEvent.Pre event) {
        if (this.mc.field_71439_g == null || !this.mc.field_71439_g.func_70089_S()) {
            return;
        }
        switch (event.getType()) {
            case CROSSHAIRS: {
                this.renderCrosshair(event);
                break;
            }
            case ALL: {
                this.renderFur(event.getMatrixStack());
            }
        }
    }

    @SubscribeEvent
    public void onRenderGui(RenderGameOverlayEvent.Post event) {
        if (this.mc.field_71439_g == null || !this.mc.field_71439_g.func_70089_S()) {
            return;
        }
        switch (event.getType()) {
            case EXPERIENCE: {
                this.renderExperienceBar(event);
                break;
            }
            case ALL: {
                this.renderActionCooldown(event.getMatrixStack());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        int percentages = 0;
        int color = 0;
        if (this.screenPercentage > 0) {
            percentages = this.screenPercentage;
            color = this.screenColor;
        } else if (this.attackTargetScreenPercentage > 0) {
            percentages = this.attackTargetScreenPercentage;
            color = -37369;
        }
        if (percentages > 0 && ((Boolean)VampirismConfig.CLIENT.renderScreenOverlay.get()).booleanValue()) {
            RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
            MatrixStack stack = new MatrixStack();
            stack.func_227860_a_();
            RenderSystem.matrixMode((int)5889);
            RenderSystem.loadIdentity();
            RenderSystem.ortho((double)0.0, (double)this.mc.func_228018_at_().func_198107_o(), (double)this.mc.func_228018_at_().func_198087_p(), (double)0.0, (double)1.0, (double)-1.0);
            RenderSystem.matrixMode((int)5888);
            RenderSystem.loadIdentity();
            GL11.glDisable((int)2929);
            int w = this.mc.func_228018_at_().func_198107_o();
            int h = this.mc.func_228018_at_().func_198087_p();
            int bh = Math.round((float)h / 4.0f * (float)percentages / 100.0f);
            int bw = Math.round((float)w / 8.0f * (float)percentages / 100.0f);
            this.func_238468_a_(stack, 0, 0, w, bh, color, 0);
            this.func_238468_a_(stack, 0, h - bh, w, h, 0, color);
            this.fillGradient2(stack, 0, 0, bw, h, 0, color);
            this.fillGradient2(stack, w - bw, 0, w, h, color, 0);
            GL11.glEnable((int)2929);
            stack.func_227865_b_();
        }
    }

    public void attackTriggered(int entityId) {
        if (!this.entities.contains(entityId)) {
            this.entities.add(entityId);
            if (this.waitTicks == 0) {
                this.screenPercentage = 100;
                this.waitTicks = 100;
                this.screenColor = -37369;
            }
        }
    }

    private void handleScreenColorWerewolf(WerewolfPlayer player) {
        boolean sixth_sense = player.getSkillHandler().isSkillEnabled(WerewolfSkills.sixth_sense);
        boolean rage = player.getActionHandler().isActionActive((ILastingAction)WerewolfActions.rage);
        if (sixth_sense) {
            if (this.screenPercentage > 0) {
                this.screenPercentage -= 10;
            }
            if (this.waitTicks > 0) {
                --this.waitTicks;
            }
        } else {
            this.waitTicks = 0;
            this.entities.clear();
        }
        if (rage) {
            this.screenPercentage = 100;
            this.screenColor = -1048576;
        }
        if (!sixth_sense && !rage) {
            this.screenPercentage = 0;
        }
    }

    private void renderFangs(MatrixStack matrixStack, int width, int height, @Nullable Entity entity) {
        this.mc.func_110434_K().func_110577_a(this.ICONS);
        int left = width / 2 - 9;
        int top = height / 2 - 6;
        boolean silver = false;
        if (entity != null) {
            for (ItemStack stack : entity.func_184193_aE()) {
                if (!(stack.func_77973_b() instanceof ISilverItem)) continue;
                silver = true;
                break;
            }
        }
        GL11.glEnable((int)3042);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        WerewolvesHUDOverlay.func_238464_a_((MatrixStack)matrixStack, (int)left, (int)top, (int)this.func_230927_p_(), (float)(silver ? 30.0f : 15.0f), (float)0.0f, (int)15, (int)15, (int)256, (int)256);
        GL11.glDisable((int)3042);
    }

    private void renderFur(MatrixStack matrixStack) {
        if (((Boolean)WerewolvesConfig.CLIENT.disableScreenFurRendering.get()).booleanValue()) {
            return;
        }
        if (this.mc.field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON && Helper.isWerewolf((PlayerEntity)this.mc.field_71439_g) && WerewolfPlayer.getOpt((PlayerEntity)this.mc.field_71439_g).map(Helper::isFormActionActive).orElse(false).booleanValue()) {
            this.mc.func_110434_K().func_110577_a(this.FUR);
            RenderSystem.enableBlend();
            WerewolvesHUDOverlay.func_238464_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)this.mc.func_228018_at_().func_198105_m(), (int)this.mc.func_228018_at_().func_198083_n(), (int)this.mc.func_228018_at_().func_198087_p(), (int)this.mc.func_228018_at_().func_198107_o());
            RenderSystem.disableBlend();
        }
    }

    private void renderCrosshair(RenderGameOverlayEvent.Pre event) {
        if (Helper.isWerewolf((PlayerEntity)this.mc.field_71439_g)) {
            Entity entity;
            RayTraceResult p = Minecraft.func_71410_x().field_71476_x;
            Entity entity2 = entity = p instanceof EntityRayTraceResult ? ((EntityRayTraceResult)p).func_216348_a() : null;
            if (WerewolfPlayer.get((PlayerEntity)this.mc.field_71439_g).canBite()) {
                this.renderFangs(event.getMatrixStack(), this.mc.func_228018_at_().func_198107_o(), this.mc.func_228018_at_().func_198087_p(), entity);
                event.setCanceled(true);
            }
        }
    }

    private void renderExperienceBar(RenderGameOverlayEvent.Post event) {
        ClientPlayerEntity player = this.mc.field_71439_g;
        if (Helper.isWerewolf((PlayerEntity)player)) {
            WerewolfPlayer werewolf = WerewolfPlayer.get((PlayerEntity)player);
            if (werewolf.getSpecialAttributes().werewolfTime > 0L) {
                float trans;
                float perc = WerewolfFormAction.getDurationPercentage(werewolf);
                float f = trans = Helper.isFormActionActive(werewolf) ? 1.0f : 0.7f;
                if (!Helper.isNight(player.func_130014_f_())) {
                    this.renderExpBar(event.getMatrixStack(), perc, trans);
                }
            }
        }
    }

    private void renderExpBar(MatrixStack matrixStack, float perc, float transparency) {
        int scaledWidth = ((InGameGuiAccessor)Minecraft.func_71410_x().field_71456_v).getScaledWidth();
        int scaledHeight = ((InGameGuiAccessor)Minecraft.func_71410_x().field_71456_v).getScaledHeight();
        int x = scaledWidth / 2 - 91;
        this.mc.func_213239_aq().func_76320_a("werewolfActionDurationBar");
        this.mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)0.1f, (float)0.0f, (float)transparency);
        int k = (int)((1.0f - perc) * 183.0f);
        int l = scaledHeight - 32 + 3;
        this.func_238474_b_(matrixStack, x, l, 0, 64, 182, 5);
        this.func_238474_b_(matrixStack, x + k, l, k, 69, 182 - k, 5);
        this.mc.func_213239_aq().func_76319_b();
    }

    private void renderActionCooldown(MatrixStack matrixStack) {
        if (Helper.isWerewolf((PlayerEntity)this.mc.field_71439_g)) {
            WerewolfPlayer werewolf = WerewolfPlayer.get((PlayerEntity)this.mc.field_71439_g);
            ArrayList<IAction> actions = new ArrayList<IAction>();
            actions.addAll((Collection<IAction>)werewolf.getActionHandler().getUnlockedActions());
            actions.removeIf(action -> !(action instanceof IActionCooldownMenu));
            actions.removeIf(action -> !werewolf.getActionHandler().isActionOnCooldown(action));
            int x = 12;
            int y = this.mc.func_228018_at_().func_198087_p() - 27;
            for (IAction action2 : actions) {
                ResourceLocation loc = new ResourceLocation(action2.getRegistryName().func_110624_b(), "textures/actions/" + action2.getRegistryName().func_110623_a() + ".png");
                this.mc.func_110434_K().func_110577_a(loc);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                WerewolvesHUDOverlay.func_238464_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                float perc1 = 1.0f - -werewolf.getActionHandler().getPercentageForAction(action2);
                int perc = (int)(perc1 * 16.0f);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                WerewolvesHUDOverlay.func_238464_a_((MatrixStack)matrixStack, (int)x, (int)(y + perc), (int)this.func_230927_p_(), (float)0.0f, (float)(0 + perc), (int)16, (int)(16 - perc), (int)16, (int)16);
                x += 16;
            }
        }
    }
}

