/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.teamlapen.werewolves.client.model.WerewolfBaseModel;
import de.teamlapen.werewolves.client.model.WerewolfBeastModel;
import de.teamlapen.werewolves.client.model.WerewolfEarsModel;
import de.teamlapen.werewolves.client.model.WerewolfSurvivalistModel;
import de.teamlapen.werewolves.player.WerewolfForm;
import de.teamlapen.werewolves.player.werewolf.WerewolfPlayer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WerewolfPlayerRenderer
extends LivingRenderer<AbstractClientPlayerEntity, WerewolfBaseModel<AbstractClientPlayerEntity>> {
    private static final Map<WerewolfForm, WerewolfModelWrapper> MODELS = new HashMap<WerewolfForm, WerewolfModelWrapper>();
    private ResourceLocation texture;
    private boolean skipPlayerModel;

    public static void addModel(WerewolfForm form, WerewolfModelWrapper render) {
        MODELS.put(form, render);
    }

    public WerewolfPlayerRenderer(EntityRendererManager rendererManager) {
        super(rendererManager, null, 0.0f);
    }

    public void switchModel(WerewolfForm type) {
        WerewolfModelWrapper werewolfModelWrapper = MODELS.get(type);
        this.field_77045_g = werewolfModelWrapper.model;
        this.field_76989_e = werewolfModelWrapper.shadow;
        this.texture = werewolfModelWrapper.texture;
        this.skipPlayerModel = werewolfModelWrapper.skipPlayerModel;
    }

    public boolean render(WerewolfPlayer entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        this.switchModel(entity.getForm());
        if (this.field_77045_g != null) {
            this.render((AbstractClientPlayerEntity)entity.getRepresentingPlayer(), entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            return this.skipPlayerModel;
        }
        return false;
    }

    @Deprecated
    public void render(AbstractClientPlayerEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (!entity.func_175144_cb() || this.field_76990_c.field_217783_c.func_216773_g() == entity) {
            this.setModelVisible(entity);
            super.func_225623_a_((LivingEntity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    private void setModelVisible(AbstractClientPlayerEntity clientPlayer) {
        WerewolfBaseModel playerModel = (WerewolfBaseModel)this.func_217764_d();
        if (clientPlayer.func_175149_v()) {
            playerModel.func_178719_a(false);
            playerModel.field_78116_c.field_78806_j = true;
        } else {
            playerModel.func_178719_a(true);
            playerModel.field_228270_o_ = clientPlayer.func_213453_ef();
        }
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull AbstractClientPlayerEntity entity) {
        return this.texture;
    }

    static {
        WerewolfPlayerRenderer.addModel(WerewolfForm.NONE, new WerewolfModelWrapper(null, null, 0.0f, false));
        WerewolfPlayerRenderer.addModel(WerewolfForm.HUMAN, new WerewolfModelWrapper(new WerewolfEarsModel<AbstractClientPlayerEntity>(), new ResourceLocation("werewolves", "textures/entity/werewolf/human/werewolf_ear_claws.png"), 0.5f, false));
        WerewolfPlayerRenderer.addModel(WerewolfForm.BEAST, new WerewolfModelWrapper(new WerewolfBeastModel<AbstractClientPlayerEntity>(), new ResourceLocation("werewolves", "textures/entity/werewolf/beast/beast_1.png"), 1.3f, true));
        WerewolfPlayerRenderer.addModel(WerewolfForm.SURVIVALIST, new WerewolfModelWrapper(new WerewolfSurvivalistModel<AbstractClientPlayerEntity>(), new ResourceLocation("werewolves", "textures/entity/werewolf/survivalist/survivalist_1.png"), 0.5f, true));
    }

    private static class WerewolfModelWrapper {
        private final WerewolfBaseModel<AbstractClientPlayerEntity> model;
        private final ResourceLocation texture;
        private final float shadow;
        private final boolean skipPlayerModel;

        public WerewolfModelWrapper(WerewolfBaseModel<AbstractClientPlayerEntity> model, ResourceLocation texture, float shadow, boolean skipPlayerModel) {
            this.model = model;
            this.texture = texture;
            this.shadow = shadow;
            this.skipPlayerModel = skipPlayerModel;
        }
    }
}

