/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.werewolves.WerewolvesMod;
import de.teamlapen.werewolves.entities.AggressiveWolfEntity;
import de.teamlapen.werewolves.entities.werewolf.BasicWerewolfEntity;
import de.teamlapen.werewolves.entities.werewolf.HumanWerewolfEntity;
import de.teamlapen.werewolves.entities.werewolf.WerewolfBaseEntity;
import de.teamlapen.werewolves.entities.werewolf.WerewolfTaskMasterEntity;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="werewolves")
public class ModEntities
extends de.teamlapen.vampirism.core.ModEntities {
    private static final Set<EntityType<?>> ALL_ENTITIES = Sets.newHashSet();
    public static final EntityType<BasicWerewolfEntity.Beast> werewolf_beast;
    public static final EntityType<BasicWerewolfEntity.Survivalist> werewolf_survivalist;
    public static final EntityType<HumanWerewolfEntity> human_werewolf;
    public static final EntityType<WerewolfTaskMasterEntity> task_master_werewolf;
    public static final EntityType<AggressiveWolfEntity> wolf;

    static void registerEntities(IForgeRegistry<EntityType<?>> registry) {
        registry.register(werewolf_beast);
        registry.register(werewolf_survivalist);
        registry.register(human_werewolf);
        registry.register(ModEntities.prepareEntityType("wolf", EntityType.Builder.func_220322_a(AggressiveWolfEntity::new, (EntityClassification)EntityClassification.AMBIENT).func_220321_a(0.6f, 0.85f), false));
        registry.register(ModEntities.prepareEntityType("task_master_werewolf", EntityType.Builder.func_220322_a(WerewolfTaskMasterEntity::new, (EntityClassification)WerewolvesMod.WEREWOLF_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), true));
    }

    static void registerSpawns() {
        EntitySpawnPlacementRegistry.func_209343_a(werewolf_beast, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, WerewolfBaseEntity::spawnPredicateWerewolf);
        EntitySpawnPlacementRegistry.func_209343_a(werewolf_survivalist, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, WerewolfBaseEntity::spawnPredicateWerewolf);
        EntitySpawnPlacementRegistry.func_209343_a(human_werewolf, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, HumanWerewolfEntity::spawnPredicateHumanWerewolf);
        EntitySpawnPlacementRegistry.func_209343_a(wolf, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
    }

    private static <T extends Entity> EntityType<T> prepareEntityType(String id, EntityType.Builder<T> builder, boolean spawnable) {
        EntityType.Builder type = builder.setTrackingRange(80).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true);
        if (!spawnable) {
            type.func_200705_b();
        }
        EntityType entry = type.func_206830_a("werewolves:" + id);
        entry.setRegistryName("werewolves", id);
        ALL_ENTITIES.add(entry);
        return entry;
    }

    static void registerEntityTypeAttributes() {
        GlobalEntityTypeAttributes.put(human_werewolf, (AttributeModifierMap)HumanWerewolfEntity.getAttributeBuilder().func_233813_a_());
        GlobalEntityTypeAttributes.put(werewolf_beast, (AttributeModifierMap)BasicWerewolfEntity.getAttributeBuilder().func_233813_a_());
        GlobalEntityTypeAttributes.put(werewolf_survivalist, (AttributeModifierMap)BasicWerewolfEntity.getAttributeBuilder().func_233813_a_());
        GlobalEntityTypeAttributes.put(wolf, (AttributeModifierMap)AggressiveWolfEntity.func_234233_eS_().func_233813_a_());
        GlobalEntityTypeAttributes.put(task_master_werewolf, (AttributeModifierMap)WerewolfTaskMasterEntity.getAttributeBuilder().func_233813_a_());
    }

    public static Set<EntityType<?>> getAllEntities() {
        return ImmutableSet.copyOf(ALL_ENTITIES);
    }

    static {
        task_master_werewolf = (EntityType)UtilLib.getNull();
        wolf = (EntityType)UtilLib.getNull();
        werewolf_beast = ModEntities.prepareEntityType("werewolf_beast", EntityType.Builder.func_220322_a(BasicWerewolfEntity.Beast::new, (EntityClassification)WerewolvesMod.WEREWOLF_CREATURE_TYPE).func_220321_a(0.8f, 2.0f), true);
        werewolf_survivalist = ModEntities.prepareEntityType("werewolf_survivalist", EntityType.Builder.func_220322_a(BasicWerewolfEntity.Survivalist::new, (EntityClassification)WerewolvesMod.WEREWOLF_CREATURE_TYPE).func_220321_a(0.8f, 1.0f), true);
        human_werewolf = ModEntities.prepareEntityType("human_werewolf", EntityType.Builder.func_220322_a(HumanWerewolfEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.9f), true);
    }
}

