/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.core;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.entity.EntityType;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ModLootTables {
    private static final Map<ResourceLocation, ResourceLocation> INJECTION_TABLES = Maps.newHashMap();
    public static final ResourceLocation villager = ModLootTables.entity(EntityType.field_200756_av);
    public static final ResourceLocation skeleton = ModLootTables.entity(EntityType.field_200741_ag);

    static ResourceLocation entity(EntityType<?> type) {
        ResourceLocation loc = type.func_220348_g();
        ResourceLocation newLoc = new ResourceLocation("werewolves", "inject/" + loc.func_110623_a());
        INJECTION_TABLES.put(loc, newLoc);
        return newLoc;
    }

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent event) {
        if (INJECTION_TABLES.containsKey(event.getName())) {
            try {
                event.getTable().addPool(ModLootTables.getInjectPool(event.getName()));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private static LootPool getInjectPool(ResourceLocation loc) {
        TableLootEntry.func_216171_a((ResourceLocation)INJECTION_TABLES.get(loc)).func_216086_a(1);
        return LootPool.func_216096_a().name("werewolves_inject_pool").bonusRolls(0.0f, 1.0f).func_216046_a((IRandomRange)new RandomValueRange(1.0f)).func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)INJECTION_TABLES.get(loc)).func_216086_a(1)).func_216044_b();
    }
}

