/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.data;

import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModItems;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "werewolves", existingFileHelper);
    }

    protected void registerModels() {
        HashSet<Block> blockParent = new HashSet<Block>(){
            {
                this.add(ModBlocks.silver_ore);
                this.add(ModBlocks.silver_block);
                this.add(ModBlocks.jacaranda_leaves);
                this.add(ModBlocks.jacaranda_log);
                this.add(ModBlocks.magic_leaves);
                this.add(ModBlocks.magic_log);
                this.add(ModBlocks.magic_planks);
                this.add(ModBlocks.totem_top_werewolves_werewolf);
                this.add(ModBlocks.totem_top_werewolves_werewolf_crafted);
            }
        };
        HashSet<Item> itemsLayer = new HashSet<Item>(){
            {
                this.add(ModItems.silver_ingot);
                this.add(ModItems.liver);
                this.add(ModItems.bone);
                this.add(ModItems.injection_un_werewolf);
            }
        };
        HashSet<Block> blockLayer = new HashSet<Block>(){
            {
                this.add(ModBlocks.jacaranda_sapling);
                this.add(ModBlocks.magic_sapling);
                this.add(ModBlocks.wolfsbane);
            }
        };
        HashSet<Item> itemsHandHeld = new HashSet<Item>(){
            {
                this.add(ModItems.silver_axe);
                this.add(ModItems.silver_pickaxe);
                this.add(ModItems.silver_sword);
                this.add(ModItems.silver_shovel);
                this.add(ModItems.silver_hoe);
            }
        };
        blockParent.forEach(this::block);
        itemsLayer.forEach(x$0 -> this.item((Item)x$0, new ResourceLocation[0]));
        blockLayer.forEach(x$0 -> this.blockLayer((Block)x$0, new ResourceLocation[0]));
        itemsHandHeld.forEach(item -> this.item((Item)item, "item/handheld", new ResourceLocation[0]));
        this.withExistingParent((Item)ModItems.werewolf_beast_spawn_egg, this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent((Item)ModItems.werewolf_survivalist_spawn_egg, this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent((Item)ModItems.human_werewolf_spawn_egg, this.mcLoc("item/template_spawn_egg"));
    }

    @Nonnull
    public String func_200397_b() {
        return "Werewolves item model generator";
    }

    public ItemModelBuilder item(String item, ResourceLocation ... texture) {
        ItemModelBuilder model = (ItemModelBuilder)this.withExistingParent(item, this.mcLoc("item/generated"));
        for (int i = 0; i < texture.length; ++i) {
            model.texture("layer" + i, texture[i]);
        }
        return model;
    }

    public ItemModelBuilder item(Item item, ResourceLocation ... texture) {
        return this.item(item, "item/generated", texture);
    }

    public ItemModelBuilder item(Item item, String parent, ResourceLocation ... texture) {
        if (texture.length == 0) {
            return (ItemModelBuilder)this.withExistingParent(item, this.mcLoc(parent)).texture("layer0", "werewolves:item/" + item.getRegistryName().func_110623_a());
        }
        return this.item(item.getRegistryName().func_110623_a(), texture);
    }

    public ItemModelBuilder blockLayer(Block item, ResourceLocation ... texture) {
        if (texture.length == 0) {
            return (ItemModelBuilder)this.withExistingParent(item, this.mcLoc("item/generated")).texture("layer0", "werewolves:block/" + item.getRegistryName().func_110623_a());
        }
        return this.item(item.getRegistryName().func_110623_a(), texture);
    }

    @Nonnull
    public ItemModelBuilder withExistingParent(Item name, ResourceLocation parent) {
        return (ItemModelBuilder)super.withExistingParent(name.getRegistryName().func_110623_a(), parent);
    }

    @Nonnull
    public ItemModelBuilder withExistingParent(Item name, Item parent) {
        return this.withExistingParent(name, parent.getRegistryName());
    }

    @Nonnull
    public ItemModelBuilder withExistingParent(Block name, ResourceLocation parent) {
        return (ItemModelBuilder)super.withExistingParent(name.getRegistryName().func_110623_a(), parent);
    }

    public ItemModelBuilder block(Block name) {
        try {
            return (ItemModelBuilder)super.withExistingParent(name.getRegistryName().func_110623_a(), "werewolves:block/" + name.getRegistryName().func_110623_a());
        }
        catch (IllegalStateException e) {
            return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name.getRegistryName().func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile("werewolves:block/" + name.getRegistryName().func_110623_a()));
        }
    }
}

