/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModLootTables;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.entity.EntityType;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.KilledByPlayer;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class LootTablesGenerator
extends LootTableProvider {
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public LootTablesGenerator(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> new ModBlockLootTables(), (Object)LootParameterSets.field_216267_h), (Object)Pair.of(() -> new ModEntityLootTables(), (Object)LootParameterSets.field_216263_d), (Object)Pair.of(() -> new InjectLootTables(), (Object)LootParameterSets.field_216263_d));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        map.forEach((resourceLocation, lootTable) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)resourceLocation, (LootTable)lootTable));
    }

    private static class InjectLootTables
    implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
        private InjectLootTables() {
        }

        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(ModLootTables.villager, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("liver").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)ModItems.liver).func_216086_a(1).func_212840_b_(RandomChance.func_216004_a((float)0.5f)))));
            consumer.accept(ModLootTables.skeleton, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("bones").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)ModItems.bone).func_216086_a(1).func_212840_b_(RandomChance.func_216004_a((float)0.1f)))));
        }
    }

    private static class ModEntityLootTables
    extends EntityLootTables {
        private ModEntityLootTables() {
        }

        protected void addTables() {
            this.func_218582_a(ModEntities.task_master_werewolf, LootTable.func_216119_b());
            this.func_218582_a(ModEntities.werewolf_survivalist, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("general").func_212840_b_(KilledByPlayer.func_215994_b()).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.bone).func_216086_a(4)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.liver).func_216086_a(1))));
            this.func_218582_a(ModEntities.werewolf_beast, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("general").func_212840_b_(KilledByPlayer.func_215994_b()).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.bone).func_216086_a(4)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.liver).func_216086_a(1))));
            this.func_218582_a(ModEntities.wolf, LootTable.func_216119_b());
            this.func_218582_a(ModEntities.human_werewolf, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("general").func_212840_b_(KilledByPlayer.func_215994_b()).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.bone).func_216086_a(4)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.liver).func_216086_a(1))));
        }

        @Nonnull
        protected Iterable<EntityType<?>> getKnownEntities() {
            return ModEntities.getAllEntities();
        }
    }

    private static class ModBlockLootTables
    extends BlockLootTables {
        private ModBlockLootTables() {
        }

        protected void addTables() {
            this.func_218507_a((Block)ModBlocks.totem_top_werewolves_werewolf, LootTable.func_216119_b());
            this.func_218507_a((Block)ModBlocks.totem_top_werewolves_werewolf_crafted, ModBlockLootTables.func_218546_a((IItemProvider)de.teamlapen.vampirism.core.ModBlocks.totem_top));
            this.func_218492_c((Block)ModBlocks.jacaranda_sapling);
            this.func_218492_c((Block)ModBlocks.magic_sapling);
            this.func_218492_c((Block)ModBlocks.wolfsbane);
            this.func_218492_c(ModBlocks.silver_block);
            this.func_218492_c((Block)ModBlocks.silver_ore);
            this.func_218547_a((Block)ModBlocks.potted_wolfsbane);
            this.func_218492_c((Block)ModBlocks.jacaranda_log);
            this.func_218492_c((Block)ModBlocks.magic_log);
            this.func_218492_c((Block)ModBlocks.stone_altar);
            this.func_218492_c(ModBlocks.magic_planks);
            this.func_218522_a((Block)ModBlocks.jacaranda_leaves, block -> ModBlockLootTables.func_218540_a((Block)block, (Block)ModBlocks.jacaranda_sapling, (float[])DEFAULT_SAPLING_DROP_RATES));
            this.func_218522_a((Block)ModBlocks.magic_leaves, block -> ModBlockLootTables.func_218540_a((Block)block, (Block)ModBlocks.magic_leaves, (float[])DEFAULT_SAPLING_DROP_RATES));
            this.func_218492_c(ModBlocks.stone_altar_fire_bowl);
        }

        @Nonnull
        protected Iterable<Block> getKnownBlocks() {
            return ModBlocks.getAllBlocks();
        }
    }
}

