/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.werewolf;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.IVillageCaptureEntity;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IActionHandlerEntity;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.action.ActionHandlerEntity;
import de.teamlapen.vampirism.entity.goals.AttackVillageGoal;
import de.teamlapen.vampirism.entity.goals.DefendVillageGoal;
import de.teamlapen.vampirism.entity.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.entities.werewolf.WerewolfBaseEntity;
import de.teamlapen.werewolves.entities.werewolf.WerewolfTransformable;
import de.teamlapen.werewolves.player.WerewolfForm;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreakDoorGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.PatrollerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;

public abstract class BasicWerewolfEntity
extends WerewolfBaseEntity
implements WerewolfTransformable,
IEntityActionUser,
IVillageCaptureEntity {
    protected static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(BasicWerewolfEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(BasicWerewolfEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final int MAX_LEVEL = 2;
    private final WerewolfForm werewolfForm;
    private WerewolfTransformable transformed;
    private int transformedDuration;
    private final ActionHandlerEntity<?> entityActionHandler;
    private EntityClassType entityClass;
    private EntityActionTier entityTier;
    @Nullable
    private ICaptureAttributes villageAttributes;
    private boolean attack;

    public BasicWerewolfEntity(EntityType<? extends BasicWerewolfEntity> type, World world, WerewolfForm werewolfForm) {
        super(type, world);
        this.werewolfForm = werewolfForm;
        this.entityClass = EntityClassType.getRandomClass((Random)world.field_73012_v);
        this.entityTier = EntityActionTier.Low;
        this.entityActionHandler = new ActionHandlerEntity((CreatureEntity)this);
    }

    @Nonnull
    public EntitySize func_213305_a(@Nonnull Pose poseIn) {
        return this.werewolfForm.getSize(poseIn).map(p -> p.func_220313_a(this.func_213355_cm())).orElse(super.func_213305_a(poseIn));
    }

    public WerewolfForm getForm() {
        return this.werewolfForm;
    }

    @Override
    public BasicWerewolfEntity _transformToWerewolf() {
        return this;
    }

    @Override
    public WerewolfTransformable _transformBack() {
        if (this.transformed == null) {
            return this;
        }
        WerewolfTransformable.copyData((MobEntity)this.transformed, (MobEntity)this);
        ((MobEntity)this.transformed).revive();
        this.field_70170_p.func_217376_c((Entity)((MobEntity)this.transformed));
        return this.transformed;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityClass;
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entityTier;
    }

    @Override
    public int getEntityTextureType() {
        int i = (Integer)this.func_184212_Q().func_187225_a(TYPE);
        return Math.max(i, 0);
    }

    @Override
    public void start() {
        this.transformedDuration = (Integer)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_transform_duration.get() * 20;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.transformed != null && this.field_70170_p.func_82737_E() % 20L == 0L && --this.transformedDuration <= 0) {
            this.transformBack();
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.handle();
        }
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("level")) {
            this.setLevel(nbt.func_74762_e("level"));
        }
        if (nbt.func_74764_b("type")) {
            int t = nbt.func_74762_e("type");
            this.func_184212_Q().func_187227_b(TYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (nbt.func_74764_b("transformedDuration")) {
            this.transformedDuration = nbt.func_74762_e("transformedDuration");
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.read(nbt);
        }
        if (nbt.func_74764_b("attack")) {
            this.attack = nbt.func_74767_n("attack");
        }
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("transformedDuration", this.transformedDuration);
        if (this.entityActionHandler != null) {
            this.entityActionHandler.write(nbt);
        }
        nbt.func_74768_a("level", this.getLevel());
        nbt.func_74768_a("type", this.getEntityTextureType());
        nbt.func_74757_a("attack", this.attack);
    }

    public IActionHandlerEntity getActionHandler() {
        return this.entityActionHandler;
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        this.transformedDuration = (Integer)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_transform_duration.get() * 20;
        return super.func_70097_a(source, amount);
    }

    public int getLevel() {
        return (Integer)this.func_184212_Q().func_187225_a(LEVEL);
    }

    public void setLevel(int level) {
        if (level >= 0) {
            this.func_184212_Q().func_187227_b(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 2) {
                this.func_195064_c(new EffectInstance(Effects.field_76429_m, 1000000, 1));
            }
            if (level == 1) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151040_l));
            } else {
                this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
            }
        }
    }

    public int getMaxLevel() {
        return 2;
    }

    @Override
    public boolean canTransform() {
        return this.transformed != null;
    }

    public int suggestLevel(Difficulty difficulty) {
        switch (this.field_70146_Z.nextInt(5)) {
            case 0: {
                return (int)((float)difficulty.minPercLevel / 100.0f * 2.0f);
            }
            case 1: {
                return (int)((float)difficulty.avgPercLevel / 100.0f * 2.0f);
            }
            case 2: {
                return (int)((float)difficulty.maxPercLevel / 100.0f * 2.0f);
            }
        }
        return this.field_70146_Z.nextInt(3);
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getLevel(), 0);
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_max_health.get() + (Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_max_health_pl.get() * (double)l);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a((Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_attack_damage.get() + (Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_attack_damage_pl.get() * (double)l);
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(((Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_speed.get()).doubleValue());
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if ((Integer)this.func_184212_Q().func_187225_a(TYPE) == -1) {
            this.func_184212_Q().func_187227_b(TYPE, (Object)this.func_70681_au().nextInt(126));
        }
    }

    public void setSourceEntity(WerewolfTransformable entity) {
        this.entityClass = entity.getEntityClass();
        this.entityTier = entity.getEntityTier();
        this.transformed = entity;
        this.func_184212_Q().func_187227_b(TYPE, (Object)entity.getEntityTextureType());
    }

    public void attackVillage(ICaptureAttributes iCaptureAttributes) {
        this.villageAttributes = iCaptureAttributes;
        this.attack = true;
    }

    @Override
    @Nonnull
    public WerewolfForm getWerewolfForm() {
        return this.werewolfForm;
    }

    public void defendVillage(ICaptureAttributes iCaptureAttributes) {
        this.villageAttributes = iCaptureAttributes;
        this.attack = false;
    }

    @Nullable
    public AxisAlignedBB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    @Nullable
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    public boolean isDefendingVillage() {
        return this.villageAttributes != null && !this.attack;
    }

    public boolean isAttackingVillage() {
        return this.villageAttributes != null && this.attack;
    }

    public void stopVillageAttackDefense() {
        this.villageAttributes = null;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new BreakDoorGoal((MobEntity)this, difficulty -> difficulty == net.minecraft.world.Difficulty.HARD));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(9, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtClosestVisibleGoal((MobEntity)this, PlayerEntity.class, 20.0f, 0.6f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, HunterBaseEntity.class, 17.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new AttackVillageGoal((VampirismEntity)this));
        this.field_70715_bh.func_75776_a(4, (Goal)new DefendVillageGoal((CreatureEntity)this));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, true, null)));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, CreatureEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
        this.field_70715_bh.func_75776_a(7, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PatrollerEntity.class, 5, true, true, living -> UtilLib.isInsideStructure((Entity)living, (Structure)Structure.field_236381_q_)));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(LEVEL, (Object)-1);
        this.func_184212_Q().func_187214_a(TYPE, (Object)-1);
    }

    public static class Survivalist
    extends BasicWerewolfEntity {
        public Survivalist(EntityType<? extends BasicWerewolfEntity> type, World world) {
            super(type, world, WerewolfForm.SURVIVALIST);
        }
    }

    public static class Beast
    extends BasicWerewolfEntity {
        public Beast(EntityType<? extends BasicWerewolfEntity> type, World world) {
            super(type, world, WerewolfForm.BEAST);
        }
    }
}

