/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.werewolf;

import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.effects.LupusSanguinemEffect;
import de.teamlapen.werewolves.entities.IWerewolfMob;
import de.teamlapen.werewolves.util.WReference;
import java.util.Random;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class WerewolfBaseEntity
extends VampirismEntity
implements IWerewolfMob {
    public WerewolfBaseEntity(EntityType<? extends VampirismEntity> type, World world) {
        super(type, world);
    }

    public static boolean spawnPredicateWerewolf(EntityType<? extends WerewolfBaseEntity> entityType, IWorld world, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return world.func_175659_aa() != Difficulty.PEACEFUL && WerewolfBaseEntity.spawnPredicateCanSpawn(entityType, (IWorld)world, (SpawnReason)spawnReason, (BlockPos)blockPos, (Random)random);
    }

    public void bite(LivingEntity entity) {
        LupusSanguinemEffect.addSanguinemEffect(entity);
    }

    public EntityClassification getClassification(boolean forSpawnCount) {
        return super.getClassification(forSpawnCount);
    }

    public IFaction<?> getFaction() {
        return WReference.WEREWOLF_FACTION;
    }

    public LivingEntity getRepresentingEntity() {
        return this;
    }

    public static AttributeModifierMap.MutableAttribute getAttributeBuilder() {
        return VampirismEntity.getAttributeBuilder().func_233815_a_(Attributes.field_233818_a_, ((Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_max_health.get()).doubleValue()).func_233815_a_(Attributes.field_233823_f_, ((Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_attack_damage.get()).doubleValue()).func_233815_a_(Attributes.field_233821_d_, ((Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_speed.get()).doubleValue());
    }
}

