/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.mixin.entity;

import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.entities.werewolf.BasicWerewolfEntity;
import de.teamlapen.werewolves.entities.werewolf.IVillagerTransformable;
import de.teamlapen.werewolves.entities.werewolf.WerewolfTransformable;
import de.teamlapen.werewolves.player.WerewolfForm;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={VillagerEntity.class})
public abstract class MixinVillagerEntity
extends AbstractVillagerEntity
implements IVillagerTransformable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(VillagerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private boolean werewolf;
    private WerewolfForm form;
    private final EntityActionTier entitytier = EntityActionTier.Medium;
    private EntityClassType entityclass;

    @Deprecated
    public MixinVillagerEntity(EntityType<? extends AbstractVillagerEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public BasicWerewolfEntity _transformToWerewolf() {
        Object type = this.form == WerewolfForm.BEAST ? ModEntities.werewolf_beast : ModEntities.werewolf_survivalist;
        BasicWerewolfEntity entity = (BasicWerewolfEntity)WerewolfTransformable.copyData(type, (MobEntity)this);
        entity.setSourceEntity(this);
        return entity;
    }

    @Override
    public WerewolfTransformable _transformBack() {
        return this;
    }

    @Override
    public boolean canTransform() {
        boolean can = this instanceof IVampire || ExtendedCreature.getSafe((Entity)this).map(IExtendedCreatureVampirism::hasPoisonousBlood).orElse(false) != false;
        return !can && this.werewolf;
    }

    @Override
    @Nonnull
    public WerewolfForm getWerewolfForm() {
        return this.form;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityclass == null ? (this.entityclass = EntityClassType.getRandomClass((Random)this.func_70681_au())) : this.entityclass;
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entitytier;
    }

    @Override
    public int getEntityTextureType() {
        int i = (Integer)this.func_184212_Q().func_187225_a(TYPE);
        return Math.max(i, 0);
    }

    @Override
    public void setWerewolfFaction(boolean werewolf) {
        this.werewolf = werewolf;
        this.form = this.func_70681_au().nextBoolean() ? WerewolfForm.SURVIVALIST : WerewolfForm.BEAST;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if ((Integer)this.func_184212_Q().func_187225_a(TYPE) == -1) {
            this.func_184212_Q().func_187227_b(TYPE, (Object)this.func_70681_au().nextInt(126));
        }
    }

    @Inject(method={"registerData"}, at={@At(value="RETURN")})
    protected void registerData(CallbackInfo ci) {
        this.func_184212_Q().func_187214_a(TYPE, (Object)-1);
    }

    @Inject(method={"readAdditional"}, at={@At(value="RETURN")})
    public void writeAdditional(CompoundNBT compound, CallbackInfo ci) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("werewolf", this.werewolf);
        if (this.form != null) {
            nbt.func_74778_a("form", this.form.getName());
        }
        nbt.func_74768_a("type", this.getEntityTextureType());
        if (this.entityclass != null) {
            nbt.func_74768_a("entityclasstype", EntityClassType.getID((EntityClassType)this.entityclass));
        }
        compound.func_218657_a("werewolves", (INBT)nbt);
    }

    @Inject(method={"readAdditional"}, at={@At(value="RETURN")})
    public void readAdditional(CompoundNBT compound, CallbackInfo ci) {
        CompoundNBT nbt = compound.func_74775_l("werewolves");
        this.werewolf = nbt.func_74767_n("werewolf");
        if (compound.func_74764_b("form")) {
            this.form = WerewolfForm.getForm(nbt.func_74779_i("form"));
        }
        if (nbt.func_74764_b("type")) {
            int t = nbt.func_74762_e("type");
            this.func_184212_Q().func_187227_b(TYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (nbt.func_74764_b("entityclasstype")) {
            this.entityclass = EntityClassType.getEntityClassType((int)nbt.func_74762_e("entityclasstype"));
        }
    }
}

