/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.modcompat.guide;

import de.maxanier.guideapi.api.IPage;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.BookHelper;
import de.maxanier.guideapi.api.util.PageHelper;
import de.maxanier.guideapi.category.CategoryItemStack;
import de.maxanier.guideapi.page.PageHolderWithLinks;
import de.maxanier.guideapi.page.PageTextImage;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.modcompat.guide.EntryText;
import de.teamlapen.vampirism.modcompat.guide.GuideBook;
import de.teamlapen.vampirism.modcompat.guide.VampirismGuideBookCategoriesEvent;
import de.teamlapen.vampirism.modcompat.guide.pages.PageTable;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.player.werewolf.WerewolfLevelConf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class WerewolvesGuideBook {
    private static final String IMAGE_BASE = "vampirismguide:textures/images/";

    public static void onVampirismGuideBookCategoriesEvent(VampirismGuideBookCategoriesEvent event) {
        BookHelper helper = new BookHelper.Builder("werewolves").build();
        int werewolfPos = -1;
        int itemPos = -1;
        int blockPos = -1;
        for (int i1 = 0; i1 < event.categories.size(); ++i1) {
            if (werewolfPos == -1 && ((CategoryAbstract)event.categories.get((int)i1)).entries.keySet().stream().findAny().map(t -> t.func_110623_a().contains("guide.vampirism.hunter")).orElse(false).booleanValue()) {
                werewolfPos = i1 + 1;
                continue;
            }
            if (itemPos == -1 && ((CategoryAbstract)event.categories.get((int)i1)).entries.keySet().stream().findAny().map(t -> t.func_110623_a().contains("guide.vampirism.items")).orElse(false).booleanValue()) {
                itemPos = i1 + 1;
                continue;
            }
            if (blockPos != -1 || !((CategoryAbstract)event.categories.get((int)i1)).entries.keySet().stream().findAny().map(t -> t.func_110623_a().contains("guide.vampirism.blocks")).orElse(false).booleanValue()) continue;
            blockPos = i1 + 1;
        }
        if (werewolfPos < 0) {
            werewolfPos = event.categories.size();
        }
        CategoryItemStack category = new CategoryItemStack(WerewolvesGuideBook.buildWerewolf(helper), (ITextComponent)GuideBook.translateComponent((String)"guide.werewolves.entity.werewolf.title", (Object[])new Object[0]), new ItemStack((IItemProvider)ModItems.liver));
        helper.registerLinkablePages(Collections.singletonList(category));
        event.categories.add(werewolfPos, category);
        if (itemPos >= 0) {
            CategoryAbstract items = (CategoryAbstract)event.categories.get(itemPos);
            WerewolvesGuideBook.buildItems(items.entries, helper);
            helper.registerLinkablePages(Collections.singletonList(items));
        }
        if (blockPos >= 0) {
            CategoryAbstract blocks = (CategoryAbstract)event.categories.get(blockPos);
            WerewolvesGuideBook.buildBlocks(blocks.entries, helper);
            helper.registerLinkablePages(Collections.singletonList(blocks));
        }
    }

    private static Map<ResourceLocation, EntryAbstract> buildWerewolf(BookHelper helper) {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.werewolves.werewolf.";
        ArrayList gettingStarted = new ArrayList();
        gettingStarted.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent((String)(base + "getting_started.become"), (Object[])new Object[0])));
        gettingStarted.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent((String)(base + "getting_started.as_werewolf"), (Object[])new Object[0])));
        gettingStarted.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent((String)(base + "getting_started.weakness"), (Object[])new Object[0])));
        gettingStarted.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent((String)(base + "getting_started.skills"), (Object[])new Object[0])));
        entries.put(new ResourceLocation(base + "getting_started"), (EntryAbstract)new EntryText(gettingStarted, (ITextComponent)GuideBook.translateComponent((String)(base + "getting_started"), (Object[])new Object[0])));
        ArrayList<Object> levelingPages = new ArrayList<Object>();
        levelingPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent((String)(base + "leveling.intro"), (Object[])new Object[0])));
        String stone_altar = "\u00a7l" + WerewolvesGuideBook.loc((Block)ModBlocks.stone_altar) + "\u00a7r\n\u00a7o" + GuideBook.translate((String)(base + "leveling.stone.reach"), (Object[])new Object[0]) + "\u00a7r\n";
        stone_altar = stone_altar + GuideBook.translate((String)(base + "leveling.stone.intro"), (Object[])new Object[]{WerewolvesGuideBook.loc(Items.field_151033_d), WerewolvesGuideBook.loc(Items.field_221657_bQ)});
        levelingPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)new StringTextComponent(stone_altar)), new Object[]{new ResourceLocation("guide.werewolves.blocks.stone_altar"), new ResourceLocation("guide.werewolves.blocks.stone_altar_fire_bowl")}));
        levelingPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent((String)(base + "leveling.stone.structure"), (Object[])new Object[]{WerewolvesGuideBook.loc((Block)ModBlocks.stone_altar), WerewolvesGuideBook.loc(ModBlocks.stone_altar_fire_bowl), WerewolvesGuideBook.loc((Block)ModBlocks.stone_altar), WerewolvesGuideBook.loc(ModBlocks.stone_altar_fire_bowl), WerewolvesGuideBook.loc(Items.field_151033_d)})));
        levelingPages.add(new PageTextImage((ITextProperties)GuideBook.translateComponent((String)(base + "leveling.stone.image1"), (Object[])new Object[0]), new ResourceLocation("vampirismguide:textures/images/stone1.png"), false));
        String item = WerewolvesGuideBook.loc(ModItems.liver) + ", " + WerewolvesGuideBook.loc(ModItems.bone);
        levelingPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent((String)(base + "leveling.stone.items"), (Object[])new Object[]{item})), new Object[]{new ResourceLocation("guide.werewolves.items.liver"), new ResourceLocation("guide.werewolves.items.bone")}));
        PageTable.Builder requirementBuilder = new PageTable.Builder(3);
        requirementBuilder.addUnlocLine(new String[]{"text.vampirism.level_short", WerewolvesGuideBook.loc(ModItems.liver), WerewolvesGuideBook.loc(ModItems.bone)});
        for (int i = 2; i <= 14; ++i) {
            requirementBuilder.addLine(new Object[]{i, WerewolfLevelConf.getInstance().getStoneRequirement((int)i).liverAmount, WerewolfLevelConf.getInstance().getStoneRequirement((int)i).bonesAmount});
        }
        requirementBuilder.setHeadline(GuideBook.translateComponent((String)(base + "leveling.stone_req"), (Object[])new Object[0]));
        PageHolderWithLinks requirementTable = new PageHolderWithLinks(helper, (IPage)requirementBuilder.build());
        requirementTable.addLink(new ResourceLocation("guide.werewolves.items.liver"));
        requirementTable.addLink(new ResourceLocation("guide.werewolves.items.bone"));
        levelingPages.add(requirementTable);
        entries.put(new ResourceLocation(base + "leveling"), (EntryAbstract)new EntryText(levelingPages, (ITextComponent)GuideBook.translateComponent((String)(base + "leveling"), (Object[])new Object[0])));
        ArrayList skillPages = new ArrayList();
        skillPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent((String)(base + "skills.text"), (Object[])new Object[]{UtilLib.translate((String)ModKeys.getKeyBinding((ModKeys.KEY)ModKeys.KEY.SKILL).func_197982_m(), (Object[])new Object[0])})));
        skillPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent((String)(base + "skills.decision"), (Object[])new Object[0])));
        entries.put(new ResourceLocation(base + "skills"), (EntryAbstract)new EntryText(skillPages, (ITextComponent)GuideBook.translateComponent((String)(base + "skills"), (Object[])new Object[0])));
        ArrayList werewolfLord = new ArrayList();
        werewolfLord.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent((String)(base + "lord.text"), (Object[])new Object[0])));
        entries.put(new ResourceLocation(base + "lord"), (EntryAbstract)new EntryText(werewolfLord, (ITextComponent)GuideBook.translateComponent((String)(base + "lord"), (Object[])new Object[0])));
        ArrayList unWerewolf = new ArrayList();
        unWerewolf.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent((String)(base + "un_werewolf.text"), (Object[])new Object[]{WerewolvesGuideBook.loc(ModItems.injection_un_werewolf), WerewolvesGuideBook.loc((Block)ModBlocks.med_chair)})), new Object[]{new ResourceLocation("guide.vampirism.items.injection_empty"), new ResourceLocation("guide.vampirism.blocks.item_med_chair")}));
        entries.put(new ResourceLocation(base + "un_werewolf"), (EntryAbstract)new EntryText(unWerewolf, (ITextComponent)GuideBook.translateComponent((String)(base + "un_werewolf"), (Object[])new Object[0])));
        return entries;
    }

    private static void buildItems(Map<ResourceLocation, EntryAbstract> entriesIn, BookHelper helper) {
        LinkedHashMap entries = new LinkedHashMap();
        helper.info(new Item[]{ModItems.liver}).setLinks(new Object[]{new ResourceLocation("guide.werewolves.werewolf.leveling")}).build(entries);
        helper.info(new Item[]{ModItems.bone}).setLinks(new Object[]{new ResourceLocation("guide.werewolves.werewolf.leveling")}).build(entries);
        entriesIn.putAll(entries);
    }

    private static void buildBlocks(Map<ResourceLocation, EntryAbstract> entriesIn, BookHelper helper) {
        LinkedHashMap entries = new LinkedHashMap();
        helper.info(new Block[]{ModBlocks.stone_altar}).setLinks(new Object[]{new ResourceLocation("guide.werewolves.werewolf.leveling")}).recipes(new ResourceLocation[]{new ResourceLocation("werewolves", "stone_altar")}).build(entries);
        helper.info(new Block[]{ModBlocks.stone_altar_fire_bowl}).setLinks(new Object[]{new ResourceLocation("guide.werewolves.werewolf.leveling")}).recipes(new ResourceLocation[]{new ResourceLocation("werewolves", "stone_altar_fire_bowl")}).build(entries);
        entriesIn.putAll(entries);
    }

    private static String loc(Item i) {
        return UtilLib.translate((String)i.func_77658_a(), (Object[])new Object[0]);
    }

    private static String loc(Block i) {
        return UtilLib.translate((String)i.func_149739_a(), (Object[])new Object[0]);
    }
}

