/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.player;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModEffects;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModTags;
import de.teamlapen.werewolves.core.WerewolfActions;
import de.teamlapen.werewolves.core.WerewolfSkills;
import de.teamlapen.werewolves.effects.UnWerewolfEffectInstance;
import de.teamlapen.werewolves.entities.werewolf.WerewolfBaseEntity;
import de.teamlapen.werewolves.player.WerewolfForm;
import de.teamlapen.werewolves.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.REFERENCE;
import de.teamlapen.werewolves.util.WReference;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModPlayerEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final UUID CLAWS = UUID.fromString("70435284-afcd-4470-85c2-d9b36b3d94e8");

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            try {
                event.addCapability(REFERENCE.WEREWOLF_PLAYER_KEY, WerewolfPlayer.createNewCapability((PlayerEntity)event.getObject()));
            }
            catch (Exception e) {
                LOGGER.error("Failed to attach capabilities to player. Player: {}", event.getObject());
                throw e;
            }
        }
    }

    @SubscribeEvent
    public void onFootEaten(LivingEntityUseItemEvent.Start event) {
        if (event.getEntity() instanceof PlayerEntity && Helper.isWerewolf((PlayerEntity)event.getEntity()) && event.getItem().func_222117_E() && !ModTags.Items.RAWMEATS.func_230235_a_((Object)event.getItem().func_77973_b()) && !ModTags.Items.COOKEDMEATS.func_230235_a_((Object)event.getItem().func_77973_b()) && !event.getItem().func_77973_b().func_219967_s().func_221467_c() && !WerewolfPlayer.getOpt((PlayerEntity)event.getEntity()).map(w -> w.getSkillHandler().isSkillEnabled(WerewolfSkills.not_meat)).orElse(false).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onFootEaten(LivingEntityUseItemEvent.Finish event) {
        if (event.getEntity() instanceof PlayerEntity && Helper.isWerewolf((PlayerEntity)event.getEntity()) && event.getItem().func_222117_E() && event.getItem().func_77973_b().func_219967_s().func_221467_c() && ModTags.Items.RAWMEATS.func_230235_a_((Object)event.getItem().func_77973_b())) {
            ((PlayerEntity)event.getEntityLiving()).func_71024_bL().func_221410_a(event.getItem().func_77973_b(), event.getItem());
        }
    }

    @SubscribeEvent
    public void onHealing(LivingHealEvent event) {
    }

    @SubscribeEvent
    public void onKilled(LivingDeathEvent event) {
        WerewolfPlayer player;
        if (event.getSource() instanceof EntityDamageSource && event.getSource().func_76346_g() instanceof PlayerEntity && Helper.isWerewolf((PlayerEntity)event.getSource().func_76346_g()) && (player = WerewolfPlayer.get((PlayerEntity)event.getSource().func_76346_g())).getSkillHandler().isSkillEnabled(WerewolfSkills.health_after_kill)) {
            ((PlayerEntity)event.getSource().func_76346_g()).func_195064_c(new EffectInstance(Effects.field_76428_l, 4, 10));
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && Helper.isWerewolf((PlayerEntity)event.getEntityLiving())) {
            WerewolfPlayer werewolf = WerewolfPlayer.get((PlayerEntity)event.getEntity());
            if (werewolf.getSkillHandler().isSkillEnabled(WerewolfSkills.wolf_pawn)) {
                event.setDistance(event.getDistance() * 0.8f);
                event.setDamageMultiplier(event.getDamageMultiplier() * 0.8f);
            }
            if (werewolf.getSpecialAttributes().leap) {
                werewolf.getActionHandler().toggleAction((IAction)WerewolfActions.leap);
            }
        }
    }

    @SubscribeEvent
    public void onEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getEntity() instanceof PlayerEntity && Helper.isWerewolf((PlayerEntity)event.getEntity()) && WerewolfPlayer.get((PlayerEntity)event.getEntity()).getForm().isTransformed()) {
            if (event.getTo().func_190926_b()) {
                if (((PlayerEntity)event.getEntity()).func_110148_a(Attributes.field_233823_f_).func_111127_a(CLAWS) == null) {
                    // empty if block
                }
            } else {
                ((PlayerEntity)event.getEntity()).func_110148_a(Attributes.field_233823_f_).func_188479_b(CLAWS);
            }
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntity() instanceof PlayerEntity && Helper.isWerewolf((PlayerEntity)event.getEntity())) {
            WerewolfPlayer werewolf = WerewolfPlayer.get((PlayerEntity)event.getEntity());
            if (werewolf.getSkillHandler().isSkillEnabled(WerewolfSkills.wolf_pawn)) {
                Vector3d motion = event.getEntity().func_213322_ci().func_216372_d(1.1, 1.2, 1.1);
                event.getEntity().func_213317_d(motion);
            }
            if (werewolf.getActionHandler().isActionActive((ILastingAction)WerewolfActions.leap)) {
                if (werewolf.getSpecialAttributes().leap) {
                    werewolf.getActionHandler().toggleAction((IAction)WerewolfActions.leap);
                } else {
                    werewolf.getSpecialAttributes().leap = true;
                }
            } else {
                werewolf.getSpecialAttributes().leap = false;
            }
        }
    }

    @SubscribeEvent
    public void onWakeUp(PlayerWakeUpEvent event) {
        if (event.getPlayer().func_70660_b((Effect)ModEffects.lupus_sanguinem) != null) {
            event.getPlayer().func_70660_b((Effect)ModEffects.lupus_sanguinem).func_76457_b((LivingEntity)event.getPlayer());
            event.getPlayer().func_195063_d((Effect)ModEffects.lupus_sanguinem);
        }
    }

    @SubscribeEvent
    public void onItemUseEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getPlayer().func_184586_b(event.getHand()).func_77973_b() == ModItems.injection_empty && event.getTarget() instanceof WerewolfBaseEntity) {
            event.getPlayer().func_184586_b(event.getHand()).func_190918_g(1);
            event.getPlayer().func_191521_c(new ItemStack((IItemProvider)ModItems.injection_un_werewolf));
        }
    }

    @SubscribeEvent
    public void onItemUseBlock(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        if (player.func_184586_b(event.getHand()).func_77973_b() == ModItems.injection_un_werewolf) {
            if (event.getWorld().func_180495_p(event.getPos()).func_177230_c() == ModBlocks.med_chair) {
                ItemStack stack = player.func_184586_b(event.getHand());
                if (player.func_70089_S()) {
                    FactionPlayerHandler handler = FactionPlayerHandler.get((PlayerEntity)event.getPlayer());
                    IPlayableFaction faction = handler.getCurrentFaction();
                    boolean used = false;
                    if (WReference.WEREWOLF_FACTION.equals((Object)faction)) {
                        if (player.func_70660_b((Effect)ModEffects.un_werewolf) == null) {
                            player.func_195064_c((EffectInstance)new UnWerewolfEffectInstance(2000));
                            used = true;
                        } else {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.injection.in_use"), true);
                        }
                    } else if (faction != null) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.injection.not_use"), true);
                    }
                    if (used) {
                        stack.func_190918_g(1);
                        if (stack.func_190926_b()) {
                            player.field_71071_by.func_184437_d(stack);
                        }
                    }
                }
            }
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerSize(EntityEvent.Size event) {
        LazyOptional<WerewolfPlayer> werewolf;
        Optional size;
        if (event.getEntity() instanceof PlayerEntity && ((PlayerEntity)event.getEntity()).field_71071_by != null && (size = (werewolf = WerewolfPlayer.getOpt((PlayerEntity)event.getEntity())).map(WerewolfPlayer::getForm).flatMap(form -> form.getSize(event.getPose()))).isPresent()) {
            event.setNewSize((EntitySize)size.get());
            event.setNewEyeHeight(((EntitySize)size.get()).field_220316_b * 0.85f);
        }
    }

    @SubscribeEvent
    public void onPlayerAttacked(LivingAttackEvent event) {
        if (event.getEntity() instanceof PlayerEntity && Helper.isWerewolf((PlayerEntity)event.getEntity())) {
            if (event.getEntity().func_70051_ag() && event.getSource() instanceof EntityDamageSource) {
                if (WerewolfPlayer.getOpt((PlayerEntity)event.getEntity()).filter(w -> w.getForm() == WerewolfForm.SURVIVALIST).map(w -> w.getSkillHandler().isSkillEnabled(WerewolfSkills.movement_tactics)).orElse(false).booleanValue() && (double)((PlayerEntity)event.getEntity()).func_70681_au().nextFloat() < 0.35) {
                    event.setCanceled(true);
                }
            } else if ((event.getSource() == DamageSource.field_220302_v || event.getSource() == DamageSource.field_76367_g || event.getSource() == DamageSource.field_190095_e) && WerewolfPlayer.getOpt((PlayerEntity)event.getEntity()).filter(w -> w.getForm().isTransformed()).map(w -> w.getSkillHandler().isSkillEnabled(WerewolfSkills.wolf_pawn)).orElse(false).booleanValue()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onCriticalHit(CriticalHitEvent event) {
        LazyOptional<WerewolfPlayer> wOpt;
        if (Helper.isWerewolf(event.getPlayer()) && event.getTarget() instanceof LivingEntity && (wOpt = WerewolfPlayer.getOpt(event.getPlayer())).filter(w -> w.getForm() == WerewolfForm.BEAST).map(w -> w.getSkillHandler().isSkillEnabled(WerewolfSkills.throat_seeker) && !UtilLib.canReallySee((LivingEntity)((LivingEntity)event.getTarget()), (LivingEntity)event.getPlayer(), (boolean)true)).orElse(false).booleanValue() && (double)(((LivingEntity)event.getTarget()).func_110143_aJ() / ((LivingEntity)event.getTarget()).func_110138_aP()) < 0.25 && event.getPlayer().func_70681_au().nextInt(4) < 1) {
            event.setDamageModifier(10000.0f);
            event.setResult(Event.Result.ALLOW);
        }
    }
}

