/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.player.werewolf;

import de.teamlapen.werewolves.player.werewolf.WerewolfLevelConf;
import de.teamlapen.werewolves.player.werewolf.WerewolfPlayer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class LevelHandler {
    private final WerewolfPlayer player;
    private int levelProgress;

    public LevelHandler(WerewolfPlayer player) {
        this.player = player;
    }

    public boolean canLevelUp() {
        return this.player.getLevel() != this.player.getMaxLevel() && this.levelProgress >= WerewolfLevelConf.getInstance().getRequirement((int)(this.player.getLevel() + 1)).xpAmount;
    }

    public float getLevelPerc() {
        return this.player.getLevel() == this.player.getMaxLevel() ? 1.0f : (float)this.levelProgress / (float)WerewolfLevelConf.getInstance().getRequirement((int)(this.player.getLevel() + 1)).xpAmount;
    }

    public void saveToNbt(@Nonnull CompoundNBT compound) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("progress", this.levelProgress);
        compound.func_218657_a("level", (INBT)nbt);
    }

    public void loadFromNbt(@Nonnull CompoundNBT compound) {
        this.levelProgress = compound.func_74775_l("level").func_74762_e("progress");
    }

    public void clear() {
        if (this.player.getLevel() != this.player.getMaxLevel()) {
            return;
        }
        this.levelProgress = Math.max(0, this.levelProgress - WerewolfLevelConf.getInstance().getRequirement((int)(this.player.getLevel() + 1)).xpAmount);
    }
}

