/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.player.werewolf;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.player.LevelAttributeModifier;
import de.teamlapen.vampirism.player.VampirismPlayer;
import de.teamlapen.vampirism.player.actions.ActionHandler;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import de.teamlapen.vampirism.util.ScoreboardUtil;
import de.teamlapen.vampirism.util.SharedMonsterAttributes;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.core.ModEffects;
import de.teamlapen.werewolves.core.WerewolfSkills;
import de.teamlapen.werewolves.effects.WerewolfNightVisionEffect;
import de.teamlapen.werewolves.mixin.FoodStatsAccessor;
import de.teamlapen.werewolves.player.IWerewolfPlayer;
import de.teamlapen.werewolves.player.WerewolfForm;
import de.teamlapen.werewolves.player.werewolf.LevelHandler;
import de.teamlapen.werewolves.player.werewolf.WerewolfPlayerDefaultImpl;
import de.teamlapen.werewolves.player.werewolf.WerewolfPlayerSpecialAttributes;
import de.teamlapen.werewolves.player.werewolf.actions.WerewolfFormAction;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.NBTHelper;
import de.teamlapen.werewolves.util.REFERENCE;
import de.teamlapen.werewolves.util.WReference;
import de.teamlapen.werewolves.util.WUtils;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.FoodStats;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WerewolfPlayer
extends VampirismPlayer<IWerewolfPlayer>
implements IWerewolfPlayer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final UUID ARMOR_TOUGHNESS = UUID.fromString("f3979aec-b8ef-4e95-84a7-2c6dab8ea46e");
    @CapabilityInject(value=IWerewolfPlayer.class)
    public static Capability<IWerewolfPlayer> CAP = (Capability)UtilLib.getNull();
    @Nonnull
    private final ActionHandler<IWerewolfPlayer> actionHandler;
    @Nonnull
    private final SkillHandler<IWerewolfPlayer> skillHandler;
    @Nonnull
    private final WerewolfPlayerSpecialAttributes specialAttributes = new WerewolfPlayerSpecialAttributes();
    @Nonnull
    private final NonNullList<ItemStack> armorItems = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    @Nonnull
    private WerewolfForm form = WerewolfForm.NONE;
    @Nullable
    private WerewolfFormAction lastFormAction;
    @Nonnull
    private final LevelHandler levelHandler = new LevelHandler(this);

    private void applyEntityAttributes() {
        try {
            this.player.func_110148_a(ModAttributes.bite_damage);
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        this.player.func_110148_a(ModAttributes.time_regain).func_111128_a(1.0);
    }

    public static WerewolfPlayer get(@Nonnull PlayerEntity playerEntity) {
        return (WerewolfPlayer)playerEntity.getCapability(CAP).orElseThrow(() -> new IllegalStateException("Cannot get werewolf player capability from player" + playerEntity));
    }

    public static LazyOptional<WerewolfPlayer> getOpt(@Nonnull PlayerEntity playerEntity) {
        LazyOptional opt = playerEntity.getCapability(CAP).cast();
        if (!opt.isPresent()) {
            LOGGER.warn("Cannot get Werewolf player capability. This might break mod functionality.", new Throwable().fillInStackTrace());
        }
        return opt;
    }

    public WerewolfPlayer(@Nonnull PlayerEntity player) {
        super(player);
        this.actionHandler = new ActionHandler((IFactionPlayer)this);
        this.skillHandler = new SkillHandler((IFactionPlayer)this, WReference.WEREWOLF_FACTION);
    }

    @Nonnull
    public WerewolfForm getForm() {
        return this.form;
    }

    public void setForm(WerewolfFormAction action, WerewolfForm form) {
        this.switchForm(form);
        this.lastFormAction = action;
        if (!this.player.field_70170_p.field_72995_K) {
            this.sync(NBTHelper.nbtWith(nbt -> nbt.func_74778_a("form", this.form.getName())), true);
        }
    }

    public void switchForm(WerewolfForm form) {
        this.form = form;
        this.player.func_213323_x_();
    }

    protected VampirismPlayer<IWerewolfPlayer> copyFromPlayer(PlayerEntity playerEntity) {
        WerewolfPlayer oldWerewolf = WerewolfPlayer.get(playerEntity);
        CompoundNBT nbt = new CompoundNBT();
        oldWerewolf.saveData(nbt);
        this.loadData(nbt);
        return oldWerewolf;
    }

    public void onChangedDimension(RegistryKey<World> registryKey, RegistryKey<World> registryKey1) {
    }

    @Nonnull
    public WerewolfPlayerSpecialAttributes getSpecialAttributes() {
        return this.specialAttributes;
    }

    public void onUpdate() {
        this.player.func_130014_f_().func_217381_Z().func_76320_a("werewolves_werewolfplayer");
        if (!this.isRemote()) {
            if (this.getLevel() > 0) {
                boolean sync = false;
                boolean syncToAll = false;
                CompoundNBT syncPacket = new CompoundNBT();
                if (this.player.field_70170_p.func_82737_E() % 10L == 0L && this.specialAttributes.werewolfTime > 0L && !Helper.isFormActionActive(this)) {
                    this.specialAttributes.werewolfTime = (long)((double)this.specialAttributes.werewolfTime - 10.0 * this.player.func_110148_a(ModAttributes.time_regain).func_111126_e());
                    --this.specialAttributes.werewolfTime;
                    sync = true;
                    syncPacket.func_74772_a("werewolfTime", this.specialAttributes.werewolfTime);
                }
                if (this.actionHandler.updateActions()) {
                    sync = true;
                    syncToAll = true;
                    this.actionHandler.writeUpdateForClient(syncPacket);
                }
                if (this.skillHandler.isDirty()) {
                    sync = true;
                    this.skillHandler.writeUpdateForClient(syncPacket);
                }
                if (this.player.field_70170_p.func_82737_E() % 20L == 0L) {
                    if (Helper.isFullMoon(this.getRepresentingPlayer().func_130014_f_()) && !Helper.isFormActionActive(this) && !this.skillHandler.isSkillEnabled(WerewolfSkills.free_will)) {
                        Optional<WerewolfFormAction> action = this.lastFormAction != null ? Optional.of(this.lastFormAction) : WerewolfFormAction.getAllAction().stream().filter(arg_0 -> this.actionHandler.isActionUnlocked(arg_0)).findAny();
                        action.ifPresent(arg_0 -> this.actionHandler.toggleAction(arg_0));
                    }
                    if (this.form.isTransformed() && this.player.func_70090_H() && !this.skillHandler.isSkillEnabled(WerewolfSkills.water_lover)) {
                        this.player.func_195064_c(new EffectInstance(Effects.field_76437_t, 21, 0, true, true));
                    }
                }
                if (this.skillHandler.isSkillEnabled(WerewolfSkills.health_reg)) {
                    this.tickFoodStats();
                }
                if (sync) {
                    this.sync(syncPacket, syncToAll);
                }
            }
        } else if (this.getLevel() > 0) {
            if (this.player.field_70170_p.func_82737_E() % 10L == 0L && this.specialAttributes.werewolfTime > 0L && !Helper.isFormActionActive(this)) {
                this.specialAttributes.werewolfTime = (long)((double)this.specialAttributes.werewolfTime - 10.0 * this.player.func_110148_a(ModAttributes.time_regain).func_111126_e());
            }
            this.actionHandler.updateActions();
        }
        EffectInstance effect = this.player.func_70660_b(Effects.field_76439_r);
        if (this.getForm().isTransformed() && this.specialAttributes.night_vision) {
            if (!(effect instanceof WerewolfNightVisionEffect)) {
                this.player.func_184596_c(Effects.field_76439_r);
                effect = null;
            }
            if (effect == null) {
                this.player.func_195064_c((EffectInstance)new WerewolfNightVisionEffect());
            }
        } else if (effect instanceof WerewolfNightVisionEffect) {
            this.player.func_184596_c(Effects.field_76439_r);
        }
        this.specialAttributes.biteTicks = Math.max(0, this.specialAttributes.biteTicks - 1);
        this.player.func_130014_f_().func_217381_Z().func_76319_b();
    }

    private void tickFoodStats() {
        Difficulty difficulty = this.player.field_70170_p.func_175659_aa();
        boolean flag = this.player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223606_i);
        FoodStats stats = this.player.func_71024_bL();
        if (flag && stats.func_75115_e() > 0.0f && this.player.func_70996_bM() && stats.func_75116_a() >= 20) {
            if (((FoodStatsAccessor)stats).getFoodTimer() >= 9) {
                float f = Math.min(stats.func_75115_e(), 6.0f);
                this.player.func_70691_i(f / 6.0f);
                stats.func_75113_a(f);
            }
        } else if (flag && stats.func_75116_a() >= 18 && this.player.func_70996_bM()) {
            if (((FoodStatsAccessor)stats).getFoodTimer() >= 79) {
                this.player.func_70691_i(1.0f);
                stats.func_75113_a(6.0f);
            }
        } else if (stats.func_75116_a() <= 0 && ((FoodStatsAccessor)stats).getFoodTimer() >= 79 && (this.player.func_110143_aJ() > 10.0f || difficulty == Difficulty.HARD || this.player.func_110143_aJ() > 1.0f && difficulty == Difficulty.NORMAL)) {
            this.player.func_70097_a(DamageSource.field_76366_f, 1.0f);
        }
    }

    public void onDeath(DamageSource damageSource) {
        this.actionHandler.deactivateAllActions();
    }

    @Nonnull
    public LevelHandler getLevelHandler() {
        return this.levelHandler;
    }

    public boolean onEntityAttacked(DamageSource damageSource, float v) {
        return false;
    }

    public void onJoinWorld() {
        if (this.getLevel() > 0) {
            this.actionHandler.onActionsReactivated();
        }
    }

    public void onPlayerLoggedIn() {
    }

    public void onPlayerLoggedOut() {
    }

    public void onUpdatePlayer(TickEvent.Phase phase) {
    }

    public boolean canBiteEntity(LivingEntity entity) {
        return (double)entity.func_70032_d((Entity)this.player) <= this.player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() + 1.0;
    }

    public boolean canBite() {
        return this.form.isTransformed() && !this.player.func_175149_v() && this.getLevel() > 0 && this.specialAttributes.biteTicks <= 0;
    }

    public boolean bite(int entityId) {
        Entity entity = this.player.field_70170_p.func_73045_a(entityId);
        if (entity instanceof LivingEntity) {
            return this.bite((LivingEntity)entity);
        }
        return false;
    }

    private boolean bite(LivingEntity entity) {
        if (this.specialAttributes.biteTicks > 0) {
            return false;
        }
        if (!this.form.isTransformed()) {
            return false;
        }
        if ((double)entity.func_70032_d((Entity)this.player) > this.player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() + 1.0) {
            return false;
        }
        double damage = this.player.func_110148_a(ModAttributes.bite_damage).func_111126_e() + this.player.func_110148_a(Attributes.field_233823_f_).func_111126_e();
        boolean flag = entity.func_70097_a((DamageSource)Helper.causeWerewolfDamage(this.player), (float)damage);
        if (flag) {
            this.eatEntity(entity);
            this.specialAttributes.biteTicks = 100;
            if (this.skillHandler.isSkillEnabled(WerewolfSkills.stun_bite)) {
                entity.func_195064_c(new EffectInstance(ModEffects.freeze, ((Integer)WerewolvesConfig.BALANCE.SKILLS.stun_bite_duration.get()).intValue()));
            } else if (this.skillHandler.isSkillEnabled(WerewolfSkills.bleeding_bite)) {
                entity.func_195064_c(new EffectInstance((Effect)ModEffects.bleeding, ((Integer)WerewolvesConfig.BALANCE.SKILLS.bleeding_bite_duration.get()).intValue()));
            }
            this.sync(NBTHelper.nbtWith(nbt -> nbt.func_74768_a("biteTicks", this.specialAttributes.biteTicks)), false);
        }
        return flag;
    }

    private void eatEntity(LivingEntity entity) {
        if (entity.func_70662_br()) {
            return;
        }
        if (!entity.func_70089_S() && entity.func_200600_R().func_220339_d().func_82705_e()) {
            this.player.func_71024_bL().func_75122_a(1, 1.0f);
        }
    }

    public void onLevelChanged(int newLevel, int oldLevel) {
        this.applyEntityAttributes();
        if (!this.isRemote()) {
            ScoreboardUtil.updateScoreboard((PlayerEntity)this.player, (ScoreCriteria)WUtils.WEREWOLF_LEVEL_CRITERIA, (int)newLevel);
            LevelAttributeModifier.applyModifier((PlayerEntity)this.player, (Attribute)SharedMonsterAttributes.MOVEMENT_SPEED, (String)"Werewolf", (int)this.getLevel(), (int)this.getMaxLevel(), (double)((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_speed_amount.get()), (double)0.3, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL, (boolean)false);
            LevelAttributeModifier.applyModifier((PlayerEntity)this.player, (Attribute)SharedMonsterAttributes.ARMOR_TOUGHNESS, (String)"Werewolf", (int)this.getLevel(), (int)this.getMaxLevel(), (double)((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_speed_amount.get()), (double)0.5, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL, (boolean)false);
            LevelAttributeModifier.applyModifier((PlayerEntity)this.player, (Attribute)SharedMonsterAttributes.ATTACK_DAMAGE, (String)"Werewolf", (int)this.getLevel(), (int)this.getMaxLevel(), (double)((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_damage.get()), (double)0.5, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION, (boolean)false);
            if (newLevel > 0) {
                if (oldLevel == 0) {
                    this.skillHandler.enableRootSkill();
                    this.specialAttributes.werewolfTime = 0L;
                }
            } else {
                this.actionHandler.resetTimers();
                this.skillHandler.disableAllSkills();
            }
        } else if (newLevel == 0) {
            this.actionHandler.resetTimers();
        }
    }

    @Nonnull
    public NonNullList<ItemStack> getArmorItems() {
        return this.armorItems;
    }

    private void eatFleshFrom(LivingEntity entity) {
        this.player.func_71024_bL().func_75122_a(1, 1.0f);
    }

    public ResourceLocation getCapKey() {
        return REFERENCE.WEREWOLF_PLAYER_KEY;
    }

    public boolean canLeaveFaction() {
        return true;
    }

    @Nullable
    public IFaction<?> getDisguisedAs() {
        if (this.getForm().isTransformed()) {
            return WReference.WEREWOLF_FACTION;
        }
        return null;
    }

    public IPlayableFaction<IWerewolfPlayer> getFaction() {
        return WReference.WEREWOLF_FACTION;
    }

    public int getMaxLevel() {
        return 14;
    }

    public Predicate<LivingEntity> getNonFriendlySelector(boolean otherFactionPlayers, boolean ignoreDisguise) {
        if (otherFactionPlayers) {
            return entity -> true;
        }
        return VampirismAPI.factionRegistry().getPredicate(this.getFaction(), ignoreDisguise);
    }

    public void storeArmor() {
        if (!this.skillHandler.isSkillEnabled(WerewolfSkills.wear_armor)) {
            for (int i = 0; i < this.player.field_71071_by.field_70460_b.size(); ++i) {
                this.armorItems.set(i, (Object)((ItemStack)this.player.field_71071_by.field_70460_b.get(i)));
                this.player.field_71071_by.field_70460_b.set(i, (Object)ItemStack.field_190927_a);
            }
            this.sync(this.saveArmorItems(new CompoundNBT()), false);
        }
    }

    public void loadArmor() {
        for (int i = 0; i < this.armorItems.size() - 1; ++i) {
            ItemStack stack = (ItemStack)this.armorItems.get(i);
            if (stack.func_190926_b()) continue;
            this.player.field_71071_by.field_70460_b.set(i, (Object)stack);
            this.armorItems.set(i, (Object)ItemStack.field_190927_a);
        }
        this.sync(this.saveArmorItems(new CompoundNBT()), false);
    }

    public boolean isDisguised() {
        return !this.getForm().isTransformed();
    }

    public ISkillHandler<IWerewolfPlayer> getSkillHandler() {
        return this.skillHandler;
    }

    public IActionHandler<IWerewolfPlayer> getActionHandler() {
        return this.actionHandler;
    }

    public CompoundNBT saveArmorItems(CompoundNBT nbt) {
        CompoundNBT armor = new CompoundNBT();
        for (int i = 0; i < this.armorItems.size(); ++i) {
            armor.func_218657_a("" + i, (INBT)((ItemStack)this.armorItems.get(i)).serializeNBT());
        }
        nbt.func_218657_a("armor", (INBT)armor);
        return nbt;
    }

    public void saveData(CompoundNBT compound) {
        this.actionHandler.saveToNbt(compound);
        this.skillHandler.saveToNbt(compound);
        this.levelHandler.saveToNbt(compound);
        this.saveArmorItems(compound);
        compound.func_74772_a("werewolfTime", this.specialAttributes.werewolfTime);
        compound.func_74778_a("form", this.form.getName());
        if (this.lastFormAction != null) {
            compound.func_74778_a("lastFormAction", this.lastFormAction.getRegistryName().toString());
        }
        compound.func_74768_a("biteTicks", this.specialAttributes.biteTicks);
    }

    public void loadData(CompoundNBT compound) {
        this.actionHandler.loadFromNbt(compound);
        this.skillHandler.loadFromNbt(compound);
        this.levelHandler.loadFromNbt(compound);
        CompoundNBT armor = compound.func_74775_l("armor");
        for (int i = 0; i < armor.func_186856_d(); ++i) {
            try {
                this.armorItems.set(i, (Object)ItemStack.func_199557_a((CompoundNBT)armor.func_74775_l("" + i)));
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (NBTHelper.containsLong(compound, "werewolfTime")) {
            this.specialAttributes.werewolfTime = compound.func_74763_f("werewolfTime");
        }
        if (NBTHelper.containsString(compound, "form")) {
            this.switchForm(WerewolfForm.getForm(compound.func_74779_i("form")));
        }
        if (NBTHelper.containsString(compound, "lastFormAction")) {
            this.lastFormAction = (WerewolfFormAction)ModRegistries.ACTIONS.getValue(new ResourceLocation(compound.func_74779_i("lastFormAction")));
        }
        this.specialAttributes.biteTicks = compound.func_74762_e("biteTicks");
    }

    protected void writeFullUpdate(CompoundNBT nbt) {
        this.actionHandler.writeUpdateForClient(nbt);
        this.skillHandler.writeUpdateForClient(nbt);
        this.levelHandler.saveToNbt(nbt);
        this.saveArmorItems(nbt);
        nbt.func_74772_a("werewolfTime", this.specialAttributes.werewolfTime);
        nbt.func_74778_a("form", this.form.getName());
        nbt.func_74768_a("biteTicks", this.specialAttributes.biteTicks);
    }

    protected void loadUpdate(CompoundNBT nbt) {
        this.actionHandler.readUpdateFromServer(nbt);
        this.skillHandler.readUpdateFromServer(nbt);
        this.levelHandler.loadFromNbt(nbt);
        CompoundNBT armor = nbt.func_74775_l("armor");
        for (int i = 0; i < armor.func_186856_d(); ++i) {
            this.armorItems.set(i, (Object)ItemStack.func_199557_a((CompoundNBT)armor.func_74775_l("" + i)));
        }
        if (NBTHelper.containsLong(nbt, "werewolfTime")) {
            this.specialAttributes.werewolfTime = nbt.func_74763_f("werewolfTime");
        }
        if (NBTHelper.containsString(nbt, "form")) {
            this.switchForm(WerewolfForm.getForm(nbt.func_74779_i("form")));
        }
        this.specialAttributes.biteTicks = nbt.func_74762_e("biteTicks");
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(IWerewolfPlayer.class, (Capability.IStorage)new Storage(), WerewolfPlayerDefaultImpl::new);
    }

    public static ICapabilityProvider createNewCapability(final PlayerEntity playerEntity) {
        return new ICapabilitySerializable<CompoundNBT>(){
            final IWerewolfPlayer inst;
            final LazyOptional<IWerewolfPlayer> opt;
            {
                this.inst = new WerewolfPlayer(playerEntity);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CAP.orEmpty(cap, this.opt);
            }

            public CompoundNBT serializeNBT() {
                return (CompoundNBT)CAP.getStorage().writeNBT(CAP, (Object)this.inst, null);
            }

            public void deserializeNBT(CompoundNBT nbt) {
                CAP.getStorage().readNBT(CAP, (Object)this.inst, null, (INBT)nbt);
            }
        };
    }

    static {
        LevelAttributeModifier.registerModdedAttributeModifier((Attribute)Attributes.field_233827_j_, (UUID)ARMOR_TOUGHNESS);
    }

    private static class Storage
    implements Capability.IStorage<IWerewolfPlayer> {
        private Storage() {
        }

        @Nullable
        public INBT writeNBT(Capability<IWerewolfPlayer> capability, IWerewolfPlayer instance, Direction side) {
            CompoundNBT compound = new CompoundNBT();
            ((WerewolfPlayer)instance).saveData(compound);
            return compound;
        }

        public void readNBT(Capability<IWerewolfPlayer> capability, IWerewolfPlayer instance, Direction side, INBT compound) {
            ((WerewolfPlayer)instance).loadData((CompoundNBT)compound);
        }
    }
}

