/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.player.werewolf.actions;

import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModBiomes;
import de.teamlapen.werewolves.core.WerewolfActions;
import de.teamlapen.werewolves.core.WerewolfSkills;
import de.teamlapen.werewolves.player.IWerewolfPlayer;
import de.teamlapen.werewolves.player.WerewolfForm;
import de.teamlapen.werewolves.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.player.werewolf.actions.DefaultWerewolfAction;
import de.teamlapen.werewolves.util.Helper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.biome.Biome;

public abstract class WerewolfFormAction
extends DefaultWerewolfAction
implements ILastingAction<IWerewolfPlayer> {
    private static final Set<WerewolfFormAction> ALL_ACTION = new HashSet<WerewolfFormAction>();
    protected final List<Modifier> attributes = new ArrayList<Modifier>();
    @Nonnull
    private final WerewolfForm form;

    public static boolean isWerewolfFormActionActive(IActionHandler<IWerewolfPlayer> handler) {
        return ALL_ACTION.stream().anyMatch(arg_0 -> handler.isActionActive(arg_0));
    }

    public static Set<WerewolfFormAction> getAllAction() {
        return Collections.unmodifiableSet(ALL_ACTION);
    }

    public static float getDurationPercentage(IWerewolfPlayer player) {
        long durationMax = (Long)WerewolvesConfig.BALANCE.SKILLS.werewolf_form_time_limit.get() * 20L;
        return 1.0f - (float)((WerewolfPlayer)player).getSpecialAttributes().werewolfTime / (float)durationMax;
    }

    public WerewolfFormAction(@Nonnull WerewolfForm form) {
        ALL_ACTION.add(this);
        this.form = form;
    }

    protected boolean activate(IWerewolfPlayer werewolfPlayer) {
        ((WerewolfPlayer)werewolfPlayer).setForm(this, this.form);
        if (!werewolfPlayer.getSkillHandler().isSkillEnabled(WerewolfSkills.wear_armor) || this.form != WerewolfForm.HUMAN) {
            ((WerewolfPlayer)werewolfPlayer).storeArmor();
        }
        this.applyModifier(werewolfPlayer);
        werewolfPlayer.getRepresentingPlayer().refreshDisplayName();
        return true;
    }

    public void onActivatedClient(IWerewolfPlayer werewolfPlayer) {
        ((WerewolfPlayer)werewolfPlayer).switchForm(this.form);
        if (!werewolfPlayer.getSkillHandler().isSkillEnabled(WerewolfSkills.wear_armor) || this.form != WerewolfForm.HUMAN) {
            ((WerewolfPlayer)werewolfPlayer).storeArmor();
        }
        werewolfPlayer.getRepresentingPlayer().refreshDisplayName();
    }

    public void onDeactivated(IWerewolfPlayer werewolfPlayer) {
        ((WerewolfPlayer)werewolfPlayer).setForm(this, WerewolfForm.NONE);
        ((WerewolfPlayer)werewolfPlayer).loadArmor();
        this.removeModifier(werewolfPlayer);
        werewolfPlayer.getRepresentingPlayer().refreshDisplayName();
        if (werewolfPlayer.getActionHandler().isActionActive((ILastingAction)WerewolfActions.hide_name)) {
            werewolfPlayer.getActionHandler().toggleAction((IAction)WerewolfActions.hide_name);
        }
    }

    public void onReActivated(IWerewolfPlayer werewolfPlayer) {
        if (!werewolfPlayer.getSkillHandler().isSkillEnabled(WerewolfSkills.wear_armor) || this.form != WerewolfForm.HUMAN) {
            ((WerewolfPlayer)werewolfPlayer).storeArmor();
        }
        werewolfPlayer.getRepresentingPlayer().refreshDisplayName();
    }

    public boolean onUpdate(IWerewolfPlayer werewolfPlayer) {
        if (!werewolfPlayer.getRepresentingPlayer().func_130014_f_().field_72995_K) {
            this.checkDayNightModifier(werewolfPlayer);
        }
        if (Helper.isNight(werewolfPlayer.getRepresentingPlayer().func_130014_f_())) {
            return false;
        }
        Biome biome = werewolfPlayer.getRepresentingPlayer().func_130014_f_().func_226691_t_(werewolfPlayer.getRepresentingPlayer().func_233580_cy_());
        if (Objects.equals(biome.getRegistryName(), ModBiomes.WEREWOLF_HEAVEN_KEY.func_240901_a_())) {
            return false;
        }
        return ++((WerewolfPlayer)werewolfPlayer).getSpecialAttributes().werewolfTime > (Long)WerewolvesConfig.BALANCE.SKILLS.werewolf_form_time_limit.get() * 20L;
    }

    public void checkDayNightModifier(IWerewolfPlayer werewolfPlayer) {
        PlayerEntity player = werewolfPlayer.getRepresentingPlayer();
        boolean night = Helper.isNight(player.func_130014_f_());
        for (Modifier attribute : this.attributes) {
            if (player.func_110148_a(attribute.attribute).func_111127_a(!night ? attribute.nightUuid : attribute.dayUuid) == null) continue;
            this.removeModifier(werewolfPlayer);
            this.applyModifier(werewolfPlayer);
        }
    }

    public void applyModifier(IWerewolfPlayer werewolf) {
        PlayerEntity player = werewolf.getRepresentingPlayer();
        boolean night = Helper.isNight(player.func_130014_f_());
        for (Modifier attribute : this.attributes) {
            ModifiableAttributeInstance ins = player.func_110148_a(attribute.attribute);
            if (ins == null || ins.func_111127_a(attribute.dayUuid) != null) continue;
            ins.func_233769_c_(attribute.create(werewolf, night));
        }
    }

    public void removeModifier(IWerewolfPlayer werewolf) {
        PlayerEntity player = werewolf.getRepresentingPlayer();
        for (Modifier attribute : this.attributes) {
            ModifiableAttributeInstance ins = player.func_110148_a(attribute.attribute);
            if (ins == null) continue;
            ins.func_188479_b(attribute.dayUuid);
            ins.func_188479_b(attribute.nightUuid);
        }
    }

    public int getDuration(int level) {
        return 0x7FFFFFFE;
    }

    public boolean canBeUsedBy(IWerewolfPlayer player) {
        if (Helper.isFullMoon(player.getRepresentingPlayer().func_130014_f_()) && Helper.isFormActionActive(player)) {
            return false;
        }
        if (Helper.isFormActionActive(player) && !player.getActionHandler().isActionActive((ILastingAction)this)) {
            return false;
        }
        return player.getRepresentingPlayer().field_70170_p.func_226691_t_(player.getRepresentingEntity().func_233580_cy_()) == ModBiomes.werewolf_heaven || (double)WerewolfFormAction.getDurationPercentage(player) > 0.3 || player.getActionHandler().isActionActive((ILastingAction)this);
    }

    protected static class Modifier {
        public final Attribute attribute;
        public final UUID dayUuid;
        public final UUID nightUuid;
        public final String name;
        public final Function<IWerewolfPlayer, Double> value;
        public final AttributeModifier.Operation operation;
        public final double dayModifier;

        public Modifier(Attribute attribute, UUID dayUuid, UUID nightUuid, double dayModifier, String name, Supplier<Double> valueFunction, AttributeModifier.Operation operation) {
            this(attribute, dayUuid, nightUuid, dayModifier, name, (IWerewolfPlayer player) -> (Double)valueFunction.get(), operation);
        }

        public Modifier(Attribute attribute, UUID dayUuid, UUID nightUuid, double dayModifier, String name, Supplier<Double> valueFunction, Supplier<Double> extendedValueFunction, ISkill extendedSkill, AttributeModifier.Operation operation) {
            this(attribute, dayUuid, nightUuid, dayModifier, name, (IWerewolfPlayer player) -> player.getSkillHandler().isSkillEnabled(extendedSkill) ? (Double)extendedValueFunction.get() : (Double)valueFunction.get(), operation);
        }

        public Modifier(Attribute attribute, UUID dayUuid, UUID nightUuid, double dayModifier, String name, Function<IWerewolfPlayer, Double> valueFunction, AttributeModifier.Operation operation) {
            this.attribute = attribute;
            this.dayUuid = dayUuid;
            this.nightUuid = nightUuid;
            this.name = name;
            this.value = valueFunction;
            this.operation = operation;
            this.dayModifier = dayModifier;
        }

        public AttributeModifier create(IWerewolfPlayer player, boolean night) {
            return new AttributeModifier(night ? this.nightUuid : this.dayUuid, this.name, night ? this.value.apply(player) : this.value.apply(player) * this.dayModifier, this.operation);
        }
    }
}

