/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.proxy;

import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.werewolves.client.core.ClientEventHandler;
import de.teamlapen.werewolves.client.core.ModBlocksRenderer;
import de.teamlapen.werewolves.client.core.ModKeys;
import de.teamlapen.werewolves.client.core.ModScreens;
import de.teamlapen.werewolves.client.core.WEntityRenderer;
import de.teamlapen.werewolves.client.core.WItemRenderer;
import de.teamlapen.werewolves.client.core.WerewolvesHUDOverlay;
import de.teamlapen.werewolves.client.render.RenderHandler;
import de.teamlapen.werewolves.network.AttackTargetEventPacket;
import de.teamlapen.werewolves.proxy.CommonProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
extends CommonProxy {
    private WerewolvesHUDOverlay hudOverlay;
    private ClientEventHandler clientHandler;
    private boolean autoJump;

    public ClientProxy() {
        RenderHandler renderHandler = new RenderHandler(Minecraft.func_71410_x());
        MinecraftForge.EVENT_BUS.register((Object)renderHandler);
        if (Minecraft.func_71410_x() != null) {
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)renderHandler);
        }
    }

    @Override
    public void onInitStep(IInitListener.Step step, ParallelDispatchEvent event) {
        super.onInitStep(step, event);
        switch (step) {
            case CLIENT_SETUP: {
                WEntityRenderer.registerEntityRenderer();
                ModBlocksRenderer.register();
                this.clientHandler = new ClientEventHandler();
                MinecraftForge.EVENT_BUS.register((Object)this.clientHandler);
                this.hudOverlay = new WerewolvesHUDOverlay();
                MinecraftForge.EVENT_BUS.register((Object)this.hudOverlay);
                ModKeys.register(this.clientHandler);
                FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onTextureStitchEvent);
                break;
            }
            case LOAD_COMPLETE: {
                WItemRenderer.registerColors();
                ModScreens.registerScreens();
            }
        }
    }

    @Override
    public void handleAttackTargetEventPacket(AttackTargetEventPacket packet) {
        this.hudOverlay.attackTriggered(packet.entityId);
    }

    public void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        event.addSprite(new ResourceLocation("werewolves", PlayerContainer.field_226616_d_.func_110623_a()));
        event.addSprite(new ResourceLocation("werewolves", PlayerContainer.field_226617_e_.func_110623_a()));
        event.addSprite(new ResourceLocation("werewolves", PlayerContainer.field_226618_f_.func_110623_a()));
        event.addSprite(new ResourceLocation("werewolves", PlayerContainer.field_226619_g_.func_110623_a()));
    }
}

