/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.util;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.werewolves.player.IWerewolfPlayer;
import de.teamlapen.werewolves.player.werewolf.actions.WerewolfFormAction;
import de.teamlapen.werewolves.util.WReference;
import de.teamlapen.werewolves.util.WerewolfDamageSource;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Helper
extends de.teamlapen.vampirism.util.Helper {
    public static boolean isWerewolf(Entity entity) {
        return WReference.WEREWOLF_FACTION.equals((Object)VampirismAPI.factionRegistry().getFaction(entity));
    }

    public static boolean isWerewolf(PlayerEntity entity) {
        return VampirismAPI.getFactionPlayerHandler((PlayerEntity)entity).map(h -> WReference.WEREWOLF_FACTION.equals((Object)h.getCurrentFaction())).orElse(false);
    }

    public static boolean hasFaction(Entity entity) {
        if (VampirismAPI.factionRegistry().getFaction(entity) != null) {
            return true;
        }
        return Helper.isWerewolf(entity);
    }

    public static BlockPos multiplyBlockPos(BlockPos pos, double amount) {
        return new BlockPos((double)pos.func_177958_n() * amount, (double)pos.func_177956_o() * amount, (double)pos.func_177952_p() * amount);
    }

    public static boolean canBecomeWerewolf(PlayerEntity player) {
        return FactionPlayerHandler.getOpt((PlayerEntity)player).map(v -> v.canJoin(WReference.WEREWOLF_FACTION)).orElse(false);
    }

    public static boolean isNight(World world) {
        long time = world.func_72820_D() % 24000L;
        return !world.func_230315_m_().func_241514_p_() && time > 12786L && time < 23216L;
    }

    public static boolean isFullMoon(World world) {
        long time = world.func_72820_D() % 192000L;
        return !world.func_230315_m_().func_241514_p_() && time > 12786L && time < 23216L;
    }

    public static Map<Item, Integer> getMissingItems(IInventory inventory, Item[] items, int[] amount) {
        int i;
        HashMap<Item, Integer> missing = new HashMap<Item, Integer>();
        for (i = 0; i < items.length; ++i) {
            missing.put(items[i], amount[i]);
        }
        for (i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            missing.computeIfPresent(stack.func_77973_b(), (item, amount1) -> amount1 - stack.func_190916_E());
        }
        missing.entrySet().removeIf(s -> (Integer)s.getValue() <= 0);
        return missing;
    }

    public static boolean isFormActionActive(IWerewolfPlayer player) {
        return WerewolfFormAction.isWerewolfFormActionActive((IActionHandler<IWerewolfPlayer>)player.getActionHandler());
    }

    public static WerewolfDamageSource causeWerewolfDamage(String cause, Entity entity) {
        return new WerewolfDamageSource(cause, entity);
    }

    public static WerewolfDamageSource causeWerewolfDamage(PlayerEntity entity) {
        return Helper.causeWerewolfDamage("player", (Entity)entity);
    }
}

