/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.world;

import de.teamlapen.vampirism.api.entity.CaptureEntityEntry;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.event.VampirismVillageEvent;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.werewolves.entities.werewolf.IVillagerTransformable;
import de.teamlapen.werewolves.entities.werewolf.WerewolfTransformable;
import de.teamlapen.werewolves.util.WReference;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WWorldEventHandler {
    @SubscribeEvent
    public void onVillageCaptureFinish(VampirismVillageEvent.VillagerCaptureFinish.Pre event) {
        World world = ((TileEntity)event.getTotem()).func_145831_w();
        List werewolves = world.func_175647_a(MobEntity.class, event.getVillageArea(), entity -> entity instanceof WerewolfTransformable);
        if (WReference.WEREWOLF_FACTION.equals((Object)event.getControllingFaction())) {
            werewolves.forEach(e -> {
                if (e instanceof IVillagerTransformable) {
                    ((IVillagerTransformable)e).setWerewolfFaction(true);
                } else if (((WerewolfTransformable)e).canTransform()) {
                    ((WerewolfTransformable)e).transformBack();
                } else if (event.isForced()) {
                    this.spawnEntity(world, this.getCaptureEntity(event.getCapturingFaction(), world), (MobEntity)e, true);
                }
            });
        } else {
            for (MobEntity werewolf : werewolves) {
                if (!(werewolf instanceof IVillagerTransformable)) continue;
                ((IVillagerTransformable)werewolf).transformBack();
                ((IVillagerTransformable)werewolf).setWerewolfFaction(false);
            }
        }
    }

    @SubscribeEvent
    public void onVillageSpawnNewVillager(VampirismVillageEvent.SpawnNewVillager event) {
        if (event.getControllingFaction() == WReference.WEREWOLF_FACTION) {
            ((IVillagerTransformable)event.getNewVillager()).setWerewolfFaction(true);
        }
    }

    @SubscribeEvent
    public void onVillageReplaceBlock(VampirismVillageEvent.ReplaceBlock event) {
        if (event.getState().func_177230_c() == ModBlocks.cursed_earth) {
            ((TileEntity)event.getTotem()).func_145831_w().func_175656_a(event.getBlockPos(), ((TileEntity)event.getTotem()).func_145831_w().func_226691_t_(event.getBlockPos()).func_242440_e().func_242502_e().func_204108_a());
        }
    }

    @SubscribeEvent
    public void onVillageMakeAggressive(VampirismVillageEvent.MakeAggressive event) {
        if (event.getControllingFaction() == WReference.WEREWOLF_FACTION) {
            event.setCanceled(true);
            ((IVillagerTransformable)event.getOldVillager()).transformToWerewolf();
        }
    }

    private void spawnEntity(World world, MobEntity newEntity, MobEntity oldEntity, boolean replaceOld) {
        newEntity.func_180432_n((Entity)oldEntity);
        newEntity.func_184221_a(MathHelper.func_188210_a());
        if (replaceOld) {
            oldEntity.func_70106_y();
        }
        world.func_217376_c((Entity)newEntity);
    }

    private MobEntity getCaptureEntity(IFaction<?> faction, World world) {
        List entry = faction.getVillageData().getCaptureEntries();
        return (MobEntity)((CaptureEntityEntry)WeightedRandom.func_76271_a((Random)world.func_201674_k(), (List)entry)).getEntity().func_200721_a(world);
    }
}

