/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.world.config.BetterMineshaftFeatureConfiguration;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.BetterMineshaftPiece;
import com.yungnickyoung.minecraft.yungsapi.world.BoundingBoxHelper;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;

public class SmallTunnelTurn
extends BetterMineshaftPiece {
    private final TurnDirection turnDirection;
    private static final int SECONDARY_AXIS_LEN = 5;
    private static final int Y_AXIS_LEN = 5;
    private static final int MAIN_AXIS_LEN = 5;
    private static final int LOCAL_X_END = 4;
    private static final int LOCAL_Y_END = 4;
    private static final int LOCAL_Z_END = 4;

    public SmallTunnelTurn(CompoundTag compoundTag) {
        super(BetterMineshaftStructurePieceType.SMALL_TUNNEL_TURN, compoundTag);
        this.turnDirection = TurnDirection.valueOf(compoundTag.m_128451_("TurnDirection"));
    }

    public SmallTunnelTurn(int chunkPieceLen, Random random, BoundingBox blockBox, Direction direction, BetterMineshaftFeatureConfiguration config) {
        super(BetterMineshaftStructurePieceType.SMALL_TUNNEL_TURN, chunkPieceLen, config, blockBox);
        this.m_73519_(direction);
        this.turnDirection = random.nextBoolean() ? TurnDirection.LEFT : TurnDirection.RIGHT;
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        super.m_183620_(structurePieceSerializationContext, compoundTag);
        compoundTag.m_128405_("TurnDirection", this.turnDirection.value);
    }

    public static BoundingBox determineBoxPosition(StructurePieceAccessor structurePieceAccessor, Random random, int x, int y, int z, Direction direction) {
        BoundingBox blockBox = BoundingBoxHelper.boxFromCoordsWithRotation((int)x, (int)y, (int)z, (int)5, (int)5, (int)5, (Direction)direction);
        StructurePiece intersectingPiece = structurePieceAccessor.m_141921_(blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void m_142537_(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, Random random) {
        Direction direction = this.m_73549_();
        if (direction == null) {
            return;
        }
        Direction nextDirection = this.turnDirection == TurnDirection.LEFT ? direction.m_122428_() : direction.m_122427_();
        switch (nextDirection) {
            default: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, nextDirection, this.f_73384_);
                break;
            }
            case SOUTH: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_(), this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, nextDirection, this.f_73384_);
                break;
            }
            case WEST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_(), nextDirection, this.f_73384_);
                break;
            }
            case EAST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), nextDirection, this.f_73384_);
            }
        }
    }

    public void m_183269_(WorldGenLevel world, StructureFeatureManager structureFeatureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        Direction direction = this.m_73549_();
        this.chanceReplaceNonAir(world, box, random, this.config.replacementRate, 0, 1, 0, 4, 4, 4, this.config.blockStateRandomizers.mainRandomizer);
        this.chanceReplaceNonAir(world, box, random, this.config.replacementRate, 0, 0, 0, 4, 0, 4, this.config.blockStateRandomizers.floorRandomizer);
        this.fill(world, box, 1, 1, 0, 3, 3, 3, AIR);
        this.replaceAirOrChains(world, box, 1, 0, 0, 3, 0, 3, this.config.blockStates.mainBlockState);
        this.fill(world, box, 2, 1, 0, 2, 1, 1, Blocks.f_50156_.m_49966_());
        if (this.turnDirection == TurnDirection.LEFT) {
            if (direction == Direction.NORTH || direction == Direction.EAST) {
                this.generateLeftTurn(world, box);
            } else {
                this.generateRightTurn(world, box);
            }
        } else if (direction == Direction.NORTH || direction == Direction.EAST) {
            this.generateRightTurn(world, box);
        } else {
            this.generateLeftTurn(world, box);
        }
        this.addBiomeDecorations(world, box, random, 0, 0, 0, 4, 3, 4);
        this.addVines(world, box, random, this.config.decorationChances.vineChance, 1, 0, 1, 3, 4, 3);
        this.generatePillarsOrChains(world, box, random);
    }

    private void generateLeftTurn(WorldGenLevel world, BoundingBox box) {
        this.fill(world, box, 0, 1, 1, 0, 3, 3, AIR);
        this.replaceAirOrChains(world, box, 0, 0, 1, 0, 0, 3, this.config.blockStates.mainBlockState);
        this.fill(world, box, 2, 1, 2, 2, 1, 2, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)RailShape.SOUTH_WEST));
        this.fill(world, box, 0, 1, 2, 1, 1, 2, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)RailShape.EAST_WEST));
    }

    private void generateRightTurn(WorldGenLevel world, BoundingBox box) {
        this.fill(world, box, 4, 1, 1, 4, 3, 3, AIR);
        this.replaceAirOrChains(world, box, 4, 0, 1, 4, 0, 3, this.config.blockStates.mainBlockState);
        this.fill(world, box, 2, 1, 2, 2, 1, 2, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)RailShape.SOUTH_EAST));
        this.fill(world, box, 3, 1, 2, 4, 1, 2, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)RailShape.EAST_WEST));
    }

    private void generatePillarsOrChains(WorldGenLevel world, BoundingBox box, Random random) {
        this.generatePillarDownOrChainUp(world, random, box, 1, 0, 1);
        this.generatePillarDownOrChainUp(world, random, box, 3, 0, 1);
        this.generatePillarDownOrChainUp(world, random, box, 1, 0, 3);
        this.generatePillarDownOrChainUp(world, random, box, 3, 0, 3);
    }

    public static enum TurnDirection {
        LEFT(0),
        RIGHT(1);

        private final int value;

        private TurnDirection(int value) {
            this.value = value;
        }

        public static TurnDirection valueOf(int value) {
            return Arrays.stream(TurnDirection.values()).filter(dir -> dir.value == value).findFirst().get();
        }
    }
}

