/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_5819;

public class ItemRandomizer {
    public static final Codec<ItemRandomizer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Entry.CODEC.listOf().fieldOf("entries").forGetter(randomizer -> randomizer.entries), (App)class_2378.field_11142.method_39673().fieldOf("defaultItem").forGetter(randomizer -> randomizer.defaultItem)).apply((Applicative)instance, ItemRandomizer::new));
    private List<Entry> entries = new ArrayList<Entry>();
    private class_1792 defaultItem = class_1802.field_8162;

    public class_2487 saveTag() {
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10569("defaultItemId", class_2378.field_11142.method_10206((Object)this.defaultItem));
        class_2499 entriesTag = (class_2499)class_156.method_654((Object)new class_2499(), tag -> this.entries.forEach(entry -> {
            class_2487 entryTag = new class_2487();
            entryTag.method_10569("entryItemId", class_2378.field_11142.method_10206((Object)entry.item));
            entryTag.method_10548("entryChance", entry.probability);
            tag.add((Object)entryTag);
        }));
        compoundTag.method_10566("entries", (class_2520)entriesTag);
        return compoundTag;
    }

    public ItemRandomizer(class_2487 compoundTag) {
        this.defaultItem = (class_1792)class_2378.field_11142.method_10200(compoundTag.method_10550("defaultItemId"));
        this.entries = new ArrayList<Entry>();
        class_2499 entriesTag = compoundTag.method_10554("entries", 10);
        entriesTag.forEach(entryTag -> {
            class_2487 entryCompoundTag = (class_2487)entryTag;
            class_1792 item = (class_1792)class_2378.field_11142.method_10200(entryCompoundTag.method_10550("entryItemId"));
            float chance = entryCompoundTag.method_10583("entryChance");
            this.addItem(item, chance);
        });
    }

    public ItemRandomizer(List<Entry> entries, class_1792 defaultItem) {
        this.entries = entries;
        this.defaultItem = defaultItem;
    }

    public ItemRandomizer(class_1792 defaultItem) {
        this.defaultItem = defaultItem;
    }

    public ItemRandomizer() {
    }

    public static ItemRandomizer from(class_1792 ... items) {
        ItemRandomizer selector = new ItemRandomizer();
        float chance = 1.0f / (float)items.length;
        for (class_1792 item : items) {
            selector.addItem(item, chance);
        }
        return selector;
    }

    public ItemRandomizer addItem(class_1792 item, float chance) {
        if (this.entries.stream().anyMatch(entry -> entry.item.equals(item))) {
            YungsApiCommon.LOGGER.warn("WARNING: duplicate item {} added to ItemSetSelector!", (Object)item.toString());
            return this;
        }
        float currTotal = this.entries.stream().map(entry -> Float.valueOf(entry.probability)).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
        float newTotal = currTotal + chance;
        if (newTotal > 1.0f) {
            YungsApiCommon.LOGGER.warn("WARNING: item {} added to ItemSetSelector exceeds max probabiltiy of 1!", (Object)item.toString());
            return this;
        }
        this.entries.add(new Entry(item, chance));
        return this;
    }

    public class_1792 get(Random random) {
        float target = random.nextFloat();
        float currBottom = 0.0f;
        for (Entry entry : this.entries) {
            if (currBottom <= target && target < currBottom + entry.probability) {
                return entry.item;
            }
            currBottom += entry.probability;
        }
        return this.defaultItem;
    }

    public class_1792 get(class_5819 randomSource) {
        float target = randomSource.method_43057();
        float currBottom = 0.0f;
        for (Entry entry : this.entries) {
            if (currBottom <= target && target < currBottom + entry.probability) {
                return entry.item;
            }
            currBottom += entry.probability;
        }
        return this.defaultItem;
    }

    public void setDefaultItem(class_1792 item) {
        this.defaultItem = item;
    }

    public Map<class_1792, Float> getEntriesAsMap() {
        HashMap<class_1792, Float> map = new HashMap<class_1792, Float>();
        this.entries.forEach(entry -> map.put(entry.item, Float.valueOf(entry.probability)));
        return map;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public class_1792 getDefaultItem() {
        return this.defaultItem;
    }

    public static class Entry {
        public static Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2378.field_11142.method_39673().fieldOf("item").forGetter(entry -> entry.item), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(entry -> Float.valueOf(entry.probability))).apply((Applicative)instance, Entry::new));
        public class_1792 item;
        public float probability;

        public Entry(class_1792 item, float probability) {
            this.item = item;
            this.probability = probability;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                return this.item.equals(((Entry)obj).item);
            }
            if (obj instanceof class_1792) {
                return this.item.equals(obj);
            }
            return false;
        }
    }
}

