/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.adaptivebrightness.config;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_437;

public class Config {
    public static double max_gamma = 1.0;
    public static double min_gamma = 0.0;
    public static boolean disabled = false;

    public static class_437 init(class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)new class_2588("title.adaptivebrightness.config"));
        ConfigCategory general = builder.getOrCreateCategory((class_2561)new class_2588("category.adaptivebrightness.general"));
        int max_gamma_percent = (int)(max_gamma * 100.0);
        int min_gamma_percent = (int)(min_gamma * 100.0);
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        general.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)new class_2588("option.adaptivebrightness.max_gamma"), max_gamma_percent, 0, 100).setDefaultValue(100).setTooltip(new class_2561[]{new class_2588("option.adaptivebrightness.max_gamma.tooltip")}).setSaveConsumer(newValue -> {
            max_gamma = (double)newValue.intValue() / 100.0;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)new class_2588("option.adaptivebrightness.min_gamma"), min_gamma_percent, 0, 100).setDefaultValue(0).setTooltip(new class_2561[]{new class_2588("option.adaptivebrightness.min_gamma.tooltip")}).setSaveConsumer(newValue -> {
            min_gamma = (double)newValue.intValue() / 100.0;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)new class_2588("option.adaptivebrightness.disabled"), disabled).setDefaultValue(disabled).setTooltip(new class_2561[]{new class_2588("option.adaptivebrightness.disabled.tooltip")}).setSaveConsumer(newValue -> {
            disabled = newValue;
        }).build());
        builder.setSavingRunnable(() -> {
            FileWriter fileWriter;
            try {
                fileWriter = new FileWriter("config/adaptivebrightness.conf");
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.printf("max %f\n", max_gamma);
            printWriter.printf("min %f\n", min_gamma);
            printWriter.printf("disabled %b\n", disabled);
            printWriter.close();
        });
        return builder.build();
    }

    public static void load() throws IOException {
        String line;
        FileReader configFile;
        try {
            configFile = new FileReader("config/adaptivebrightness.conf");
        }
        catch (FileNotFoundException ignored) {
            return;
        }
        BufferedReader reader = new BufferedReader(configFile);
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("max ")) {
                max_gamma = Double.parseDouble(line.split("max ")[1]);
                continue;
            }
            if (line.startsWith("min ")) {
                min_gamma = Double.parseDouble(line.split("min ")[1]);
                continue;
            }
            if (!line.startsWith("disable ")) continue;
            disabled = Boolean.parseBoolean(line.split("disable ")[1]);
        }
        System.out.println(max_gamma);
        System.out.println(min_gamma);
        System.out.println(disabled);
    }
}

