/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.config;

import blue.endless.jankson.Comment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0003\u001b\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR*\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ljuuxel/adorn/config/Config;", "", "()V", "client", "Ljuuxel/adorn/config/Config$Client;", "getClient", "()Ljuuxel/adorn/config/Config$Client;", "setClient", "(Ljuuxel/adorn/config/Config$Client;)V", "compat", "", "", "", "getCompat", "()Ljava/util/Map;", "setCompat", "(Ljava/util/Map;)V", "extraPieces", "Ljuuxel/adorn/config/Config$EPConfig;", "gameRuleDefaults", "Ljuuxel/adorn/config/Config$GameRuleDefaults;", "getGameRuleDefaults", "()Ljuuxel/adorn/config/Config$GameRuleDefaults;", "setGameRuleDefaults", "(Ljuuxel/adorn/config/Config$GameRuleDefaults;)V", "protectTradingStations", "sittingOnTables", "Client", "EPConfig", "GameRuleDefaults", "Adorn"})
public final class Config {
    @Comment(value="If true, you can sit on tables.")
    @JvmField
    public boolean sittingOnTables;
    @Comment(value="Protects trading stations from other players.")
    @JvmField
    public boolean protectTradingStations = true;
    @Comment(value="Client-side settings")
    @NotNull
    private Client client = new Client();
    @Comment(value="Default values for game rules in new worlds")
    @NotNull
    private GameRuleDefaults gameRuleDefaults = new GameRuleDefaults();
    @Comment(value="Mod compatibility toggles (enabled: true, disabled: false)")
    @NotNull
    private Map<String, Boolean> compat = new HashMap();
    @Comment(value="Configuration for Adorn's Extra Pieces support.")
    @JvmField
    @NotNull
    public EPConfig extraPieces = new EPConfig();

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    public final void setClient(@NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"<set-?>");
        this.client = client;
    }

    @NotNull
    public final GameRuleDefaults getGameRuleDefaults() {
        return this.gameRuleDefaults;
    }

    public final void setGameRuleDefaults(@NotNull GameRuleDefaults gameRuleDefaults) {
        Intrinsics.checkNotNullParameter((Object)gameRuleDefaults, (String)"<set-?>");
        this.gameRuleDefaults = gameRuleDefaults;
    }

    @NotNull
    public final Map<String, Boolean> getCompat() {
        return this.compat;
    }

    public final void setCompat(@NotNull Map<String, Boolean> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.compat = map;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Ljuuxel/adorn/config/Config$Client;", "", "()V", "showItemsInStandardGroups", "", "getShowItemsInStandardGroups", "()Z", "setShowItemsInStandardGroups", "(Z)V", "showTradingStationTooltips", "getShowTradingStationTooltips", "setShowTradingStationTooltips", "Adorn"})
    public static final class Client {
        @Comment(value="If true, floating tooltips are shown above trading stations.")
        private boolean showTradingStationTooltips = true;
        @Comment(value="If true, Adorn items will also be shown in matching vanilla item tabs.")
        private boolean showItemsInStandardGroups = true;

        public final boolean getShowTradingStationTooltips() {
            return this.showTradingStationTooltips;
        }

        public final void setShowTradingStationTooltips(boolean bl) {
            this.showTradingStationTooltips = bl;
        }

        public final boolean getShowItemsInStandardGroups() {
            return this.showItemsInStandardGroups;
        }

        public final void setShowItemsInStandardGroups(boolean bl) {
            this.showItemsInStandardGroups = bl;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ljuuxel/adorn/config/Config$EPConfig;", "", "()V", "carpetedEverything", "", "carpetedPieceSets", "", "", "enabled", "toweletteSupport", "Adorn"})
    public static final class EPConfig {
        @Comment(value="If true, Adorn's EP support is enabled. You can disable it by setting this property to false.")
        @JvmField
        public boolean enabled = true;
        @Comment(value="If true, Adorn's Towelette support will be enabled for EP blocks. (warning: resource heavy)")
        @JvmField
        public boolean toweletteSupport;
        @Comment(value="If true, enables carpeting for all Adorn chair and table piece blocks (warning: resource heavy).")
        @JvmField
        public boolean carpetedEverything;
        @Comment(value="A list of piece sets that will have carpeting support.")
        @JvmField
        @NotNull
        public List<String> carpetedPieceSets = new ArrayList();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ljuuxel/adorn/config/Config$GameRuleDefaults;", "", "()V", "skipNightOnSofas", "", "getSkipNightOnSofas", "()Z", "setSkipNightOnSofas", "(Z)V", "Adorn"})
    public static final class GameRuleDefaults {
        @Comment(value="If true, sleeping on sofas can skip the night.")
        private boolean skipNightOnSofas = true;

        public final boolean getSkipNightOnSofas() {
            return this.skipNightOnSofas;
        }

        public final void setSkipNightOnSofas(boolean bl) {
            this.skipNightOnSofas = bl;
        }
    }
}

